package com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout;

import lombok.Getter;

import java.util.Objects;

/**
 * 设计器layout 页面类型枚举类
 *
 * @Author: yanfeng
 * @Date: 2023/10/19
 */
@Getter
public enum LayoutComponentTypeEnum {
    /**
     * 主页面
     */
    MAIN_PAGE("set-up-page"),

    /**
     * 单头
     */
    SINGLE_HEAD("set-up-form"),

    ;

    private final String value;

    LayoutComponentTypeEnum(String value) {
        this.value = value;
    }

    public static LayoutComponentTypeEnum getEnumByValue(String value) {
        for (LayoutComponentTypeEnum testedEnum : LayoutComponentTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
