package com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.ocr.InputOcr;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotLayoutJsonDeserializer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotQueryApi;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.group.UiBotGroupPrototype;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>功能描述：UI Bot数据的Layout模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotLayout
 * @Author: Zaregoto
 * @Date: 2021/4/20 16:05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UiBotLayout extends UiBotBizFieldBase {
    private static final long serialVersionUID = 1499339937497996502L;

    /**
     * 数据源路径，对应pageData中的属性名称。
     * 需对path、schema一起确定目标字段
     * from 智驱2023-S2-需求#10117
     */
    private String path;
    private List<String> schemas;
    private List<String> relationSchemas;
    private String id;
    private Boolean editable;
    private List<UiBotGroupPrototype> groupPrototype;

    @JsonDeserialize(contentUsing = PcUiBotLayoutJsonDeserializer.class)
    private List<UiBotLayout> group;
    @JsonDeserialize(contentUsing = PcUiBotLayoutJsonDeserializer.class)
    private List<UiBotLayout> tabs;

    private List<UiBotQueryButton> queryButtons;
    private Boolean checkbox;
    private Boolean checkboxMerge;
    private List<UiBotTableColumnDefinition> columnDefs;
    private List details;
    /**
     * 字段操作定义配置
     */
    private JSONArray operations;
    private List<UiBotTableScriptFilter> scriptFilters;
    private Map<String, Object> setting;
    private List<UiBotLayout> detailModel;
    private List<UiBotLayoutField> fields;
    /**
     * athena中，若pc无法使用标准前端画出画面，则为定制页面。定制页面的操作数据，会在当前layout内配置对应的actions
     */
    private List<UiBotAction> actions;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Map<String, Object> data;

    /**
     * athena中，若pc无法使用标准前端画出画面，则为定制页面。定制页面提交完成的结果，会在以下两个字段内表示
     */
    private Boolean finished;
    private String finishedTitle;

    private JSONObject attribute;
    private String currencyField;

    private String headerName;
    private String label;

    /**
     * 支持新增删除时使用，每组的唯一标识
     */
    private String groupId;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean important = false;

    private List<UiBotFieldOption> options;
    private Map<String, UiBotQueryApi> queryCurrencyApi;
    private Map<String, String> queryCurrencyAPIReturnFields;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean thousandthPercentile = false;
    private String title;

    //是否主表格
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean isMainTable;

    /**
     * web端布局排列方式，row:行,column:列
     */
    private String direction;

    /*********************************************************************************************
     * ******************************** web端图表特有属性 BEGIN ************************************
     *********************************************************************************************/
    /**
     * web端图表的 option
     */
    private List<JSONObject> option;

    /*********************************************************************************************
     * ******************************** web端图表特有属性 END **************************************
     *********************************************************************************************/


    /*********************************************************************************************
     * ******************************** 移动端特有属性 BEGIN ****************************************
     *********************************************************************************************/

    private String area;
    /**
     * 内容的组件类型
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String mContentType;

    /**
     * 自定义业务标识
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String mBizKey;

    /**
     * 子级layout
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private List<UiBotLayout> mChildren;

    /**
     * Tab页签的滚动模式
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Integer mScrollMode;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean mMajor;

    /**
     * 组件摆放的位置参数
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentPositionEnum
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Integer mPosition;

    /**
     * 全选操作的提示文字
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String mSelectAllText;

    /**
     * 提交按钮的样式类型
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.SubmitButtonTypeEnum
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Integer mSubmitType;

    /**
     * 标题组件中标签内容相对标题的位置
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Integer mLabelPosition;

    /**
     * 字段文字标注的多语言数据，移动端特定情况下使用。
     * 2021年12月11日更新：
     * 目前仅在pageId=MOBILE_ATHENA_SSC_EMPLOYEE_ATTEN_CONFIRM_TASK_DETAIL的生成逻辑中使用过
     * <p>
     * map的key表示语言别，参考<code>Locale</code>类。value表示对应语言别下的文字值
     *
     * @see java.util.Locale
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Map<String, String> mLabelText;

    /**
     * 当layout为列表类型时，指明列表中每个item的操作方式
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataItemActionTypeEnum
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Integer mItemActionType;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String mItemActionErrorMessage;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private UiBotModel mItemButtonLayoutModel;

    private Integer ocrType;

    /**
     * 是否支持输入显示
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Boolean showInput;

    /**
     * 字段显示的提示
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String placeholder;

    /*********************************************************************************************
     * ******************************** 移动端特有属性 END *****************************************
     *********************************************************************************************/

    public UiBotLayout(String type) {
        this.type = type;
    }

    public UiBotLayout(String schema, String type) {
        this.schema = schema;
        this.type = type;
    }

    public UiBotLayout(String schema, String type, String area) {
        this.schema = schema;
        this.type = type;
        this.area = area;
    }

    /**
     * 当前layout是否为表格
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isTypeOfTable() {
        /**
         * TABLE
         * GRID_TABLE
         * ATHENA_TABLE
         */
        return null != this.getType() && this.getType().toUpperCase().contains("TABLE");
    }

    /**
     * 当前layout是否为表单
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isTypeOfFormList() {
        return "FORM_LIST".equalsIgnoreCase(this.getType());
    }

    /**
     * 当前layout是否为分组
     *
     * @return
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isTypeOfGroupOrder() {
        return "GROUP_ORDER".equalsIgnoreCase(this.getType());
    }

    public List<UiBotLayout> decomposeFieldsWithPcFormList(List<Rule> mobileRuleList) {
        if (!this.isTypeOfFormList()) {
            return Collections.emptyList();
        }
        if (this.getGroup().isEmpty()) {
            return Collections.emptyList();
        }
        List<UiBotLayout> result = new ArrayList<>();
        for (UiBotLayout uiBotLayout : this.getGroup()) {
            result.addAll(this.decomposeFields(uiBotLayout, mobileRuleList));
        }
        return result;
    }

    public List<UiBotLayout> decomposeFieldsWithApprovalDescription(List<Rule> mobileRuleList) {
        if (!this.getType().equalsIgnoreCase("APPROVAL_DESCRIPTION")) {
            return Collections.emptyList();
        }
        if (this.getGroup().isEmpty()) {
            return Collections.emptyList();
        }
        List<UiBotLayout> result = new ArrayList<>();
        for (UiBotLayout uiBotLayout : this.getGroup()) {
            result.addAll(this.decomposeFields(uiBotLayout, mobileRuleList));
        }
        return result;
    }

    private List<UiBotLayout> decomposeFields(UiBotLayout uiBotLayout, List<Rule> mobileRuleList) {
        List<UiBotLayout> result = new ArrayList<>();
        if (null != uiBotLayout.getGroup() && !uiBotLayout.getGroup().isEmpty()) {
            // todo SSC 定制如果是身份证(ID_CARD)/银行卡(BANK_CARDS),则不在向下拆解
            boolean isOcrType = false;
            for (UiBotLayout subUiBotLayout : uiBotLayout.getGroup()) {
                if (!CollectionUtils.isEmpty(mobileRuleList)) {
                    for (Rule rule : mobileRuleList) {
                        if (rule.getMappingConfig() != null && rule.getMappingConfig().getSearchFieldType().equals(subUiBotLayout.getType())) {
                            uiBotLayout.setSchema(rule.getSchema());
                            uiBotLayout.setMContentType(InputOcr.COMPONENT_TYPE);
                            uiBotLayout.setOcrType(rule.getMappingConfig().getCardType());
                            isOcrType = true;
                            break;
                        }
                    }
                }
            }
            if (isOcrType) {
                result.add(uiBotLayout);
            } else {
                for (UiBotLayout subUiBotLayout : uiBotLayout.getGroup()) {
                    result.addAll(this.decomposeFields(subUiBotLayout, mobileRuleList));
                }
            }
        } else {
            result.add(uiBotLayout);
        }
        return result;
    }

    public UiBotTableColumn parseToTableColumn() {
        UiBotTableColumn uiBotTableColumn = new UiBotTableColumn();
        uiBotTableColumn.setSchema(this.getSchema());
        uiBotTableColumn.setHeaderName(this.getHeaderName());
        uiBotTableColumn.setType(this.getType());
        uiBotTableColumn.setDataType(this.getDataType());
        uiBotTableColumn.setEditable(this.getEditable());
        uiBotTableColumn.setAttribute(JsonUtil.objectToJavaObject(this.getAttribute(), UiBotTableAttachmentColumnAttribute.class));
        uiBotTableColumn.setOcrType(this.getOcrType());
        uiBotTableColumn.setMContentType(this.mContentType);
        UiBotTableColumnEditor columnEditor = new UiBotTableColumnEditor();
        columnEditor.setOptions(JsonUtil.objectToJavaObject(this.getOptions(), new TypeReference<List<UiBotTableColumnEditorOption>>() {
        }));
        columnEditor.setSchema(this.getSchema());
        columnEditor.setType(this.getType());
        uiBotTableColumn.setEditor(columnEditor);

        if (this.group != null) {
            List<UiBotTableColumn> uiBotTableColumns = new ArrayList<>(this.group.size());
            for (UiBotLayout uiBotLayout : this.group) {
                uiBotTableColumns.add(uiBotLayout.parseToTableColumn());
            }
            uiBotTableColumn.setColumns(uiBotTableColumns);
        }
        return uiBotTableColumn;
    }


    public Map<String, Object> parseExecuteContextToRawData(UiBotLayout uiBotFieldLayout, UiBotExecuteContext executeContext) {
        Map<String, Object> rawData = new HashMap<>(8);
        if (uiBotFieldLayout.getOperations() != null && uiBotFieldLayout.getOperations().size() > 0) {
            JSONObject operation = uiBotFieldLayout.getOperations().getJSONObject(0);
            rawData.put("dataSourceSet",
                    operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
            rawData.put("defaultShow",
                    operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
            JSONObject executeContextObj =
                    operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
            if (executeContextObj != null) {
                rawData.put("executeContext", executeContextObj);
            } else {
                rawData.put("executeContext", executeContext);
            }
            rawData.put("multipleSelect",
                    operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
            rawData.put("selectedFirstRow",
                    operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
            rawData.put("queryTagSuffix", "DIALOG");
            rawData.put("buttons",
                    operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
        }
        return rawData;
    }

    public String getOperationsTitle(UiBotLayout uiBotFieldLayout) {
        String title = "";
        if (uiBotFieldLayout.getOperations() != null && uiBotFieldLayout.getOperations().size() > 0) {
            JSONObject operation = uiBotFieldLayout.getOperations().getJSONObject(0);
            title = operation.getString("title");
        }
        return title;
    }

    /**
     * 根据字段的数据类型及展示类型，返回字段的值的文字展示内容
     *
     * @param bizData
     * @return
     */
    @Override
    public String getValueForDisplay(Map<String, Object> bizData) {
        return this.parseToTableColumn().getValueForDisplay(bizData);
    }

    public Boolean getIsMainTable() {
        return isMainTable != null ? isMainTable : false;
    }

    public void setIsMainTable(Boolean isMainTable) {
        this.isMainTable = isMainTable;
    }

    public Map<String, String> getmLabelText() {
        return mLabelText;
    }

    public void setmLabelText(Map<String, String> mLabelText) {
        this.mLabelText = mLabelText;
    }

    @Override
    public boolean canEdit() {
        return Boolean.TRUE.equals(this.editable);
    }

    @Override
    public void doSetCanEdit() {
        this.editable = true;
    }

    @Override
    public void doSetCanNotEdit() {
        this.editable = false;
    }

    @Override
    public void reverseEditableState() {
        if (this.canEdit()) {
            this.doSetCanNotEdit();
        } else {
            this.doSetCanEdit();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UiBotLayout that = (UiBotLayout) o;
        return Objects.equals(schemas, that.schemas) &&
                Objects.equals(relationSchemas, that.relationSchemas) &&
                Objects.equals(id, that.id) &&
                Objects.equals(editable, that.editable) &&
                Objects.equals(groupPrototype, that.groupPrototype) &&
                Objects.equals(group, that.group) &&
                Objects.equals(queryButtons, that.queryButtons) &&
                Objects.equals(checkbox, that.checkbox) &&
                Objects.equals(checkboxMerge, that.checkboxMerge) &&
                Objects.equals(columnDefs, that.columnDefs) &&
                Objects.equals(details, that.details) &&
                Objects.equals(operations, that.operations) &&
                Objects.equals(scriptFilters, that.scriptFilters) &&
                Objects.equals(setting, that.setting) &&
                Objects.equals(detailModel, that.detailModel) &&
                Objects.equals(fields, that.fields) &&
                Objects.equals(actions, that.actions) &&
                Objects.equals(finished, that.finished) &&
                Objects.equals(finishedTitle, that.finishedTitle) &&
                Objects.equals(attribute, that.attribute) &&
                Objects.equals(currencyField, that.currencyField) &&
                Objects.equals(headerName, that.headerName) &&
                Objects.equals(label, that.label) &&
                Objects.equals(important, that.important) &&
                Objects.equals(options, that.options) &&
                Objects.equals(queryCurrencyApi, that.queryCurrencyApi) &&
                Objects.equals(queryCurrencyAPIReturnFields, that.queryCurrencyAPIReturnFields) &&
                Objects.equals(thousandthPercentile, that.thousandthPercentile) &&
                Objects.equals(title, that.title) &&
                Objects.equals(isMainTable, that.isMainTable) &&
                Objects.equals(area, that.area) &&
                Objects.equals(mContentType, that.mContentType) &&
                Objects.equals(mBizKey, that.mBizKey) &&
                Objects.equals(mChildren, that.mChildren) &&
                Objects.equals(mScrollMode, that.mScrollMode) &&
                Objects.equals(mMajor, that.mMajor) &&
                Objects.equals(mPosition, that.mPosition) &&
                Objects.equals(mSelectAllText, that.mSelectAllText) &&
                Objects.equals(mSubmitType, that.mSubmitType) &&
                Objects.equals(mLabelPosition, that.mLabelPosition) &&
                Objects.equals(mLabelText, that.mLabelText) &&
                Objects.equals(mItemActionType, that.mItemActionType) &&
                Objects.equals(mItemActionErrorMessage, that.mItemActionErrorMessage) &&
                Objects.equals(mItemButtonLayoutModel, that.mItemButtonLayoutModel) &&
                Objects.equals(ocrType, that.ocrType) &&
                Objects.equals(showInput, that.showInput) &&
                Objects.equals(placeholder, that.placeholder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), schemas, relationSchemas, id, editable, groupPrototype, group, queryButtons, checkbox, checkboxMerge, columnDefs, details, operations, scriptFilters, setting, detailModel, fields, actions, finished, finishedTitle, attribute, currencyField, headerName, label, important, options, queryCurrencyApi, queryCurrencyAPIReturnFields, thousandthPercentile, title, isMainTable, area, mContentType, mBizKey, mChildren, mScrollMode, mMajor, mPosition, mSelectAllText, mSubmitType, mLabelPosition, mLabelText, mItemActionType, mItemActionErrorMessage, mItemButtonLayoutModel, ocrType, showInput, placeholder);
    }
}
