package com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.analyzer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer.LabelFieldAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.group.UiBotGroupPrototype;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotDArrayAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/17 15:10
 */
@Component("uibotDArrayAnalyzer")
public class UiBotDArrayAnalyzer implements LayoutAnalyzer<String> {

    private static final Logger logger = LoggerFactory.getLogger(UiBotDArrayAnalyzer.class);

    public static final String LAYOUT_TYPE = "D_ARRAY";
    public static final String LAYOUT_TYPE_TWO = "LINE_TABLE";

    private static final String FIELD_RESULT_TEMPLATE = "%s: %s";

    private static final String LAYOUT_TYPE_CHECK_ERROR_MSG = String.format(
            "Only %s type field can be anaylyzed", LAYOUT_TYPE);

    @Autowired
    private LabelFieldAnalyzer labelFieldAnalyzer;

    @Override
    public String analyze(UiBotLayout layout, UiBotPageData pageData,
                          Class<String> clazz) {
        Assert.notNull(layout, "layout must not be null");
        Assert.isTrue(LAYOUT_TYPE.equalsIgnoreCase(layout.getType()) ||
                LAYOUT_TYPE_TWO.equalsIgnoreCase(layout.getType()), LAYOUT_TYPE_CHECK_ERROR_MSG);

        String pageDataKey = layout.getSchema();
        Object pageDataValue = pageData.get(pageDataKey);
        boolean pageDataValueIsList = pageDataValue instanceof List;

        if (LAYOUT_TYPE.equalsIgnoreCase(layout.getType())) {
            StringBuffer sbResult = new StringBuffer(512);
            for (UiBotGroupPrototype groupPrototype : layout.getGroupPrototype()) {
                String type = groupPrototype.getType();

                Assert.isTrue("GROUP".equalsIgnoreCase(type), "must group type!");
                for (UiBotLayout fieldLayout : groupPrototype.getGroup()) {
                    if (LabelFieldAnalyzer.FIELD_TYPE.equalsIgnoreCase(fieldLayout.getType())) {
                        if (pageDataValueIsList) {
                            JSONArray pageDataValueArray = (JSONArray) JSONArray.toJSON(pageDataValue);
                            pageDataValueArray.forEach(valObj -> {
                                sbResult.append(this.labelFieldAnalyzer.analyze(
                                        fieldLayout, (JSONObject) JSONObject.toJSON(valObj), pageData, false));
                            });
                        } else {
                            sbResult.append(this.labelFieldAnalyzer.analyze(
                                    fieldLayout, (JSONObject) JSONObject.toJSON(pageDataValue), pageData, false));
                        }
                    }
                    if (sbResult.length() > 0) {
                        sbResult.append(" ");
                    }
                }
            }
            return sbResult.subSequence(0, sbResult.length() - 1).toString();
        } else if (LAYOUT_TYPE_TWO.equalsIgnoreCase(layout.getType())) {
            List<UiBotTableColumnDefinition> columnDefs = layout.getColumnDefs();
            if (columnDefs != null && columnDefs.size() > 0) {
                String columnSchema = columnDefs.get(0).getSchema();
                if (pageDataValueIsList) {
                    JSONArray pageDataValueArray = (JSONArray) JSONArray.toJSON(pageDataValue);
                    if (pageDataValueArray != null && pageDataValueArray.size() > 0) {
                        JSONObject pageDataObj = pageDataValueArray.getJSONObject(0);
                        return (String) pageDataObj.get(columnSchema);
                    }
                }
            }
        }
        return "";
    }
}
