package com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot运行时-开窗定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotOpenWindowDefineDTO
 * @Author: Zaregoto
 * @Date: 2023/2/27 14:55
 */
@Data
public class PcUiBotOpenWindowDefineDTO implements Serializable {

    private static final long serialVersionUID = -2300065353670673893L;
    private String title;
    private String style;
    private PcUiBotPageDefine getDataAction;
    private List<PcUiBotPageDefine> getDataActions;
    private String category;
    private List<PcUiBotReturnFields> returnFields;

    private PcUiBotPageDefine suggestAction;

    private PcUiBotPageDefine allAction;

    /**
     * 强制选择第一行
     */
    private Boolean selectedFirstRow;

    /**
     * 是否多选
     */
    private Boolean multipleSelect;

    /**
     * 多开窗合并规则
     */
    private List<String> mergeKey;

    /**
     * 按钮定义
     */
    private List<PcUiBotOpenWindowDefineButtonDTO> buttons;

    /**
     * 提交按钮，适用于删除等Operation操作
     */
    private List<PcUiBotSubmitAction> submitActions;

    private Boolean isCustomize;

    /**
     * 作用于数组类型数据上，目前只在表单中使用
     */
    private Boolean applyToArray;

    /**
     * 数组类型数据上, 将回显字段放在该字段名对应的集合中
     */
    private String applyToField;

    /**
     * ture 支待批量开窗；false 不支持；
     */
    private Boolean supportBatch;

    /**
     * 执行者关注
     */
    private List<String> roleAttention;

    /**
     * true开启分页，
     * false不开启分页（默认为不开启）
     */
    private Boolean useHasNext;

    /**
     * 是否启用高级搜索
     * true开启组合查询，（默认为开启）
     * false不开组合查询
     */
    private Boolean enableAdvancedSearch;

    /**
     * 是否启用api搜索
     * true开启查询调用API，
     * false不开启调用API（默认为不开启）
     */
    private Boolean enableSearchByApi;

    /**
     * 参数入参类型
     * p1s1新增，实现“5207多档作业中，单身开窗入参支持单头字段”的需求
     */
    private String parameterType;

    /**
     * 开窗中，标示【主数据来源】数据的字段名称
     */
    private String primaryField;

    /**
     * 用于存于界面设计器中开窗的DSL
     */
    private List<Object> layout;

    /**
     * 数据视图布局
     */
    private PcUiBotTmViewShowFields viewShowFields;

    /**
     * 回填字段是否回显配置
     */
    private List<PcUiBotTmOperationOpenWindowDefine.PcUiBotTmOperationOpenWindowDefineField> fields;

    // 开窗下钻配置
    private UiBotAction mobileDrilDown;
    // 开窗排序配置
    private List<PcUiBotTmOperationOpenWindowDefine.SortInfo> mobileSortInfo;
}
