package com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.AddCardTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的操作实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmOperation
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotTmOperation implements Serializable {
    private static final long serialVersionUID = 5695255725893800338L;

    private String id;
    private String type;
    private int sequence;
    /**
     * TODO: xuxx 没看到有透传
     */
    private int priority;
    private String title;
    private String name;

    private Object description;

    /**
     * 控制样式：默认在下面
     */

    private String position;

    private String icon;

    private Boolean display;
    private List<String> cleanFields;

    /**
     * 导出排除字段
     * 类型:table-export 使用
     */
    private List<String> exportExcludeFields;

    private String targetDetailField;
    /**
     * 对比字段--自动拆行使用
     */
    private String comparisonField;

    /**
     * 拆分规则脚本--自动拆行使用
     */
    private String ruleScript;

    /**
     * 拆分规则脚本，错误信息--自动拆行使用
     */
    private Object ruleMessage;

    private String sequenceField;

    /**
     * 目标数据源
     */
    private String target;
    /**
     * 存在的值：row/all/line
     */
    private String mode;
    /**
     * 不为空且mode等row，表示操作放到某个字段中，为空表示放在行内或其他地方 line
     */
    private String applyToField;

    /**
     * 当为mode为all时有效，
     * true:对过滤后的数据进行操作
     * 默认为false，针对全部数据操作，可不配
     */
    private Boolean afterFilter;

    /**
     * 任务已关闭，是否还需要apply该operation
     */
    private Boolean applyAlthoughFinished;

    /**
     * 操作脚本 类似按钮执行脚本
     */
    private String operateScript;

    /**
     * table 前端二次过滤脚本
     */
    private PcUiBotTmOperationScriptCondition operationScriptCondition;

    /**
     * 操作类型:open-task-window, openWindow
     */
    private String operate;

    /**
     * 操作辅助信息 删除行使用到
     */
    private String operateTarget;
    /**
     * 弹窗 定义
     */
    private PcUiBotTmOperationOpenWindowDefine openWindowDefine;

    private PcUiBotTmOperationAPIDefine apiDefine;

    /**
     * 提交数据逻辑
     */
    private PcUiBotTmAction submitAction;

    /**
     * 编辑器，已经过期，后续统一使用editor，支持动态创建组件
     */
    @Deprecated
    private PcUiBotEditorDefineDTO editorDefine;

    /**
     * TODO:未使用
     */
    private Map<String, Object> editor;

    /**
     * TODO:未使用
     * 发票
     */
    private List<PcUiBotReturnFields> backFills;

    /**
     * 扩展字段信息
     */
    private Map<String, Object> extendedFields;

    /**
     * 确认提示框信息
     */
    private JSONObject confirm;

    /**
     * 是否是客制 ture：是客制；false：非客制（默认不填为非客制）
     */
    private Boolean isCustomize;

    /**
     * 客制类型
     */
    private String customType;

    /**
     * TODO:可以去掉，暂无作用
     */
    private String schema;

    /**
     * form_list中group tag的标记
     */
    private String tagGroup;

    /**
     * 用于标记开窗是否需要排他
     * true：需要排他
     * false:不需要排他
     * 可以不配，不配默认false
     */
    private Boolean disabledSelected;

    /**
     * 用于存放显示和隐藏回填参数
     */
    private List<Map<String, Object>> fields;

    /**
     * 是否启用刷新界面
     * true开启，需要刷新界面，
     * false不开启，不刷新（默认为不开启）
     */
    private Boolean enableReload;

    /**
     * 是否显示在页签上
     * true 显示
     * false 不显示（不配置时默认为不显示）
     */
    private Boolean enableToolShow;

    /**
     * 是否需要operation可用的条件
     * 应用配置表达式：
     * false禁用
     * true 启用（默认不配置为启用）
     */
    private String condition;

    /**
     * 触发时机，与condition一起使用才有效
     * init ：初始化，默认或不配置时为init
     * dataChanged：数据变化时
     * 即将废弃，使用triggerList
     */
    @Deprecated
    private String trigger;

    /**
     * 多个触发时机；作用同trigger
     */
    private List<String> triggerList;

    /**
     * 隐藏条件
     */
    private PcUiBotTmCondition hidden;

    /**
     * 是否开启自由新增行（默认开启，为false时关闭）
     */
    private Boolean openFreedomAddRow;

    /**
     * navigateTarget---跳转列
     * 该字段为array，支持指向多个字段
     * 如果是所有列支持跳转，该字段为array[0]配置成"all"
     */
    private List<String> navigateTarget;

    /**
     * 多语言配置。key是当前操作对象的某个属性，值是一个对象，包含支持的语言内容。
     * 示例数据如下：
     * "language": {
     * "description": {
     * "zh_TW": "選擇品號",
     * "en_US": "Choose item no",
     * "zh_CN": "选择品号"
     * },
     * "title": {
     * "zh_TW": "品號",
     * "en_US": "Change",
     * "zh_CN": "品号"
     * }
     * },
     */
    private JSONObject language;

    /**
     * 多语言配置。与language属性作用与格式相同。
     */
    private JSONObject lang;

    /**
     * 页签
     */
    private List<PcUiBotTmTab> tabs;

    /**
     * 子页签（子单身）是否可以数据翻页（上一页、下一页）,
     */
    private Boolean switchData;

    /**
     * 是否是主按钮；允许有多个主按钮；默认false
     */
    private Boolean isMainButton;

    /**
     * 是否为整单操作：
     * true是，false否(不配或默认为false)
     */
    private Boolean isToolBar;

    /**
     * 复制操作的相关配置
     */
    private List<PcUiBotCopyOperationConfig> copyConfigs;

    // 不同type下，对应不同结构
    private Object setting;

    /**
     * 默认为true
     *
     * @return
     */
    public Boolean getSwitchData() {
        return switchData == null || switchData;
    }

    /**
     * 获取触发时机；
     * 为了向前兼容：如果存在trigger，则将trigger转为集合返回；否则返回triggerList
     *
     * @return 触发时机集合
     */
    public List<String> getTriggerList() {
        if (StringUtils.isNotBlank(trigger)) {
            return Lists.newArrayList(trigger);
        }
        return triggerList;
    }

    @Data
    public static
    class CardListAddObj {

        /**
         * 设计器新增属性--添加card方式类型--默认1
         * 1：开弹窗或页面新增数据（默认），2：使用模板在当前页面新增数据
         * 注意：新增卡片场景下有效，并只在编辑的卡片列表中有效
         *
         * @see com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.AddCardTypeEnum
         */
        private Integer addCardType = AddCardTypeEnum.OPEN_PAGE_ADD.getValue();


        /**
         * 设计器：新增card按钮开关
         */
        private Boolean canAddOrEditCard;
        /**
         * 设计器：新增card按钮：设计态设计的结构
         */
        private UiBotAction addCardButton;

        /**
         * 底部是否展示新增数据按钮，true为展示，false为隐藏，默认为false
         */
        private Boolean canShowBottom = false;
    }
}

