package com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的开窗操作定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmOperationOpenWindowDefine
 * @Author: zaregoto
 * @Date: 2023/2/26 20:01
 */
@Data
@NoArgsConstructor
public class PcUiBotTmOperationOpenWindowDefine implements Serializable {
    private static final long serialVersionUID = -4894609772113556588L;

    /**
     * 开窗显示标题；必填
     */
    private String title;

    /**
     * 弹出框样式；必填
     */
    private String style;

    /**
     * 强制选择第一行，默认false；非必填
     */
    private Boolean selectedFirstRow;

    /**
     * 是否多选，默认false；非必填
     */
    private Boolean multipleSelect;

    /**
     * 按什么字段来合并，已废弃；非必填
     */
    @Deprecated
    private List<String> mergeKey;

    /**
     * 迭代11 弃用 需要兼容老的
     */
    private PcUiBotTmQueryAction getDataAction;

    /**
     * 迭代11 弃用 需要兼容老的
     */
    private PcUiBotTmQueryAction suggestAction;

    /**
     * 迭代11 弃用 需要兼容老的
     */
    private PcUiBotTmQueryAction allAction;

    /**
     * 迭代11 启用
     */
    private List<PcUiBotTmQueryAction> getDataActions;

    /**
     * 提交按钮
     */
    private List<PcUiBotTmOperationOpenWindowDefineButton> buttons;
    /**
     * 是否要多选
     */
    private PcUiBotSubmitType submitType;
    /**
     * 提交ACTION
     */
    private List<PcUiBotTmAction> submitActions;

    /**
     *
     */
    private String category;

    /**
     * 迭代11 弃用 需要兼容老的
     */
    private List<PcUiBotReturnFields> returnFields;

    /**
     * 是否为定制，主要用于基础资料双档维护客制界面；非必填
     */
    private Boolean isCustomize;

    /**
     * 作用于数组类型字段上，用于多选开窗，当多选开窗时为true，默认为false；非必填
     */
    private Boolean applyToArray;

    /**
     * 数组类型数据上, 将回显字段放在该字段名对应的集合中
     */
    private String applyToField;

    /**
     * 执行者关注；当前角色关注的字段；非必填
     */
    private List<String> roleAttention;

    /**
     * ture：支待批量开窗；false：不支持（默认）；非必填
     */
    private Boolean supportBatch;

    /**
     * true开启分页，
     * false不开启分页（默认为不开启）；非必填
     */
    private Boolean useHasNext;

    /**
     * 是否启用高级搜索
     * true开启组合查询，
     * false不开组合查询（默认为不开启）；非必填
     */
    private Boolean enableAdvancedSearch;

    /**
     * 是否启用api搜索
     * true开启查询调用API，
     * false不开启调用API（默认为不开启）；非必填
     */
    private Boolean enableSearchByApi;

    /**
     * 参数入参类型
     * p1s1新增，实现“5207多档作业中，单身开窗入参支持单头字段”的需求；非必填
     */
    private String parameterType;

    /**
     * 开窗中，标示【主数据来源】数据的字段名称；必填
     */
    private String primaryField;

    /**
     * 用于存于界面设计器中开窗的DSL；非必填
     */
    private List<Object> layout;

    /**
     * 回填字段是否回显配置
     */
    private List<PcUiBotTmOperationOpenWindowDefineField> fields;

    @Data
    public static class PcUiBotTmOperationOpenWindowDefineField {
        private String schema;
        // 是否回显 ， true：回显，false：否
        private Boolean show;
    }

    // 开窗下钻配置
    private UiBotAction mobileDrilDown;
    // 开窗排序配置
    private List<SortInfo> mobileSortInfo;

    @Data
    public static class SortInfo {
        // 排序字段
        private String sortField;
        // 排序类型，asc：升序，desc：降序
        private String sortType;
        // 排序字段的数据类型 string、number、date
        private String dataType;
        // 排序顺序
        private Integer sortSeq = 1;
    }
}