package com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的开窗操作内按钮定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmOperationOpenWindowDefineButton
 * @Author: zaregoto
 * @Date: 2023/2/26 20:01
 */
@Data
@NoArgsConstructor
public class PcUiBotTmOperationOpenWindowDefineButton implements Serializable {
    private static final long serialVersionUID = 2492629393164934339L;

    /**
     * 按钮ID
     */
    private String id;

    /**
     * 按钮名称
     */
    private String title;

    /**
     * 执行action
     */
    private List<PcUiBotTmAction> actions;

    /**
     * 多语言配置。key是当前操作对象的某个属性，值是一个对象，包含支持的语言内容。
     * 示例数据如下：
     * "language": {
     * "description": {
     * "zh_TW": "選擇品號",
     * "en_US": "Choose item no",
     * "zh_CN": "选择品号"
     * },
     * "title": {
     * "zh_TW": "品號",
     * "en_US": "Change",
     * "zh_CN": "品号"
     * }
     * },
     */
    private JSONObject language;

    /**
     * 多语言配置。与language属性作用与格式相同。
     */
    private JSONObject lang;
}
