package com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule;

import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotMaxLengthRuleAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/6/17 16:57
 */
@Component("uiBotMaxLengthRuleAnalyzer")
public class UiBotMaxLengthRuleAnalyzer implements UiBotRuleAnalyzer<Integer> {

    private static final Integer MAX_LENGTH = 999999999;

    private static final Map<String, Integer> DEFAULT_COLUMN_TO_ANALYZE = new HashMap<>();

    static {
        DEFAULT_COLUMN_TO_ANALYZE.put("work_hours", 6);
        DEFAULT_COLUMN_TO_ANALYZE.put("complete_rate", 3);
    };

    @Override public String getRuleKey() {
        return "maxLength";
    }

    @Override public Integer analyzeByDefault(UiBotRule rule) {
        if (DEFAULT_COLUMN_TO_ANALYZE.containsKey(rule.getSchema())) {
            return DEFAULT_COLUMN_TO_ANALYZE.get(rule.getSchema());
        }
        return MAX_LENGTH;
    }

    @Override public Integer analyze(UiBotRule rule) {
        Assert.notNull(rule, "rule cannot be null.");
        if (!rule.getKey().equalsIgnoreCase(this.getRuleKey())) {
            return MAX_LENGTH;
        }
        if (rule.getParameter().contains("(") || rule.getParameter().contains(")")) {
            return MAX_LENGTH;
        }
        return Integer.parseInt(rule.getParameter());
    }
}
