package com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerDataCacheScope;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerValidatorType;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.RelationFieldInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：UI Bot数据的Rule模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotRule
 * @Author: Zaregoto
 * @Date: 2021/4/20 16:10
 */
@Data
public class UiBotRule implements Serializable {
    private static final long serialVersionUID = -4845117447507789743L;

    /**
     * {
     * "schema": "complete_rate",
     * "targetSchema": "actual_finish_date",
     * "path": "project_info",
     * "condition": "data.complete_rate < 1 || data.complete_rate > 1",
     * "key": "disabled"
     * }
     * 上述规则含义：
     * 1. 规则设置在complete_rate这个栏位上
     * 2. 如果complete_rate不等于1条件成立，则disabled掉actual_finish_date栏位，使它不可用
     */

    private String path;
    // 规则设置的栏位，这个字段的值有变动，就触发规则
    private String schema;
    // 规则应用的字段
    private String targetSchema;
    // 规则的类别
    private String key;
    private String description;
    private String condition;
    private String parameter;
    private String errorMessage;

    /**
     * 规则的适用范围。目前见到的内容有：EDIT-表示本规则在录入时使用
     * 规则的适用范围、阶段
     *
     * @see ValidateRuleScopeEnum
     */
    private String scope;

    //规则联动的字段，这些字段的变更都会引起规则的执行，适用于除了value, defaultValue, connection外的其它所有规则
    private String[] linkageSchemas;

    /**
     * 枚举类型，校验类型
     *
     * @see DesignerValidatorType
     */
    private String validatorType;

    /**
     * 是否跨字段，用于具有Array的数据结构上，如果true，规则加path所在数据上，反之，规则加在schema上。
     * 默认值：false
     */
    private Boolean crossFieldOrNot;

    //多语言
    private JSONObject lang;

    //多语言
    private JSONObject language;

    //错误信息表达式，支持js表达式
    private String errorMessageExpression;

    /**
     * 提交时错误信息全部显示，只针对validatorType为warning警告类型的信息
     * 默认值：false
     */
    private Boolean errorMessageSubmitTipShowAll;

    //规则触发机制
    private DesignerTrigger trigger;

    //规则触发的产生联动的设定，针对connection规则
    private List<RelationFieldInfo> relations;

    /**
     * 当’connection’规则时，定义与其他组件的是否联动，默认true联动其他组件，false只触发自己，这个通常用在自执行的场景，比如select选项过滤，初始化就执行
     * 默认值：true
     */
    private Boolean relationIsLinkage;

    /**
     * 无需设定，含义是当前视图是否是批量提交，自动从uibot返回的action中获取
     * 默认值：false
     */
    private Boolean isBatch;

    //无需设定，含义是全局参数，自动从uibot返回的数据中获取
    private Object globalParameter;

    /**
     * 启用debugger
     * 默认值：false
     */
    private Boolean enableDebugger;

    //rowDefaultValue规则生效，只存在于表格中，给一行赋默认值，值为js脚本
    private String valueScript;

    /**
     * value规则生效，初始值时需要执行，value规则默认是值变更后才执行
     * 默认值：true
     */
    private Boolean initValueNeedExecute;

    /**
     * 枚举类型，规则异步缓存范围，page：页面级、cell：单元格，none：不缓存
     * 默认值：cell
     *
     * @see DesignerDataCacheScope
     */
    private Object asyncCacheScope;

    /**
     * repeat规则使用，忽略旧值
     * 默认值：false
     */
    private Boolean ignoreOldValue;

    private String name;

    /**
     * 是否生效
     */
    private Boolean effective;

    /**
     * 组件id
     */
    private String componentId;

    /**
     * pageId
     */
    private String pageId;
}