package com.digiwin.mobile.mobileuibot.proxy.uibot.model.table;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotTableColumnDefinition
 * @Author: Zaregoto
 * @Date: 2021/5/24 2:06
 */
@Data
@NoArgsConstructor
public class UiBotTableColumnDefinition implements Serializable {
    private static final long serialVersionUID = -411207186214386217L;

    private List<UiBotTableColumn> columns;
    private String description;
    private String headerName;
    private List operations;
    private String schema;

    public static List<UiBotTableColumn> decomposeTableColumnDefinitions(List<UiBotTableColumnDefinition> columnDefinitionList) {
        List<UiBotTableColumn> result = new ArrayList<>();

        for (UiBotTableColumnDefinition tableColumnDefinition : columnDefinitionList) {
            if (null != tableColumnDefinition.getColumns() && !tableColumnDefinition.getColumns().isEmpty()) {
                result.addAll(UiBotTableColumnDefinition.decomposeTableColumn(tableColumnDefinition.getColumns()));
            } else {
                // 不会发生该情况，在UiBotTableColumnDefinition下一定会有UiBotTableColumnd存在。留空方便理解逻辑。
            }
        }
        return result;
    }

    public static List<UiBotTableColumn> decomposeTableColumn(List<UiBotTableColumn> tableColumns) {
        List<UiBotTableColumn> result = new ArrayList<>();
        for (UiBotTableColumn tableColumn : tableColumns) {
            if (null != tableColumn.getColumns() && !tableColumn.getColumns().isEmpty()) {
                result.addAll(UiBotTableColumnDefinition.decomposeTableColumn(tableColumn.getColumns()));
            } else {
                result.add(tableColumn);
            }
        }
        return result;
    }

    public void addUiBotTableColumn(UiBotTableColumn uiBotTableColumn) {
        if (null == this.getColumns()) {
            this.setColumns(new ArrayList<>());
        }
        this.getColumns().add(uiBotTableColumn);
    }

}
