package com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot使用的Tag定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTagDefinition
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotTagDefinition implements Serializable {
    private static final long serialVersionUID = -3608158907746326409L;

    /**
     * tag 编码
     */
    private String code;

    /**
     * tag的父类集合
     */
    private List<String> parentTagNames;

    /**
     * 显示名称
     */
    private Object title;

    /**
     * tag 名称
     */
    private String name;


    /**
     * tag 描述
     */
    private String description;

    /**
     * 类型
     * BUSINESS
     * GROUP
     * ORDER
     */
    private String category;

    /**
     * 解析服务名称
     */
    private String interpreterServiceName;

    /**
     * 规则定义
     */
    private PcUiBotTagRuleDefinition ruleDefinition;

    /**
     * 标签图标设置
     */
    private PcUiBotTagIconDefinition icon;

    /**
     * 开关参数设置
     */
    private PcUiBotTagSwitchParameter switchParameter;

    /**
     * 权重值 主要用于排斥属性 优先使用哪个TAG上的值
     */
    private Integer executionWeight;


    /**
     * 是否是自定义，如果是自定义标签，那么只是显示，权重为0
     * 1.权重值0
     * 2.如果有其他标签存在 直接废弃
     * 3.如果只有本标签，那么就是只是单独显示使用，不做任何处理
     */
    private Boolean customize;

    /**
     * 应用到字段  不在UI-BOT 运行时处理
     */
    private String applyTo;

    /**
     * 扩展信息
     */
    private Map<String, Object> extendedInfo;

    /**
     * 多语言
     */
    private Object lang;
    /**
     * TM定义的编码
     */
    private String tmTagCode;

//    /**
//     * 显示的名称
//     */
//    private String tmTagTitle;
//
//    /**
//     * 值
//     */
//    private String tmTagValue;

//    /**
//     * 是否显示group 下面栏位是否显示标题
//     */
//    private String tmGroupFieldShowTitle;

    /**
     * 在字段上打的tag
     */
    private PcUiBotThemeMapTag themeMapTag;

    /**
     * 是否椒默认的tag
     */
    @JsonIgnore
    private boolean defaultTag;

    /**
     * 是否累加
     */
    private boolean append;

    public String toString() {
        return code;
    }

    public PcUiBotTagDefinition clone() {
        PcUiBotTagDefinition newTagDefinition = new PcUiBotTagDefinition();
        cloneValue(newTagDefinition);
        return newTagDefinition;
    }

    protected void cloneValue(PcUiBotTagDefinition newTagDefinition) {
        newTagDefinition.setTitle(this.getTitle());
        newTagDefinition.setCode(this.getCode());
        newTagDefinition.setIcon(this.getIcon());
        newTagDefinition.setName(this.getName());
        newTagDefinition.setDescription(this.getDescription());
        newTagDefinition.setCategory(this.getCategory());
        newTagDefinition.setInterpreterServiceName(this.getInterpreterServiceName());
        newTagDefinition.setRuleDefinition(this.getRuleDefinition());
        newTagDefinition.setSwitchParameter(this.getSwitchParameter());
        newTagDefinition.setExecutionWeight(this.getExecutionWeight());
        newTagDefinition.setApplyTo(this.getApplyTo());
        newTagDefinition.setCustomize(this.getCustomize());
        newTagDefinition.setExtendedInfo(this.getExtendedInfo());
    }
}
