package com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱保存的标签</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotThemeMapTag
 * @Author: Zaregoto
 * @Date: 2021/5/27 15:31
 */
@Data
@NoArgsConstructor
public class PcUiBotThemeMapTag implements Serializable {
    private static final long serialVersionUID = -35049619653214080L;

    /**
     * tm-ID
     */
    private Long id;

    /**
     * tm-标签名称 目前分组才用到
     */
    private String name;

    /**
     * tm-编码
     * 当category = APPLICATION时，code为应用的code
     */
    private String code;

    /**
     * 类型
     * BUSINESS
     * GROUP
     * ORDER
     * APPLICATION,当为应用时，code为应用的code
     */
    private String category;

    /**
     * 设计时保存-处理的值
     */
    private String value;

    /**
     * 设计时保存-显示名称
     */
    private String title;

    /**
     * 是否强制显示tag上定义的标题
     */
    private Boolean customTitle;

    /**
     * ai-编码
     */
    private String uiBotCode;

    /**
     * 是否显示group 下面栏位是否显示标题
     */
    private String groupFieldShowTitle;


    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;
    /**
     * P4S2引入 ：
     * 扩展属性
     * 将原有的tag-definition中的tag的extendedInfo移至由Tag/Query返回
     */
    private Map<String, Object> extendedInfo;

    /**
     * 声明空标签
     *
     * @return
     */
    public static PcUiBotThemeMapTag empty() {
        PcUiBotThemeMapTag tag = new PcUiBotThemeMapTag();
        tag.setCode(StrUtil.NULL);
        return tag;
    }

    /**
     * 是否为空标签
     *
     * @return
     */
    public static boolean isEmpty(PcUiBotThemeMapTag tag) {
        return tag == null || StrUtil.NULL.equals(tag.getCode());
    }
}
