package com.digiwin.mobile.mobileuibot.proxy.uibot.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * TABLE、GROUP_ORDER类型解析后拆分的数据
 *
 * @author zhangjj
 * @date 2021/12/2 0002 17:20
 */
@Data
public class ParseFieldData implements Serializable {
    private static final long serialVersionUID = -5614260775164309502L;

    private String schema;

    private String label;

    /**
     * value的数据展示类型(来自pc uibot)
     * string：字符串类型，对应value字段
     * numeric：数值类型，对应oldNum、newNum字段
     */
    private String dataType;

    /**
     * (来自pc uibot)
     */
    private String type;

    private Object data;
    private Boolean isEdit;

    private List<UiBotTableColumnEditorOption> options;

    public ParseFieldData() {
    }

    public static ParseFieldData getFieldData(UiBotTableColumn column, Object data) {
        ParseFieldData fieldData = new ParseFieldData();
        fieldData.setSchema(column.getSchema());
        fieldData.setDataType(column.getDataType());
        fieldData.setType(column.getType());
        fieldData.setLabel(column.getHeaderName());
        fieldData.setData(data);
        if (column.getEditor() != null && column.getEditor().getOptions() != null) {
            fieldData.setOptions(column.getEditor().getOptions());
        }
        if (column.canEdit()) {
            fieldData.setIsEdit(column.canEdit());
        }
        return fieldData;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public List<UiBotTableColumnEditorOption> getOptions() {
        return options;
    }

    public void setOptions(List<UiBotTableColumnEditorOption> options) {
        this.options = options;
    }
}
