package com.digiwin.mobile.mobileuibot.proxy.uibot.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * pc端uiBot,ATHENA_TABLE、TABLE、GROUP_ORDER类型数据表格解析数据
 *
 * @author zhangjj
 * @date 2021/12/2 0002 17:15
 */
public class TableUiBotParser {

    /**
     * 解析TABLE、GROUP_ORDER类型Layout数据
     *
     * @param uiBotLayout
     * @param uiBotPageData
     * @param hasParentSchema 是否有父布局组件对应的schema字段
     * @return Map中key值为schema
     */
    public static List<List<ParseFieldData>> parseTableUiBotData(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData, boolean hasParentSchema) {
        if (!uiBotLayout.isTypeOfTable() && !uiBotLayout.isTypeOfGroupOrder()) {
            //layout类型不匹配
            return new ArrayList<>();
        }
        String layoutPath = uiBotLayout.getPath();
        String layoutSchema = uiBotLayout.getSchema();

        List<UiBotTableColumn> columnList = new ArrayList<>();
        if (uiBotLayout.isTypeOfGroupOrder()) {
            columnList = getColumnListFromGroupOrderLayout(uiBotLayout);
        } else if (uiBotLayout.isTypeOfTable()) {
            columnList = getColumnListFromTableLayout(uiBotLayout);
        }
        List<Map<String, Object>> pageData = (List<Map<String, Object>>) uiBotPageData
                .getBizDataByPathAndSchema(layoutPath, layoutSchema, hasParentSchema);
        List<List<ParseFieldData>> fieldDataListList = new ArrayList<>();

        if (pageData == null || pageData.isEmpty()) {
            return fieldDataListList;
        }
        List<UiBotTableColumn> finalColumnList = columnList;
        pageData.forEach(pageDataItem -> {
            List<ParseFieldData> fieldDataList = new ArrayList<>();
            for (UiBotTableColumn column : finalColumnList) {
                fieldDataList.add(ParseFieldData.getFieldData(column, pageDataItem.get(column.getSchema())));
            }
            fieldDataListList.add(fieldDataList);
        });
        return fieldDataListList;
    }

    /**
     * 解析TABLE、GROUP_ORDER类型Layout数据
     *
     * @param uiBotLayout
     * @param uiBotPageData
     * @return Map中key值为schema
     */
    public static List<List<ParseFieldData>> parseTableUiBotData(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData) {
        return TableUiBotParser.parseTableUiBotData(uiBotLayout, uiBotPageData, false);
    }

    /**
     * 获取GROUP_ORDER类型layout中的UiBotTableColumn
     *
     * @param uiBotLayout
     * @return
     */
    private static List<UiBotTableColumn> getColumnListFromGroupOrderLayout(UiBotLayout uiBotLayout) {
        List<UiBotLayout> detailModelList = uiBotLayout.getDetailModel();
        if (detailModelList == null || detailModelList.isEmpty()) {
            return new ArrayList<>();
        }
        List<UiBotTableColumn> columnList = new ArrayList<>();
        detailModelList.stream().map(UiBotLayout::getColumnDefs).forEach(columnDefs -> {
            if (columnDefs == null || columnDefs.isEmpty()) {
                return;
            }
            columnDefs.forEach(columnDefinition -> {
                columnList.addAll(getColumnList(columnDefinition.getColumns()));
            });
        });
        return columnList;
    }

    /**
     * 获取TABLE类型layout中的UiBotTableColumn
     *
     * @param uiBotLayout
     * @return
     */
    private static List<UiBotTableColumn> getColumnListFromTableLayout(UiBotLayout uiBotLayout) {
        List<UiBotTableColumnDefinition> columnDefs = uiBotLayout.getColumnDefs();
        if (columnDefs == null || columnDefs.isEmpty()) {
            return new ArrayList<>();
        }
        List<UiBotTableColumn> columnList = new ArrayList<>();
        columnDefs.forEach(columnDefinition -> {
            columnList.addAll(getColumnList(columnDefinition.getColumns()));
        });
        return columnList;
    }

    /**
     * 递归获取UiBotTableColumn
     *
     * @param columnList
     * @return
     */
    private static List<UiBotTableColumn> getColumnList(List<UiBotTableColumn> columnList) {
        List<UiBotTableColumn> newColumnList = new ArrayList<>();
        if (columnList == null || columnList.isEmpty()) {
            return newColumnList;
        }
        columnList.forEach(column -> {
            if (column.getColumns() == null) {
                newColumnList.add(column);
            } else {
                newColumnList.addAll(getColumnList(column.getColumns()));
            }
        });
        return newColumnList;
    }
}
