package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：基础资料录入页面 生成服务 接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataPageService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 13:03
 */
public interface BaseDataPageService {
    /**
     * 根据模板 创建基础资料录入页面
     *
     * @param executeContext
     * @return
     */
    UiBotModel createBasicDataTaskTemplateForm(PcUiBotExecuteContext executeContext, ApiRequest apiRequest);

    /**
     * 根据模板 创建基础资料录入回收站页面
     *
     * @param executeContext
     * @return
     */
//    DynamicForm createRecycleBasicDataTaskTemplateForm(ExecuteContext executeContext);

    /**
     * 增加双档入口
     *
     * @param executeContext
     * @param apiRequest
     * @return
     */
    UiBotModel creatDoubleBrowsePageBasicDataTaskTemplateForm(PcUiBotExecuteContext executeContext, ApiRequest apiRequest);

    /**
     * 创建双档编辑界面（维护、新增、复制等）
     *
     * @param executeContext
     * @param pageDefine
     * @Deprecated 废弃
     * @return
     */
//    @Deprecated
//    DynamicForm creatDoubleEditPageBasicDataTaskTemplateForm(ExecuteContext executeContext, DoubleDocumentPageDefine pageDefine);

    /**
     * 创建双档编辑界面（维护、新增、复制等）
     *
     * @param executeContext
     * @param pageDefine
     * @return
     */
    UiBotModel creatDoubleEditPage(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, ApiRequest apiRequest);

    /**
     * @param executeContext
     * @return
     */
//    Object getToolsShow(ExecuteContext executeContext);

    /**
     * 创建双档树界面（上，下（左，右））
     *
     * @param executeContext
     * @return
     */
//    DynamicLayout creatTreeDataBrowsePageBasicDataTaskTemplateForm(ExecuteContext executeContext);

}
