package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;

/**
 * <p>功能描述：数据视图接口类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataViewService.java
 * @Author: wangjwc
 * @Date: created at 2023/12/26 17:09
 */
public interface DataViewService {

    /**
     * 创建视图动态页面
     *
     * @param dataViewPageDefine 页面定义
     * @return
     */
    UiBotModel createDynamicForm(PcUiBotDataViewPageDefine dataViewPageDefine, ApiRequest apiRequest);

    /**
     * 通过视图，在pageDefine中添加必要参数
     *
     * @param viewCode   视图编码
     * @param pageDefine 页面定义
     */
    void appendNecessaryData(String viewCode, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotExecuteContext executeContext);

    /**
     * 查询数据视图
     *
     * @param viewCode       视图编码
     * @param executeContext 上下文
     * @return
     */
    PcUiBotTmDataViewQuery queryDataView(String viewCode, PcUiBotExecuteContext executeContext);

    /**
     * 根据视图编码构建查询操作
     *
     * @param viewCode 视图编码
     * @return 查询操作
     */
    PcUiBotTmQueryAction buildTmQueryAction(String viewCode, PcUiBotExecuteContext executeContext);

    /**
     * 构建查询操作
     *
     * @param tmDataViewQueryDefault 数据视图查询配置
     * @return 查询操作
     */
    PcUiBotTmQueryAction buildTmQueryAction(PcUiBotTmDataViewQuery tmDataViewQueryDefault);

    /**
     * 构建查询操作
     *
     * @param tmQueryAction          原查询条件
     * @param tmDataViewQueryDefault 数据视图查询配置
     * @return 查询操作
     */
    PcUiBotTmQueryAction buildTmQueryAction(PcUiBotTmQueryAction tmQueryAction, PcUiBotTmDataViewQuery tmDataViewQueryDefault);

    /**
     * 查询视图dsl结构并构建
     *
     * @param viewCode
     * @param pageCode
     * @param executeContext
     * @return
     */
    void buildDslByViewCode(String viewCode, String activityId, String pageCode, PcUiBotTmDataState dataState, PcUiBotExecuteContext executeContext);

    /**
     * 查询视图dsl结构
     *
     * @param viewCode
     * @param pageCode
     * @param executeContext
     * @return
     */
    PcUiBotPageUIElement getDslByViewCode(String viewCode, String pageCode, PcUiBotExecuteContext executeContext);
}
