package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：任务相关的页面页生成服务 接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskPageService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 15:28
 */
public interface TaskPageService {

    /**
     * 卡片页面生成数据，根据据项目自身的数据，不依赖任务
     * 新项目卡pattern
     *
     * @param executeContext
     * @return
     */
//    DynamicForm generateProjectCard(ExecuteContext executeContext, ActivityData activityData);


    /**
     * 任务卡-页面数据
     *
     * @param executeContext
     * @param activityData
     * @return
     */
//    DynamicForm generateTaskCard(ExecuteContext executeContext, ActivityData activityData);

    /**
     * 根据任务模板页面
     *
     * @return
     * @throws Exception
     */
    UiBotModel createPage(PcUiBotExecuteContext executeContext, String backlogId, ApiRequest apiRequest);

    /**
     * 根据已经定义好的页面来生成界面，主要是项目的第四层、任务的已完成、追踪中按钮的显示
     *
     * @return
     * @throws Exception
     */
    UiBotModel createPage(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest);

    /**
     * 根据已经定义好的页面来生成界面,数据已经查询好了，不需要再处理数据
     *
     * @return
     * @throws Exception
     */
//    DynamicForm createPageWithData(ExecuteContext executeContext, TaskPageDefine pageDefine, QueryResultSet queryResultSet);


    /**
     * 根据任务获取任务卡上的摘要信息（字符串）
     *
     * @param executeContext
     * @param activityData
     * @return
     */
//    Map getTaskCardAbstractStr(ExecuteContext executeContext, ActivityData activityData);


    /**
     * 卡片页面生成数据，根据据项目自身的数据，不依赖任务
     * 新项目卡pattern
     *
     * @param executeContext
     * @return
     */
    /**
     * 项目卡摘要信息-不依赖任务（字符串）
     *
     * @Author：SYQ
     * @Date：2021/12/29 17:14
     */
//    Map getProjectCardAbstractStr(ExecuteContext executeContext, ActivityData activityData);

    UiBotModel createManuaTaskPage(PcUiBotExecuteContext executeContext, String backlogId);

//    DynamicForm createSimplePage(ExecuteContext executeContext, Map<String, Object> parameter);

//    List<PageDefine> analysisDataUniformityPageDefine(ExecuteContext executeContext, String backlogId);

//    List<DynamicForm> analysisDataUniformityHistory(ExecuteContext executeContext, String backlogId);
}
