package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredField;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredFieldsSummary;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：配置定义分析基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbstractPageDefineAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 20:23
 */
@Slf4j
public abstract class AbstractPageDefineAnalyzer<T extends PcUiBotPageDefine> {

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Autowired
    protected TaskDataSourceAnalysisService taskDataSourceAnalysisService;

//    @Autowired
//    protected DataQueryService dataQueryService;

    @Autowired
    private TaskSubmitActionCreateService taskSubmitActionCreateService;

//    @Autowired
//    protected AudcService audcService;

    @Autowired
    private TaskEngineActionCreateService taskEngineActionCreateService;

    @Autowired
    private DesignerDslLayoutService designerDslLayoutService;

    @Autowired
    private DataViewService dataViewService;

    @Autowired
    private QueryInfoSetService queryInfoSetService;

    /**
     * 根据配置创建多个查询
     *
     * @param executeContext
     * @param tmActivity
     * @return
     */
    protected T createPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {

        PcUiBotTmPage tmPage = tmActivity.getPages();
        //根据过滤器来分析需要查询的数据源，并把查询条件、数据处理器合并到数据源上
        if (CollectionUtils.isEmpty(tmPage.getDataStates())) {
            return null;
        }
        //对配置做初始化处理，添加默认的配置
        this.addDefaultConfigInfo(executeContext, tmActivity);

        PcUiBotTmDataState dataState = tmPage.getDataStates().get(0);
        T pageDefine = createPageDefine(executeContext, tmActivity, tmPage, dataState);
        if (StringUtils.hasLength(tmPage.getTitle())) {
            pageDefine.setTitle(tmPage.getTitle());
            pageDefine.setSubTitle(tmActivity.getActivityNameByLocale());
        } else {
            pageDefine.setTitle(tmActivity.getActivityNameByLocale());
            pageDefine.setSubTitle(tmActivity.getActivityNameByLocale());
        }
        return pageDefine;
    }

    protected void appendInternalPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity,
                                            final List<PcUiBotTaskPageDefine> taskPageDefineList) {

        if (CollectionUtils.isEmpty(taskPageDefineList)) {
            return;
        }

        PcUiBotTaskPageDefine completedTaskPageDefine = null;
        PcUiBotTaskPageDefine waitingTaskPageDefine = null;
        for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefineList) {
            switch (taskPageDefine.getDataStateCode()) {
                case PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED:
                    completedTaskPageDefine = taskPageDefine;
                    break;
                case PcUiBotActivityConstant.TASK_DATA_STATE_CODE_WAITING:
                    waitingTaskPageDefine = taskPageDefine;
                    break;
            }
        }
        log.warn(executeContext.getTmActivityId() + "配置有问题，没有按照标准配置，导致找不到待处理、已完成的页签");
        if (completedTaskPageDefine == null) {
            completedTaskPageDefine = taskPageDefineList.get(taskPageDefineList.size() - 1);
        }
        if (waitingTaskPageDefine == null) {
            waitingTaskPageDefine = taskPageDefineList.get(0);
        }

        // 添加 "已搁置" 页签,
        if (completedTaskPageDefine != null && BooleanUtils.isTrue(completedTaskPageDefine.getAutoAppendShelvedDataState())
                // 兼容老配置：autoAppendTerminateDataState，有些任务执行终止后，不想要“已终止”页签
                && BooleanUtils.isTrue(tmActivity.getPages().getAutoAppendTerminateDataState())
                && BooleanUtils.isTrue(tmActivity.getPages().getAutoAppendShelvedDataState())) {
            PcUiBotTaskPageDefine shelvedPageDefine = appendShelvedDataPageDefine(executeContext, completedTaskPageDefine);
            if (null != shelvedPageDefine) {
                taskPageDefineList.add(shelvedPageDefine);
            }
        }

        //有异动数据, 添加 "封存中" 页签,
        if (waitingTaskPageDefine != null) {
            //是异动数据的异常排除任务
            if (executeContext.getTaskType() != null && executeContext.getTaskType() == 89) {
                //修改待处理，添加异动数据处理器
                editWaitingTaskPageDefine(executeContext, waitingTaskPageDefine);
                //只保留一个页签。
                taskPageDefineList.clear();
                taskPageDefineList.add(waitingTaskPageDefine);
            } else if (!CollectionUtils.isEmpty(executeContext.getAbnormalData())) {
                //针对待处理的数据，去掉异动的
                PcUiBotTaskPageDefine abnormalDataPageDefine = createAbnormalDataPageDefine(executeContext, waitingTaskPageDefine);
                if (null != abnormalDataPageDefine) {
                    taskPageDefineList.add(1, abnormalDataPageDefine);
                }
            }
        }
    }

    protected PcUiBotTaskPageDefine appendShelvedDataPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine taskPageDefine) {
        if (null == taskPageDefine || null == taskPageDefine.getDataSourceSet() || CollectionUtils.isEmpty(taskPageDefine.getDataSourceSet().getDataSourceList())) {
            return null;
        }

        List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = executeContext.getTaskWithBacklogDataList();
        if (CollectionUtils.isEmpty(taskWithBacklogDataList)) {
            return null;
        }

        // 使用“已完成"/"待处理"上数据源定义的actionId，为了获取到tag等配置
        String actionId = null;
        if (taskPageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = taskPageDefine.getDataSourceSet().getFirstActionId();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(actionId)) {
            return null;
        }

        List<String> workItemIdList = new ArrayList<>();
        for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : taskWithBacklogDataList) {
            Optional.ofNullable(taskWithBacklogData)
                    .map(DigiwinAtmcTaskWithBacklogData::getBacklog)
                    .map(backloglist -> backloglist.isEmpty() ? new DigiwinAtmcBacklogData() : backloglist.get(0))
                    .map(DigiwinAtmcBacklogData::getBacklogId)
                    .ifPresent(workItemId -> workItemIdList.add(String.valueOf(workItemId)));
        }
        if (CollectionUtils.isEmpty(workItemIdList)) {
            return null;
        }

//        String tmActivityId = executeContext.getTaskWithBacklogData().getTmActivityId();
//        // 直接访问mongoDB，查询该任务下"已撤回"数据的条数
        Integer retrievedDataSize = 0;//dataQueryService.queryShelvedDataSize(tmActivityId, workItemIdList);
        if (null == retrievedDataSize || 0 >= retrievedDataSize) {
            return null;
        }

        PcUiBotTaskPageDefine pageDefine = JsonUtil.objectToJavaObject(taskPageDefine, PcUiBotTaskPageDefine.class);
        pageDefine.setExecuteContext(JsonUtil.objectToJavaObject(taskPageDefine.getExecuteContext(),
                new TypeReference<PcUiBotExecuteContext>() {
                }));
        // 不需要提交按钮
        pageDefine.setSubmitActions(Collections.emptyList());
        pageDefine.setShowSubmitActions(false);
        pageDefine.setRowSizeType("");
        pageDefine.setQueryTitle("已搁置");

        // 替换数据源
        PcUiBotDataSourceDTO oldDataSource = pageDefine.getDataSourceSet().getDataSourceList().get(0);
        PcUiBotDataSourceDTO newDataSource = createShelvedDataSource(actionId);
        newDataSource.setAction(oldDataSource.getAction());
        newDataSource.setName(oldDataSource.getName());
        if (!CollectionUtils.isEmpty(oldDataSource.getDataSourceProcessors())) {
            newDataSource.setDataSourceProcessors(oldDataSource.getDataSourceProcessors());
        } else if (!CollectionUtils.isEmpty(oldDataSource.getUnionItems())) {
            oldDataSource.getUnionItems()
                    .stream()
                    .map(PcUiBotDataSourceDTO::getDataSourceProcessors)
                    .filter(tmDataProcesses -> !CollectionUtils.isEmpty(tmDataProcesses))
                    .findFirst()
                    .ifPresent(newDataSource::setDataSourceProcessors);
        }

        taskDataSourceAnalysisService.addExtendedData(executeContext.getTaskWithBacklogData(), newDataSource);
        pageDefine.getDataSourceSet().setDataSourceList(Collections.singletonList(newDataSource));

        // 往 dataSource.extendedData 中塞入 allWorkItemIdList、当前登录信息（是Token，而非ProxyToken）放入 dataSource.extendedData中
        addExtraInfoToDataSourceParas(executeContext.getAuthoredUser().getUserId(), pageDefine.getDataSourceSet().getDataSourceList().get(0), workItemIdList);
        pageDefine.setDataStateCode(PcUiBotActivityConstant.TASK_DATA_STATE_CODE_SHELVED);
        appendShelvedPageMergeField(pageDefine);
        return pageDefine;
    }

    protected void appendShelvedPageMergeField(PcUiBotTaskPageDefine pageDefine) {
        String dataSourceName = pageDefine.getDataSourceSet().getDataSourceList().get(0).getName();
        JSONObject settings = pageDefine.getSettings();
        // 不需要分组处理
        if (null == settings || !settings.containsKey(dataSourceName) || null == settings.getJSONObject(dataSourceName)
                || !settings.getJSONObject(dataSourceName).containsKey("merge")) {
            return;
        }

        JSONObject merge = settings.getJSONObject(dataSourceName).getJSONObject("merge");
        if (null == merge || !merge.containsKey("options")
                || null == merge.getJSONArray("options") || merge.getJSONArray("options").isEmpty()) {
            return;
        }

        JSONArray options = merge.getJSONArray("options");
        JSONObject activityName = new JSONObject();
        activityName.put("schema", "uibot__initiateActivityName");
        options.add(0, activityName);

        JSONObject dateTime = new JSONObject();
        dateTime.put("schema", "uibot__dateTime");
        options.add(0, dateTime);

        JSONObject userName = new JSONObject();
        userName.put("schema", "uibot__userName");
        options.add(0, userName);

        JSONObject operationType = new JSONObject();
        operationType.put("schema", "uibot__operationType");
        options.add(0, operationType);
    }

    private void editWaitingTaskPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine waitingTaskPageDefine) {
        List<PcUiBotDataSourceDTO> dataSourceDTOList = waitingTaskPageDefine.getDataSourceSet().getDataSourceList();
        PcUiBotDataSourceDTO dataSourceDTO = dataSourceDTOList.get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList<>());
        }
        PcUiBotTmDataProcess tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas(executeContext.getAbnormalData());
        tmDataProcess.setServiceName("retainAbnormalAndAddColumnService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        submitAction.setTitle("提交");
        submitAction.setCategory(PcUiBotConstants.ACTION_CATEGORY_UIBOT);
        submitAction.setActionId("atmc_data_uniformity_submit");
        submitAction.executeExtendParas(new HashMap<>(), executeContext);
        submitAction.getExtendParas().put("AbnormalData", executeContext.getAbnormalData());
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, waitingTaskPageDefine.getExecuteContext().getTaskWithBacklogData()));

        String schema = "";
        if (CollectionUtils.isEmpty(waitingTaskPageDefine.getSubmitActions())) {
            waitingTaskPageDefine.setSubmitActions(new ArrayList<>());
        } else {
            PcUiBotSubmitType submitTypeOri = waitingTaskPageDefine.getSubmitActions().get(0).getSubmitType();
            PcUiBotSubmitType submitType = JsonUtil.objectToJavaObject(submitTypeOri, PcUiBotSubmitType.class);
            submitType.setIsBatch(false);
            submitType.setSubmitAll(true);
            submitAction.setSubmitType(submitType);
            waitingTaskPageDefine.getSubmitActions().clear();
            schema = (null != submitAction.getSubmitType()) ? submitAction.getSubmitType().getSchema() : "";
        }
        //按钮信息
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setName("atmc_data_uniformity_submit");
        actionServiceId.setHostAcct("athena");
        actionServiceId.setTenant_id(executeContext.getAuthoredUser().getTenantId());
        submitAction.setServiceId(actionServiceId);
        //中止信息
        Map<String, Object> extendParams = new HashMap<>();
        extendParams.put("submitVariableName", schema);
        String processVariableName = "";
        List<PcUiBotActionParameterMapping> actionParams = dataSourceDTO.getAction().getActionParams();
        if (!CollectionUtils.isEmpty(actionParams)) {
            for (PcUiBotActionParameterMapping actionParam : actionParams) {
                if ("PROCESS_VARIABLE".equals(actionParam.getType())) {
                    processVariableName = actionParam.getValue();
                    break;
                }
            }
        }
        extendParams.put("processVariableName", processVariableName);
        extendParams.put("dataKeys", "");
        submitAction.executeExtendParas(extendParams, executeContext);

        /*拼接checkCompleteAction start*/
        PcUiBotDataSourceDTO checkCompleteAction = new PcUiBotDataSourceDTO();
        checkCompleteAction.setType("DATA_UNIFORMITY_SUBMIT");
        checkCompleteAction.setName(dataSourceDTO.getName());
        checkCompleteAction.setActionId(dataSourceDTO.getActionId());

        submitAction.setCheckCompleteAction(checkCompleteAction);

        List<PcUiBotSubmitAction> attachActionList = new ArrayList<>();
        DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
        if (!Objects.equals(executeContext.getDataFrom(), PcUiBotConstants.ACTION_CATEGORY_BPM_PTM)) {
            DigiwinAtmcBacklogData backlogData = taskWithBacklogData.getBacklog().get(0);
            PcUiBotSubmitAction attachAction = taskSubmitActionCreateService.createTerminateProcessAction(taskWithBacklogData, backlogData);
            attachActionList.add(attachAction);
        } else {
            PcUiBotSubmitAction attachAction = taskEngineActionCreateService.createTerminateTaskAction(taskWithBacklogData);
            attachActionList.add(attachAction);
        }
        submitAction.setAttachActions(attachActionList);
        /*拼接attachAction end*/

        waitingTaskPageDefine.setOperations(new ArrayList<>());
        waitingTaskPageDefine.getSubmitActions().add(submitAction);
    }

    /**
     * 针对有异动的任务卡，添加已经封存的数据页签
     *
     * @param executeContext
     * @param taskPageDefine
     * @return
     */
    private PcUiBotTaskPageDefine createAbnormalDataPageDefine(final PcUiBotExecuteContext executeContext, final PcUiBotTaskPageDefine taskPageDefine) {

        //任务没有数据源
        if (null == taskPageDefine
                || null == taskPageDefine.getDataSourceSet()
                || CollectionUtils.isEmpty(taskPageDefine.getDataSourceSet().getDataSourceList())) {
            return null;
        }
        //已经完成的
        if (taskPageDefine.getFinished()) {
            return null;
        }

        //没有任务数据
        List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = executeContext.getTaskWithBacklogDataList();
        if (CollectionUtils.isEmpty(taskWithBacklogDataList)) {
            return null;
        }

        // 使用"待处理"上数据源定义的actionId，为了获取到tag等配置
        String actionId = null;
        if (taskPageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = taskPageDefine.getDataSourceSet().getFirstActionId();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(actionId)) {
            return null;
        }
        //根据待处理的页签，创建一个只包含异动的数据页签
        PcUiBotTaskPageDefine pageDefine = JsonUtil.objectToJavaObject(taskPageDefine, PcUiBotTaskPageDefine.class);

        //针对待处理的数据，去掉异动的
        PcUiBotDataSourceDTO dataSourceDTO = taskPageDefine.getDataSourceSet().getDataSourceList().get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList<>());
        }
        PcUiBotTmDataProcess tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas(executeContext.getAbnormalData());
        tmDataProcess.setServiceName("removeAbnormalDataService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);

        //处理封存的页签
        pageDefine.setOperations(null);
        pageDefine.setSubmitActions(null);
        pageDefine.setRowSize(null);
        pageDefine.setType("async");
        pageDefine.setQueryTitle("封存中");

        dataSourceDTO = pageDefine.getDataSourceSet().getDataSourceList().get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList<>());
        }
        tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas(executeContext.getAbnormalData());
        tmDataProcess.setServiceName("retainAbnormalDataService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
        pageDefine.setDataStateCode(PcUiBotActivityConstant.TASK_DATA_STATE_CODE_SEAL);
//        executeContext.setDataStateCode(ActivityConstant.TASK_DATA_STATE_CODE_SEAL);
        executeContext.setClientAgent("webplatform");
        executeContext.setPattern("business");
        executeContext.setCategory("sealing");
        pageDefine.setVersion("2.0");
        return pageDefine;
    }


    private void addExtraInfoToDataSourceParas(String userId, PcUiBotDataSourceDTO dataSource, List<String> workItemIdList) {
        if (null != dataSource.getAction()) {
            Map<String, Object> paras = dataSource.getAction().getParas();
            if (null == paras) {
                paras = new HashMap<>();
                dataSource.getAction().setParas(paras);
            }
            paras.put("allWorkItemId", workItemIdList);
            paras.put("uibot_login_userId", userId);
        }

        HashMap<String, Object> extendedData = dataSource.getExtendedData();
        if (null == extendedData) {
            extendedData = new HashMap<>();
            dataSource.setExtendedData(extendedData);
        }
        extendedData.put("allWorkItemId", workItemIdList);
        extendedData.put("uibot_login_userId", userId);
    }

    private PcUiBotDataSourceDTO createShelvedDataSource(String actionId) {
        PcUiBotDataSourceDTO dataSource = new PcUiBotDataSourceDTO();
        dataSource.setType(PcUiBotActivityConstants.SHELVED_DATA_SOURCE_TYPE);
        dataSource.setActionId(actionId);
        dataSource.setOverride(false);
        return dataSource;
    }

    /**
     * 根据配置创建多个查询
     *
     * @param executeContext
     * @param tmActivity
     * @return
     */
    public List<T> createPageDefines(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        List<T> pageDefines = new ArrayList<>();
        if (tmActivity.getPages() == null) {
            return pageDefines;
        }
        //获取TM任务页面定义
        PcUiBotTmPage tmPage = tmActivity.getPages();
        //根据过滤器来分析需要查询的数据源，并把查询条件、数据处理器合并到数据源上
        if (CollectionUtils.isEmpty(tmPage.getDataStates())) {
            return pageDefines;
        }
        //对配置做初始化处理，添加默认的配置
        this.addDefaultConfigInfo(executeContext, tmActivity);

        for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
            T pageDefine = createPageDefine(executeContext, tmActivity, tmPage, dataState);
            if (pageDefine != null && Boolean.TRUE.equals(dataState.getEnablePaging())) {
                pageDefine.setUseHasNext(true);
                PcUiBotPageInfo pageInfo = Optional.ofNullable(pageDefine.getPageInfo()).orElse(new PcUiBotPageInfo());
                if (Objects.isNull(pageInfo.getPageNo())) {
                    pageInfo.setPageNo(1);
                }
                if (Objects.isNull(pageInfo.getPageSize())) {
                    pageInfo.setPageSize(50);
                }
                pageDefine.setPageInfo(pageInfo);
            }

            pageDefines.add(pageDefine);
        }
        if (tmPage.getDataStates().size() == 1 && pageDefines.size() == 1) {
            pageDefines.get(0).setDefaultShow(true);
        }

        //添加用户自定义信息
        appendUserOrderConditions(executeContext, pageDefines);


        return pageDefines;
    }

    /**
     * xuxx 组装用户自定义数据排序条件，放到setting中
     */
    protected void appendUserOrderConditions(PcUiBotExecuteContext executeContext, List<T> pageDefines) {
        try {
            //开窗不设定
            if (executeContext.getOpenWindow() != null
                    && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow())) {
                return;
            }
            if (CollectionUtils.isEmpty(pageDefines)
                    || pageDefines.get(0) == null
                    || pageDefines.get(0).getDataSourceSet() == null) {
                return;
            }
            String schema = pageDefines.get(0).getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }

            if (StringUtils.isEmpty(executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            if (org.springframework.util.StringUtils.hasText(executeContext.getTmProjectId())) {
                tmProjectId = executeContext.getTmProjectId();
            } else {
                tmProjectId = "__uibot__";
            }
            JSONObject userSetting =
                    digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                            executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey("order")) {
                if (!userSetting.containsKey(schema)) {
                    JSONObject setting = new JSONObject();
                    setting.put(schema, userSetting);
                    userSetting = setting;
                }
            }
            for (PcUiBotPageDefine pageDefine : pageDefines) {
                if (userSetting != null && !userSetting.isEmpty()) {
                    JSONObject orderSetting = userSetting.getJSONObject(schema);
                    if (orderSetting.containsKey("order")) {
                        pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
                    }
                }
                pageDefine.setUserSetting(userSetting);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    protected T createPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {

        T pageDefine = createNewPageDefine();

        PcUiBotExecuteContext newExecuteContext = createNewContext(executeContext);

        pageDefine.setExecuteContext(newExecuteContext);
        newExecuteContext.setDataStateCode(dataState.getCode());
        pageDefine.setDataStateCode(dataState.getCode());
        pageDefine.setShowSubmitActions(tmPage.getShowSubmitActions());

        analysisBaseInfo(newExecuteContext, pageDefine, tmActivity, tmPage);

        pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        PcUiBotTmDataFilter tmDataFilter = null;
        //xuxx 2022-11-01  调整datafilter的位置，优化到每个具体的page下dataState中，如果同时存在，以page里的datafilter为主
        if (dataState.getDataFilter() != null) {
            tmDataFilter = dataState.getDataFilter();
        } else if (!CollectionUtils.isEmpty(tmActivity.getDataFilters())) {
            tmDataFilter = tmActivity.getDataFilters().stream()
                    .filter((filter) -> Objects.equals(filter.getCode(), dataState.getDataFilterCode()))
                    .findFirst()
                    .orElse(null);
        }
        if (tmDataFilter != null && tmDataFilter.getDefaultFilter() != null) {
            pageDefine.setDefaultShow(tmDataFilter.getDefaultFilter());
            if (BooleanUtils.isTrue(tmDataFilter.isApiFilter())) {
                // 作用于 应用api不支持条件筛选时，需要后端进行筛选
                pageDefine.setDataFilter(tmDataFilter);
            }
        }
        if (!CollectionUtils.isEmpty(tmActivity.getDataSources())) {
            Map<String, PcUiBotTmQueryAction> dataSources = getDataSources(tmDataFilter, tmActivity);
            // 如果dataState.submitType==null，则重置dataState.submitType
            this.analysisSubmitType(dataState);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());

            Map<String, PcUiBotTmQueryAction> copyDataSources = JsonUtil.objectToJavaObject(dataSources, new TypeReference<Map<String, PcUiBotTmQueryAction>>() {
            });
            analysisDataSource(newExecuteContext, pageDefine, tmActivity, dataState, copyDataSources, tmDataFilter);

            //获取所有数据源（目前是卡片列表数据源不是主数据源场景使用）
            analysisAllDataSource(newExecuteContext, pageDefine, tmActivity, dataState, tmDataFilter);

            // 数据源的后置处理
            postAnalysisDataSource(newExecuteContext, pageDefine, dataState);
            executeContext.setMainDataSourceName(Optional.ofNullable(pageDefine.getDataSourceSet()).map(PcUiBotDataSourceSetDTO::getMainDatasource).orElse(null));
            newExecuteContext.setMainDataSourceName(Optional.ofNullable(pageDefine.getDataSourceSet()).map(PcUiBotDataSourceSetDTO::getMainDatasource).orElse(null));
        }

        //为了兼容不替换数据源的dataSourceName做为M
        pageDefine.setMasterFromDataSourceName(dataState.getMasterFromDataSourceName());

        // 在dataSource构建后处理，根据dataViewQuerys重置dataSource、构建layout
        this.analysisDataViewQuerys(executeContext, pageDefine, dataState);

        // 根据数据源viewCode补充dsl
        analysisDataSourceViewCode(pageDefine, tmActivity, dataState);
        if (!CollectionUtils.isEmpty(dataState.getOperations())) {
            analysisOperators(newExecuteContext, pageDefine, tmActivity, dataState.getOperations());
        }
//        if (CollectionUtils.isNotEmpty(dataState.getTabs())) {
//            analysisTabs(pageDefine, dataState.getTabs());
//        }
        if (!CollectionUtils.isEmpty(dataState.getSubmitActions())) {
            analysisSubmitActions(newExecuteContext, pageDefine, tmActivity, dataState, dataState.getSubmitActions());
        }

//        if (!CollectionUtils.isEmpty(dataState.getSummaryFields())) {
//            analysisSummaryFields(pageDefine, dataState, dataState.getSummaryFields());
//        }

        if (!CollectionUtils.isEmpty(dataState.getTaskStates())) {
            analysisTaskStates(pageDefine, dataState.getTaskStates());
        }

//        // xuxx add 读取任务定义中客制tag
//        if (!CollectionUtils.isEmpty(tmPage.getCustomizeTags())) {
//            analysisCustomizeTags(pageDefine, tmPage.getCustomizeTags());
//        }
        if (dataState.getSettings() != null) {
            analysisSettings(pageDefine, dataState.getSettings());
        }

        if (tmActivity.getApprove() != null || !CollectionUtils.isEmpty(tmActivity.getApproves())) {
            analysisApprove(newExecuteContext, pageDefine, tmActivity, tmPage, dataState);
        }

//        //xuxx add 解析treeConfig
//        if (tmPage.getTreeConfig() != null) {
//            analysisTreeConfig(newExecuteContext, pageDefine, tmPage.getTreeConfig());
//        }

//        // add 解析gridConfig
//        if (tmPage.getGridConfig() != null || dataState.getGridConfig() != null) {
//            analysisGridConfig(newExecuteContext, pageDefine, tmPage.getGridConfig() == null ? dataState.getGridConfig() : tmPage.getGridConfig());
//        }

//        //增加对filterConfig的解析,解析过滤字段信息
//        if (dataState.getFilterConfig() != null) {
//            analysisFilterConfig(pageDefine, dataState.getFilterConfig());
//        }

        //如果没有submit，需要去除 SubmitType
        if (CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
            pageDefine.setSubmitType(null);
        }
        pageDefine.setExtendedFields(tmPage.getExtendedFields());
//        pageDefine.setWordCapability(tmPage.getWordCapability());

        //获取分页方式（滚动或者普通分页）以及是否启用全部选择功能
        pageDefine.setEnableSelectAll(dataState.getEnableSelectAll());
        pageDefine.setEnableVirtualScrolling(dataState.getEnableVirtualScrolling());
        pageDefine.setEnableBackEndPaging(dataState.getEnableBackEndPaging());
        pageDefine.setEnableBackEndPagingLimit(dataState.getEnableBackEndPagingLimit());
        pageDefine.setEnableFilter(dataState.getEnableFilter());
        pageDefine.setEnablePaging(dataState.getEnablePaging());
        // 设置模型驱动的是否为DSL
        if (PcUiBotPatternUtil.isModelDriven(executeContext)) {
            executeContext.setIsDesigner(true);
            newExecuteContext.setIsDesigner(true);
        }
        //转化DSL--layout
        if (!CollectionUtils.isEmpty(dataState.getPageLayout())) {
            analysisLayout(executeContext, newExecuteContext, pageDefine, dataState);
        }

        //转化DSL--RULES
        if (!CollectionUtils.isEmpty(tmPage.getRules())) {
            pageDefine.setRules(tmPage.getRules());
        }

        //转化DSL--hooks
        if (!CollectionUtils.isEmpty(dataState.getHooks())) {
            pageDefine.setHooks(dataState.getHooks());
        }

        //解析保存到配置中的词条
        if (null != dataState.getShowMetadatas()) {
            analysisShowMetadatas(pageDefine, dataState.getShowMetadatas());
        }
//        pageDefine.setGridSettings(dataState.getGridSettings());
        pageDefine.setAutoAppendShelvedDataState(dataState.getAutoAppendShelvedDataState());
        appendMechnismConfig(tmActivity, pageDefine);

        // 移动设计器DSL新增属性
        pageDefine.setShowTitle(dataState.getShowTitle());
        pageDefine.setDefaultTabMobileCode(dataState.getDefaultTabMobileCode());
        pageDefine.setShowSingleHeadFrom(dataState.getShowSingleHeadFrom());
        pageDefine.setPageLayout(dataState.getPageLayout());
        pageDefine.setTipSetting(dataState.getTipSetting());
        // dcp 场景下判断走 数据驱动页面
        boolean notDcp = Objects.isNull(Optional.ofNullable(executeContext.getBpmData()).map(r -> r.get(PcUiBotConstants.UIBOT_ACTION_METADATA)).orElse(null));
        pageDefine.setIsDesignerDsl((tmActivity.getIsDesignerDsl() && notDcp) || tmActivity.isbindFormCode());
        return pageDefine;
    }

    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmDataState dataState) {
    }

    /**
     * 数据源分析的后置处理，暂时只有类型为RAWDATA处理
     *
     * @param newExecuteContext
     */
    private void postAnalysisDataSource(PcUiBotExecuteContext newExecuteContext, T pageDefine, PcUiBotTmDataState dataState) {
        Map<String, Object> bpmData = newExecuteContext.getBpmData();
        if (bpmData == null) {
            return;
        }
        // 是否有api配置
        Object metadata = bpmData.get(PcUiBotConstants.UIBOT_ACTION_METADATA);
        if (metadata == null) {
            return;
        }
        PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
        if (dataSourceSet != null) {
            // 获取所有数据源
            List<PcUiBotDataSourceDTO> dataSourceList = dataSourceSet.getDataSourceList();
            if (!CollectionUtils.isEmpty(dataSourceList)) {
                for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceList) {
                    // 数据源类型
                    String type = dataSourceDTO.getType();
                    // 类型是否为RAWDATA
                    if (PcUiBotConstants.ACTION_CATEGORY_RAW_DATA.equals(type)) {
                        List<PcUiBotMetadataField> metadataFields = dataSourceDTO.getMetadataFields();
                        // 虚拟字段和actionId为空的情况，取bpmData中的api字段
                        if (CollectionUtils.isEmpty(metadataFields) && !StringUtils.hasLength(dataSourceDTO.getActionId())) {
                            // 多语言
                            MobileRenderDataUtil.multilingualProcessing((Map<String, Object>) metadata, AppRequestContext.getContextEntity().getLocale());

                            // 将对象类型转换为元数据对象，也可以通过BeanMap转换
                            PcUiBotMetadataField sdMetadata = JsonUtil.objectToJavaObject(metadata, PcUiBotMetadataField.class);
                            // 根据bpm中的隐藏字段的配置处理第一层级的隐藏,移除tag
                            Object o = bpmData.get(PcUiBotConstants.UIBOT_HIDDEN_FIELDS);
                            List<String> hiddenFields = null;
                            if (o instanceof List) {
                                hiddenFields = (List<String>) o;
                            }
                            // 需要根据元数据生成tag，为了可以根据canEdit字段来限制是否可编辑，必须要生成默认字段tag，如果没有默认字段构建tag会丢失
                            List<String> finalHiddenFields = hiddenFields;
                            PcUiBotDefaultTagUtils.addDefaultTag(sdMetadata.getSubFields(), (metadataField -> {
                                if (!CollectionUtils.isEmpty(finalHiddenFields)) {
                                    // 如果包含在隐藏字段里面就移除tag
                                    if (finalHiddenFields.contains(metadataField.getName())) {
                                        metadataField.setTagDefinitions(null);
                                        return;
                                    }
                                }
                                if (!metadataField.isCanEdit()) {
                                    List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
                                    if (!CollectionUtils.isEmpty(tagDefinitions)) {
                                        // 不能编辑的字段添加不可编辑标签
                                        metadataField.getTagDefinitions().add(PcUiBotDefaultTagUtils.createUneditableTagDef());
                                    }
                                }
                            }));
                            // 重置元数据结构的api名称为数据源名称(待处理页签时固化UIBOT_BPMDATA_WAITTING；已完成UIBOT_BPMDATA_COMPLETED)
                            sdMetadata.setName(dataSourceDTO.getName());
                            // 添加虚拟字段
                            dataSourceDTO.setMetadataFields(Lists.newArrayList(sdMetadata));
                            // 重置词条
                            dataState.setShowMetadatas(null);
                        }
                    }
                }
            }
        }
    }

    protected void analysisLayout(PcUiBotExecuteContext executeContext,
                                  PcUiBotExecuteContext newExecuteContext, T pageDefine, PcUiBotTmDataState dataState) {
        executeContext.setIsDesigner(true);
        newExecuteContext.setIsDesigner(true);
        //解析卡片列表是否自带分页参数
        queryInfoSetService.analysisLayoutDsl(newExecuteContext, pageDefine, dataState);
    }

    private void appendMechnismConfig(PcUiBotTmActivity tmActivity, PcUiBotPageDefine pageDefine) {
        //mechnismConfig放入pageDefine里
        Map<String, Object> mechnismConfig = tmActivity.getMechnismConfig();
        if (mechnismConfig == null) {
            return;
        }
        pageDefine.setMechnismConfig(mechnismConfig);
    }

    protected Map<String, PcUiBotTmQueryAction> getDataSources(PcUiBotTmDataFilter tmDataFilter, PcUiBotTmActivity tmActivity) {

        Map<String, PcUiBotTmQueryAction> dataSources = new HashMap<>();
        if (tmActivity.getPages() != null && StringUtils.hasText(tmActivity.getPages().getDataSourceName())) {
            String dataSourceName = tmActivity.getPages().getDataSourceName();
            //匹配数据源
            if (tmActivity.getDataSources().containsKey(dataSourceName)) {
                dataSources.put(dataSourceName, tmActivity.getDataSources().get(dataSourceName));
            } else {
                String message = String.format("数据过滤:定义的数据源:%s不存在", dataSourceName);
                throw new ServiceException(message);
            }
        } else {
            if (tmDataFilter != null) {
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(tmDataFilter.getDataSourceNames())) {
                    dataSources = tmActivity.getDataSources();
                } else {
                    //匹配数据源
                    for (String dataSourceName : tmDataFilter.getDataSourceNames()) {
                        if (tmActivity.getDataSources().containsKey(dataSourceName)) {

                            //获取视图，有视图根据视图匹配数据源
                            String viewCode =
                                    PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, String.class).orElse("");

                            if (StringUtils.isEmpty(viewCode)) {
                                dataSources.put(dataSourceName, tmActivity.getDataSources().get(dataSourceName));
                            } else {
                                PcUiBotTmQueryAction queryAction = tmActivity.getDataSources().get(dataSourceName);
                                if (queryAction.getType().equals(PcUiBotConstants.ACTION_CATEGORY_VIEW_CODE)) {
                                    if (queryAction.getDataViewQuery().getCode().equals(viewCode)) {
                                        dataSources.put(dataSourceName, tmActivity.getDataSources().get(dataSourceName));
                                    }
                                } else {
                                    if (StringUtils.isEmpty(queryAction.getViewCode())) {
                                        String message = String.format("获取数据源:%s定义的ESP数据源:%s结构中缺少viewCode",
                                                tmDataFilter.getCode(), dataSourceName);
                                        throw new ServiceException(message);
                                    }
                                    if (queryAction.getViewCode().equals(viewCode)) {
                                        dataSources.put(dataSourceName, tmActivity.getDataSources().get(dataSourceName));
                                    }
                                }
                            }
                        } else {
                            String message = String.format("数据过滤:%s定义的数据源:%s不存在", tmDataFilter.getCode(), dataSourceName);
                            throw new ServiceException(message);
                        }
                    }
                }
            } else {
                dataSources = tmActivity.getDataSources();
            }
        }
        //状态数据源,不走Filter配置
        if (tmActivity.getPages().getTaskStates() != null) {
            //取数据源信息
            List<String> dataSourceNames = tmActivity.getPages().getTaskStates().stream().map(PcUiBotTmActivityStates::getDataSourceName).collect(Collectors.toList());
            for (String sourceName : dataSourceNames) {
                if (!dataSources.containsKey(sourceName)) {
                    dataSources.put(sourceName, tmActivity.getDataSources().get(sourceName));
                }
            }
        }
        return dataSources;
    }


    /**
     * 创建一个新的页面
     *
     * @return
     */
    protected abstract T createNewPageDefine();


    /**
     * 重新为每个查询定义独立的上下文
     *
     * @param oldExecuteContext
     * @return
     */
    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        //默认不需要新的上下文
        return oldExecuteContext;
    }

    /**
     * 添加默认的配置信息
     *
     * @param tmActivity
     */
    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess(executeContext, tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction(executeContext, tmActivity);
    }

    /**
     * 解析签核逻辑
     *
     * @param pageDefine
     * @param tmActivity
     * @param tmPage
     * @param dataState
     */
    protected void analysisApprove(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {

    }

//    /**
//     * 解析栅格配置
//     *
//     * @param executeContext
//     * @param pageDefine
//     * @param tmGridConfig
//     */
//    protected void analysisGridConfig(ExecuteContext executeContext, T pageDefine, TmGridConfig tmGridConfig) {
//        GridConfigDTO gridConfigDTO = new GridConfigDTO();
//        BeanUtils.copyProperties(tmGridConfig, gridConfigDTO);
//        pageDefine.setGridConfigDTO(gridConfigDTO);
//    }


//    /**
//     * 解析表格过滤字段信息
//     *
//     * @param pageDefine     解析出的页面定义信息
//     * @param tmFilterConfig 过滤定义信息
//     */
//    protected void analysisFilterConfig(T pageDefine, TmFilterConfig tmFilterConfig) {
//        FilterConfigDTO filterConfigDto = new FilterConfigDTO();
//
//        //过滤配置信息不为空，则对过滤配置进行解析处理，防止盗pagedefine中
//        if (null != tmFilterConfig) {
//            DataSourceDTO filterDataSource = null;
//            filterConfigDto.setFilterFields(tmFilterConfig.getFilterFields());
//            List<DataSourceDTO> pageSourceList = pageDefine.getDataSourceSet().getDataSourceList();
//            Optional<DataSourceDTO> first = pageSourceList.stream().filter(item -> item.getName().equals(tmFilterConfig.getTargetDataSource())).findFirst();
//            if (first.isPresent()) {
//                filterDataSource = first.get();
//            }
//            filterConfigDto.setFilterAction(filterDataSource);
//        }
//        pageDefine.setFilterInfo(filterConfigDto);
//    }

    /* *//**
     * 转换DSL为平台标准组件
     *
     * @param pageDefine
     *//*
    protected void analysisLayoutDsl(T pageDefine, List<Object> tmLayout) {
        List<AbstractComponent> layout = new ArrayList<>();

        for (Object obj : tmLayout) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            if (!jsonObject.containsKey("type")) {
                continue;
            }
            if (DSL_TYPE_ATHENA_TABLE.equals(jsonObject.get("type"))) {
                GridComponent gridComponent = JsonUtils.jsonToObject(JsonUtils.objectToString(jsonObject), GridComponent.class);
                layout.add(gridComponent);
                continue;
            }
            if (DSL_TYPE_FORM_LIST.equals(jsonObject.get("type"))) {
                FormComponent formComponent = JsonUtils.jsonToObject(JsonUtils.objectToString(jsonObject), FormComponent.class);
                List<AbstractComponent> group  = new ArrayList<>();
                if(jsonObject.containsKey("group")){
                    JSONArray groupArr =  JSONArray.fromObject(jsonObject.get("group"));
                    for(Object groupObj : groupArr){
                        JSONObject groupObject = JSONObject.fromObject(groupObj);
                        if(groupObject.containsKey("type")){
                            group.add(dslComponentService.getDslComponent(groupObject.getString("type"),groupObj));
                        }
                    }
                    formComponent.setGroup(group);
                }
                layout.add(formComponent);
            }
        }
        pageDefine.setLayout(layout);
    }
*/

//    /**
//     * 解析签核逻辑
//     *
//     * @param executeContext
//     * @param pageDefine
//     * @param tmTreeConfig
//     */
//    protected void analysisTreeConfig(PcUiBotExecuteContext executeContext, T pageDefine, TmTreeConfig tmTreeConfig) {
//
//    }

    /**
     * 解析基本信息
     *
     * @param pageDefine
     * @param tmActivity
     * @param tmPage
     */
    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        pageDefine.setTitle(tmPage.getTitle());
        pageDefine.setSubTitle(tmPage.getSubTitle());
        pageDefine.setDescription(tmPage.getDescription());
        pageDefine.setSubDescription(tmPage.getSubDescription());
        pageDefine.setExplanation(tmPage.getExplanation());
    }

    private void analysisSettings(PcUiBotPageDefine pageDefine, JSONObject settings) {
        pageDefine.setSettings(settings);
    }

//    /**
//     * 解析汇总信息,通过特殊的tag来指定需要显示的字段
//     *
//     * @param pageDefine
//     * @param summaryFields
//     */
//    private void analysisSummaryFields(T pageDefine, PcUiBotTmDataState tmDataState, List<TmSummaryField> summaryFields) {
//        List<DataTag> dataTags = new ArrayList<>();
//        for (TmSummaryField tmSummaryField : summaryFields) {
//            DataTag dataTagDTO = new DataTag();
//            dataTags.add(dataTagDTO);
//            dataTagDTO.setField(String.format("%s.response.%s", tmSummaryField.getActionId(), tmSummaryField.getValue()));
//            dataTagDTO.setTag(tmSummaryField.getTag());
//            dataTagDTO.setTags(tmSummaryField.getTags());
//            dataTagDTO.setActionId(tmSummaryField.getActionId());
//            dataTagDTO.setBusinessInfo(tmSummaryField.getBusinessInfo());
//            dataTagDTO.setSummary(tmSummaryField.getSummary());
//            dataTagDTO.setSearchKey(tmSummaryField.getSearchKey());
//            dataTagDTO.setDataSourceName(tmSummaryField.getDataSourceName());
//        }
//        pageDefine.setDataTags(dataTags);
//    }

    /**
     * 解析卡片状态标签
     *
     * @param pageDefine
     * @param taskStates
     */
    private void analysisTaskStates(T pageDefine, List<PcUiBotTmActivityStates> taskStates) {
        pageDefine.setTaskStates(taskStates);
    }

    /**
     * 解析提交的逻辑
     *
     * @param pageDefine
     */
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
    }

    /**
     * 处理操作的定义
     *
     * @param pageDefine
     * @param operations
     */
    protected void analysisOperators(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
    }

    protected List<PcUiBotOperationDTO> filterActiveOperationsWhenBacklogFinished(List<PcUiBotOperationDTO> operationList) {
        if (CollectionUtils.isEmpty(operationList)) {
            return operationList;
        }
        return operationList.stream().filter(operation -> BooleanUtils.isTrue(operation.getApplyAlthoughFinished())).collect(Collectors.toList());
    }

    /**
     * 处理查询的逻辑
     *
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @return
     */
    protected abstract void analysisDataSource(PcUiBotExecuteContext executeContext, T pageDefine,
                                               PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState,
                                               Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter);


    /**
     * 获取所有数据源（目前是卡片列表数据源不是主数据源场景使用）
     *
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @return
     */
    protected abstract void analysisAllDataSource(PcUiBotExecuteContext executeContext, T pageDefine,
                                                  PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState,
                                                  PcUiBotTmDataFilter tmDataFilter);
//    /**
//     * xuxx 解析汇总信息,通过特殊的tag来指定需要显示的字段
//     *
//     * @param pageDefine
//     * @param customizeTags
//     */
//    private void analysisCustomizeTags(T pageDefine, List<TmCustomizeTags> customizeTags) {
//        List<PcUiBotDataTag> dataTags = new ArrayList<>();
//        for (TmCustomizeTags customizeTag : customizeTags) {
//            PcUiBotDataTag dataTagDTO = new PcUiBotDataTag();
//            dataTags.add(dataTagDTO);
//            dataTagDTO.setField(String.format("%s.response.%s", customizeTag.getActionId(), customizeTag.getValue()));
//            dataTagDTO.setTag(customizeTag.getTag());
//            dataTagDTO.setTags(customizeTag.getTags());
//        }
//        pageDefine.setDataTags(dataTags);
//    }

    protected void convertToUnion(PcUiBotDataSourceSetDTO dataSourceSetDTO) {
        if (dataSourceSetDTO.getDataSourceList() != null
                && dataSourceSetDTO.getDataSourceList().size() > 1) {
            Map<String, List<PcUiBotDataSourceDTO>> groupDs = dataSourceSetDTO.getDataSourceList().stream().collect(
                    Collectors.groupingBy(PcUiBotDataSourceDTO::getName)
            );
            dataSourceSetDTO.getDataSourceList().clear();
            for (List<PcUiBotDataSourceDTO> dataSourceDTOS : groupDs.values()) {
                if (dataSourceDTOS.size() > 1) {
                    PcUiBotDataSourceDTO allDs = new PcUiBotDataSourceDTO();
                    allDs.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_UNION);
                    allDs.setUnionItems(dataSourceDTOS);
                    allDs.setName(dataSourceDTOS.get(0).getName());
                    allDs.setDataKeys(dataSourceDTOS.get(0).getDataKeys());
                    allDs.setActionId(dataSourceDTOS.get(0).getActionId());
                    allDs.setAction(dataSourceDTOS.get(0).getAction());
                    allDs.setMergeQuery(true);
                    dataSourceSetDTO.getDataSourceList().add(allDs);
                } else {
                    dataSourceSetDTO.getDataSourceList().add(dataSourceDTOS.get(0));
                }
            }
        }
    }

    /**
     * 获取词库
     *
     * @param pageDefine
     * @param showMetadatas
     */
    private void analysisShowMetadatas(T pageDefine, PageFieldMetaData showMetadatas) {
        String dataSourceName = "";
        if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
            dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
        }
        List<ScoredFieldsSummary> newScoreWords = showMetadatas.getNewScoreWords();
        if (!CollectionUtils.isEmpty(newScoreWords)) {
            List<String> showDataProperties = new ArrayList<>();
            for (ScoredFieldsSummary scoreWords : newScoreWords) {
                if (CollectionUtils.isEmpty(scoreWords.getFields())) {
                    continue;
                }
                if (StringUtils.hasLength(dataSourceName) && !scoreWords.getTarget().contains(dataSourceName)) {
                    if ("M".equals(scoreWords.getType())) {
                        scoreWords.setTarget(dataSourceName);
                    } else if ("D".equals(scoreWords.getType())) {
                        String target = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 1];
                        scoreWords.setTarget(dataSourceName + "." + target);
                    } else if ("SD".equals(scoreWords.getType())) {
                        // 构建target,之前构建的方式为M.D.SD会变成M.SD.D需修改成M.D.SD
                        String target1 = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 2];
                        String target2 = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 1];
                        scoreWords.setTarget(dataSourceName + "." + target1 + "." + target2);
                    }
                }
                showDataProperties.addAll(scoreWords.getFields()
                        .stream().map(ScoredField::getFieldName)
                        .collect(Collectors.toList()));
            }
            pageDefine.setShowDataProperties(showDataProperties);
            pageDefine.setShowMetadatas(newScoreWords);
        }
    }

    /**
     * 根据每个按钮的SubmitType重新构建SubmitType
     *
     * @param dataState
     */
    protected void analysisSubmitType(PcUiBotTmDataState dataState) {
        if (CollectionUtils.isEmpty(dataState.getSubmitActions())) {
            return;
        }
        boolean exists = false;
        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
        submitType.setIsBatch(false);
        for (PcUiBotTmAction action : dataState.getSubmitActions()) {
            if (action.getSubmitType() != null) {
                submitType.setSchema(action.getSubmitType().getSchema());
                submitType.setSubmitAll(action.getSubmitType().getSubmitAll());

                if (Objects.equals(action.getSubmitType().getIsBatch(), true)
                        || (Objects.nonNull(dataState.getSubmitType()) && Objects.equals(dataState.getSubmitType().getIsBatch(), true))) {
                    submitType.setIsBatch(true);
                    exists = true;
                    break;
                }
            }
        }
        if (exists) {
            dataState.setSubmitType(submitType);
            dataState.getSubmitActions()
                    .forEach(action -> {
                        if (action.getSubmitType() != null) {
                            action.getSubmitType().setIsBatch(submitType.getIsBatch());
                        }
                    });
        }
    }

    /**
     * 重新处理数据状态数据
     * 根据设计器配置的属性showTitle(是否显示数据状态名称)、defaultTabMobileCode(预设页面)
     *
     * @param tmActivity
     */
    protected void handleDataState(PcUiBotTmActivity tmActivity) {
        PcUiBotTmPage pages = tmActivity.getPages();
        if (pages == null) {
            return;
        }
        List<PcUiBotTmDataState> dataStates = pages.getDataStates();
        if (CollectionUtils.isEmpty(dataStates)) {
            return;
        }
        // 每个数据状态增加预设页面属性
        dataStates.forEach(dataState -> {
            dataState.setDefaultTabMobileCode(pages.getDefaultTabMobileCode());
            dataState.setShowSingleHeadFrom(pages.getShowSingleHeadFrom());
        });

        boolean existShowTitle = dataStates.stream().anyMatch(r -> BooleanUtils.isTrue(r.getShowTitle()));
        if (existShowTitle) {
            // 存在数据状态显示标题，则去除未显示标题的数据状态
            dataStates = dataStates.stream().filter(r -> BooleanUtils.isTrue(r.getShowTitle())).collect(Collectors.toList());
        } else {
            // 不存在数据状态显示标题，则只取第一个数据状态展示
            dataStates = Lists.newArrayList(dataStates.get(0));
        }
        pages.setDataStates(dataStates);
    }

    /**
     * 数据状态dataState下layout组件中的sumitAction属性提取到外层，统一构建
     *
     * @param tmActivity
     */
    protected void buildDataStateSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() == null) {
            return;
        }
        if (TaskStringUtil.isBizSmartAdjust(tmActivity.getActivityId())) {
            // 随心控(人工型：code+_task_manual;审核型：code+_task_approve)场景下直接返回，因与PC共用按钮，不使用移动配置的提交类按钮
            return;
        }
        List<PcUiBotTmDataState> dataStates = tmActivity.getPages().getDataStates();
        if (CollectionUtils.isEmpty(dataStates)) {
            return;
        }
        dataStates.forEach(dataState -> {
            List<PcUiBotTmAction> submitAction = this.buildSubmitAction(dataState.getPageLayout());
            if (submitAction != null) {
                dataState.setSubmitActions(submitAction);
            }
        });
    }

    /**
     * 数据录入/发起项目下layout组件中的sumitAction属性提取到外层，统一构建
     *
     * @param tmActivity
     */
    protected void buildPageSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() == null) {
            return;
        }
        PcUiBotTmPage page = tmActivity.getPages();
        List<PcUiBotTmDataState.Layout> layout = page.getLayout();
        if (CollectionUtils.isEmpty(layout)) {
            return;
        }
        PcUiBotTmDataState tmDataState = new PcUiBotTmDataState();
        tmDataState.setLayout(layout);
        List<PcUiBotTmAction> submitAction = this.buildSubmitAction(tmDataState.getPageLayout());
        if (submitAction != null) {
            page.setSubmitActions(submitAction);
        }
    }

    /**
     * 数据录入2。0下layout组件中的sumitAction属性提取到外层，统一构建
     *
     * @param dataState
     */
    public void buildPageSubmitAction(PcUiBotTmDataState dataState) {
        List<PcUiBotTmDataState.Layout> layout = dataState.getLayout();
        if (CollectionUtils.isEmpty(layout)) {
            return;
        }
        List<PcUiBotTmAction> submitAction = this.buildSubmitAction(dataState.getPageLayout());
        if (submitAction != null) {
            dataState.setSubmitActions(submitAction);
        }
    }

    /**
     * layout组件中的sumitAction属性提取到外层，统一构建
     *
     * @param pageLayout
     */
    private List<PcUiBotTmAction> buildSubmitAction(List<UiBotPageLayout> pageLayout) {
        if (CollectionUtils.isEmpty(pageLayout)) {
            return null;
        }
        List<PcUiBotTmAction> submitActions = new ArrayList<>();
        pageLayout.forEach(r -> {
            r.getBody().forEach(body -> {
                if (body.getData() instanceof Button) {
                    this.handleButton(body.getSchema(), (Button) body.getData(), submitActions);
                } else if (body.getData() instanceof ZtbViewList) {
                    ZtbViewList ztbViewList = (ZtbViewList) body.getData();
                    Card card = ztbViewList.getCardListData();
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = card.getCardButtons();
                    if (!CollectionUtils.isEmpty(cardButtons)) {
                        cardButtons.forEach(cardButton -> this.handleButtonGroup((ButtonGroup) cardButton.getData(), submitActions));
                    }
                } else if (body.getData() instanceof Card) {
                    Card card = (Card) body.getData();
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = card.getCardButtons();
                    if (!CollectionUtils.isEmpty(cardButtons)) {
                        cardButtons.forEach(cardButton -> this.handleButtonGroup((ButtonGroup) cardButton.getData(), submitActions));
                    }
                }
            });
            r.getBottom().forEach(bottom -> {
                if (bottom.getData() instanceof ButtonGroup) {
                    this.handleButtonGroup((ButtonGroup) bottom.getData(), submitActions);
                }
            });
        });
        return submitActions;
    }

    private void handleButtonGroup(ButtonGroup buttonGroup, List<PcUiBotTmAction> submitActions) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
        if (CollectionUtils.isEmpty(contentGroup)) {
            return;
        }
        contentGroup.forEach(item -> this.handleButton(item.getSchema(), item.getData(), submitActions));
    }

    private void handleButton(String schema, Button<?> button, List<PcUiBotTmAction> submitActions) {
        UiBotAction action = button.getSubmitAction();
        if (action != null && ButtonTypeEnum.isNotJump(action.getBtnType())) {
            // submitAction不为空，并且非jump跳转类型
            action.setUuid(schema);
            submitActions.add(JsonUtil.objectToJavaObject(action, new TypeReference<PcUiBotTmAction>() {
            }));
        }
    }

    /**
     * 数据录入 -- 处理主数据源
     * 多数据源场景：处理主数据源 --- 特殊处理：因数据录入无主数据源概念，故取sequence=0的作为主数据源
     */
    public void handleMainDataSource(PcUiBotTmActivity tmActivity, PcUiBotExecuteContext executeContext) {
        if (tmActivity == null || tmActivity.getPages() == null || tmActivity.getDataSources() == null) {
            return;
        }
        if (Objects.equals(UiBotDesignerService.PAGECODE_BROWSE_PAGE, executeContext.getPageCode())
                && !ObjectUtils.isEmpty(tmActivity.getPages().getDataViewQuerys())) {
            return;
        }
        Map<String, PcUiBotTmQueryAction> dataSources = tmActivity.getDataSources();
        if (dataSources.size() <= 1) {
            // 只有一个数据源，不需要处理
            return;
        }
        // 如果dataSourceName对应的sequence为0，则直接返回 --- 数据录入编辑页面对应数据源配置sequence=0
        Optional<Map.Entry<String, PcUiBotTmQueryAction>> optional = dataSources.entrySet().stream()
                .filter(entry -> Objects.equals(entry.getKey(), tmActivity.getPages().getDataSourceName())
                        && entry.getValue().getSequence() == 0)
                .findFirst();
        if (optional.isPresent()) {
            return;
        }
        // 查找sequence为0的数据源
        String dataSourceName = dataSources.entrySet().stream()
                .filter(entry -> {
                    if (!CollectionUtils.isEmpty(tmActivity.getPages().getDataSourceNames())) {
                        return tmActivity.getPages().getDataSourceNames().contains(entry.getKey())
                                && entry.getValue().getSequence() == 0;
                    }
                    return entry.getValue().getSequence() == 0;
                })
                .map(Map.Entry::getKey)
                .findFirst()
                .orElse(null);
        // 如果没有找到sequence为0的数据源，直接返回
        if (dataSourceName == null) {
            return;
        }
        tmActivity.getPages().setDataSourceName(dataSourceName);
    }

    /**
     * 根据数据源viewCode补充dsl
     *
     * @param pageDefine
     * @param tmActivity
     * @param dataState
     */
    protected void analysisDataSourceViewCode(T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState) {
        List<String> specialPageCode = Lists.newArrayList(UiBotDesignerService.PAGECODE_PROJECT_DETAIL, UiBotDesignerService.PAGECODE_TASK_DETAIL);

        // 从运行时当前线程容器中获取viewCode
        String viewCode =
                PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, String.class).orElse("");

        //根据viewCode去查询PageUIElement
        if (!StringUtils.isEmpty(viewCode)) {

            String pageCode = pageDefine.getExecuteContext().getPageCode();
            if (specialPageCode.contains(pageCode)) {
                /**
                 * 特殊处理pageCode,项目详情/任务详情 根据viewCode去获取dsl，需要把pageCode，后面增加dataState的code
                 * 因为在项目详情/任务详情会出现同一个视图viewCode因为dataState不同，而展示的页面是不一样的
                 * 所以这里使用了pageCode+dataState.
                 */
                pageCode = pageCode.concat("-").concat(dataState.getCode());
            }
            dataViewService.buildDslByViewCode(viewCode, tmActivity.getActivityId(), pageCode, dataState, pageDefine.getExecuteContext());
            buildPageSubmitAction(dataState);
        }

        if (pageDefine instanceof PcUiBotDoubleDocumentPageDefine) {
            PcUiBotDoubleDocumentPageDefine pcUiBotDoubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine) pageDefine;
            if (CollectionUtils.isEmpty(pcUiBotDoubleDocumentPageDefine.getDataViewQueryList())) {
                Optional<List> dataViewQueryList = PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.DATA_VIEW_QUERYS, List.class);
                if (dataViewQueryList.isPresent()) {
                    pcUiBotDoubleDocumentPageDefine.setDataViewQueryList(dataViewQueryList.get());
                }
            }
        }
    }
}
