package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.BaseDataDoubleCombineSubmitActionParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * <p>功能描述：基础资料录入解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataDoubleDocumentPageDefineAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 16:40
 */
@Service
public class BaseDataDoubleDocumentPageDefineAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotDoubleDocumentPageDefine> {

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private GeneralDataSourceService generalDataSourceService;

    @Autowired
    private TmPageOperationService tmPageOperationService;

    @Autowired
    private DataViewService dataViewService;

    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    public List<PcUiBotDoubleDocumentPageDefine> analysis(PcUiBotExecuteContext executeContext) {
        // 获取基础资料录入的活动定义
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        //临时处理，用于兼容没有配置双档的页面
//        if (tmActivity.getPages() == null
//                || (tmActivity.getPages() != null
//                && tmActivity.getPages().getShowDataProperties() == null
//                && tmActivity.getPages().getSubmitActions() == null
//                && tmActivity.getPages().getDataSourceName() == null
//                && tmActivity.getPages().getGridConfig() == null)) {
//            executeContext.setPageCode(ActivityConstants.BASIC_DATA);
//            tmActivity = themeMapService.getActivityWithoutTaskId(executeContext.getPageCode(), executeContext.getTmActivityId(), executeContext.getLocale());
//        }
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        // 多数据源场景：处理主数据源 --- 特殊处理：因数据录入无主数据源概念，故取sequence=0的作为主数据源
        // 方案变动，不需要特殊处理
        //过滤模型驱动2.0的浏览页，需要重新处理一下数据源，防止主数据源错乱
        this.handleMainDataSource(tmActivity, executeContext);
        // wjw TODO: 2024/3/25 数据录入PC uibot模式下 移动DSL支持方式，临时处理~~  替换DSL和DataSources
        this.replaceDslAndDataSources(tmActivity, executeContext.getPageCode());
        // 数据录入下layout组件中的sumitAction属性提取到外层，统一构建
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }

    private void replaceDslAndDataSources(PcUiBotTmActivity tmActivity, String pageCode) {
        if (!Arrays.asList("DataEntry_pccProjectQuestionList").contains(tmActivity.getActivityId())) {
            return;
        }
        // wjw TODO: 2024/12/3 目前只有DataEntry_pccProjectQuestionList页面需要替换DSL和DataSources,故先传递MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue()
        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneDsl(tmActivity.getActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (config == null) {
            return;
        }
        // 替换移动设计DSL
        PcUiBotTmPage page = this.replaceDsl(pageCode, config);
        if (page != null) {
            tmActivity.setPages(page);
        }
        Map<String, PcUiBotTmQueryAction> dataSources = this.replaceDataSources(tmActivity.getDataSources(), config);
        if (dataSources != null) {
            tmActivity.setDataSources(dataSources);
        }
    }

    public PcUiBotTmPage replaceDsl(String pageCode, MobileDesignerConfig config) {
        JSONObject pageJson = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> {
                    if (UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(pageCode)) {
                        return r.getJSONObject("pageDslMobile");
                    } else if (UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(pageCode)) {
                        return r.getJSONObject("detailDslMobile");
                    }
                    return null;
                }).orElse(null);
        if (pageJson == null) {
            return null;
        }
        PcUiBotTmPage page = JsonUtil.objectToJavaObject(pageJson, PcUiBotTmPage.class);
        JSONObject dataSources = pageJson.getJSONObject("dataSources");
        if (dataSources == null || dataSources.isEmpty()) {
            return page;
        }
        dataSources.keySet().stream().findFirst().ifPresent(page::setDataSourceName);
        return page;
    }


    private Map<String, PcUiBotTmQueryAction> replaceDataSources(Map<String, PcUiBotTmQueryAction> oldDataSources, MobileDesignerConfig config) {
        oldDataSources = Optional.ofNullable(oldDataSources).orElse(new HashMap<>());
        Map<String, String> productNameMap = new HashMap<>();
        oldDataSources.forEach((key, value) -> {
            if (StringUtils.isNotBlank(value.getProductName())) {
                productNameMap.put(key, value.getProductName());
            }
        });
        Map<String, PcUiBotTmQueryAction> tempDataSources = new HashMap<>();
        Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> r.get("dataSources"))
                .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<Map<String, PcUiBotTmQueryAction>>() {
                }))
                .ifPresent(tempDataSources::putAll);
        Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> r.getJSONObject("detailDslMobile"))
                .map(r -> r.get("dataSources"))
                .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<Map<String, PcUiBotTmQueryAction>>() {
                }))
                .ifPresent(tempDataSources::putAll);

        String productName = "";
        for (String key : tempDataSources.keySet()) {
            if (StringUtils.isNotBlank(productNameMap.get(key))) {
                productName = productNameMap.get(key);
                break;
            }
        }

        for (Map.Entry<String, PcUiBotTmQueryAction> entry : tempDataSources.entrySet()) {
            String key = entry.getKey();
            PcUiBotTmQueryAction value = entry.getValue();
            if (!oldDataSources.containsKey(key)) {
                if ("DataEntry_pccProjectQuestionList".equals(Optional.ofNullable(config).map(MobileDesignerConfig::getTmActivityId).orElse(""))
                        && "esp_bm.basc.project.question.detail.get".equals(value.getActionId())) {
                    // PCC_项目问题清单定制：因编辑页对应API(产品别:BM-BASC)与浏览页对应API(产品别:PCC)不一致，需要特殊处理下
                    value.setProductName("BM-BASC");
                } else {
                    value.setProductName(productName);
                }
                oldDataSources.put(key, value);
            }
        }
        return oldDataSources;
    }

    /**
     * 处理查询的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @param dataSources
     * @param tmDataFilter
     * @return
     */
    @Override
    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, dataSources);
        if (BooleanUtils.isTrue(executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                // 数据源类型修改为回收站类型
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_RECYCLE);
            }
        }
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine,
                                         PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState,
                                         PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        if (BooleanUtils.isTrue(executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                // 数据源类型修改为回收站类型
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_RECYCLE);
            }
        }
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    @Override
    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmDataState dataState) {
        List<PcUiBotTmDataViewQuery> tmDataViewQueryList = dataState.getDataViewQuerys();
        if (CollectionUtils.isEmpty(tmDataViewQueryList)) {
            return;
        }
        pageDefine.setDataViewQueryList(pageDefine.convertDataViewQueryList(tmDataViewQueryList));
        List<PcUiBotDataViewQueryDTO> dataViewQueryList = pageDefine.getDataViewQueryList();
//        // 将默认数据源添加到数据视图集合最后；约定通过数据源名称是否存在来判断
//        if (StringUtils.isNotBlank(pageDefine.getDataSourceName())) {
//            PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
//            dataViewQueryList.add(pageDefine.dataSourceToView(dataSourceSet));
//        }
        // 清空是为了根据默认视图重新生成
        pageDefine.setDataSourceSet(null);
        // 默认数据视图，默认取第一个
        PcUiBotDataViewQueryDTO dataViewQueryDefault = dataViewQueryList.stream()
                .filter(dataView -> BooleanUtils.isTrue(dataView.getIsDefault()))
                .findFirst()
                .orElse(dataViewQueryList.get(0));
        dataViewQueryDefault.setIsDefault(Boolean.TRUE);
        String viewCode = dataViewQueryDefault.getViewCode();
        dataViewService.appendNecessaryData(viewCode, pageDefine, executeContext);
        if (CollectionUtils.isEmpty(tmDataViewQueryList) || CollectionUtils.isEmpty(pageDefine.getPageLayout())) {
            // 视图为空，则使用原始的datastate中的pagelayout
            // 留空易读
        } else {
            // 数据视图不为空 dataState中赋值pageLayout，为了防止AbstractPageDefineAnalyzer中再次赋值给pageDefine时被重置
            dataState.setPageLayout(pageDefine.getPageLayout());
        }
    }

    /**
     * 创建一个新的页面
     *
     * @return
     */
    @Override
    protected PcUiBotDoubleDocumentPageDefine createNewPageDefine() {
        return new PcUiBotDoubleDocumentPageDefine();
    }

    /**
     * 重新为每个查询定义独立的上下文
     *
     * @param oldExecuteContext
     * @return
     */
    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        //任务上的每个查询(待处理、已完成等)都需要是新的上下文
        return oldExecuteContext.clone();
    }

    /**
     * 解析提交的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param dataState
     * @param submitActions
     */
    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        // submitService.processBaseData(executeContext, tmActivity, dataState, activityQueryDTO);

        String mainDataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        if (pageDefine.isDefaultShow() && CollectionUtils.isNotEmpty(submitActions)) {
            List<PcUiBotSubmitAction> actionsList = new ArrayList<>();
            List<PcUiBotSubmitAction> tmpSubmitActions = analysisBaseDataSubmitActions(executeContext, mainDataSourceName, dataState, submitActions);
            if (CollectionUtils.isNotEmpty(tmpSubmitActions)) {
                actionsList.addAll(tmpSubmitActions);
            }

            if (actionsList.size() > 0) {
                actionsList.get(0).setDefaultAction(true);
            }

            pageDefine.setSubmitActions(actionsList);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        }
    }

    private List<PcUiBotSubmitAction> analysisBaseDataSubmitActions(PcUiBotExecuteContext executeContext, String mainDataSourceName, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        BaseDataDoubleCombineSubmitActionParser parser
                = SpringContextHolder.getBean(BaseDataDoubleCombineSubmitActionParser.class);
        parser.init(executeContext, dataState, mainDataSourceName);
        return parser.parse(submitActions);
    }

    /**
     * 处理操作的定义
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param operations
     */
    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        if (null == executeContext.getIsRecycle() || BooleanUtils.isFalse(executeContext.getIsRecycle())) {
            //4.1 解析 operations
            tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
        }
    }

    /**
     * 根据任务上的变量来解析基本信息
     *
     * @param pageDefine
     * @param executeContext
     * @param tmPage
     */
    @Override
    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        pageDefine.setDatamap(tmActivity.getDatamap());
        pageDefine.setExplanation(tmPage.getExplanation());
        //xuxx add 标准任务详情 补充字段
        if (tmPage.getShowDataProperties() != null) {
            pageDefine.setShowDataProperties(tmPage.getShowDataProperties());
            pageDefine.getShowDataProperties().add(PcUiBotActivityConstants.EDIT_TYPE);
        }
        if (tmPage.getStatusFlag() != null) {
            pageDefine.setStatusFlag(tmPage.getStatusFlag());
        } else {
            pageDefine.setStatusFlag(false);
        }
        pageDefine.setDataSourceName(tmPage.getDataSourceName());
        if ((UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(executeContext.getPageCode())
                || UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && (PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_RECYCLE.equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(false);
            return;
        }
        if ((UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && (PcUiBotActivityConstants.CATEGORY_SING_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_TREEDATA_SINGLE_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_SINGLE_DOC.equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(true);
            return;
        }
        if ((UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode())
                || UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())) {
            pageDefine.setCanEdit(true);
        }
    }

//    @Override
//    protected void analysisTreeConfig(PcUiBotExecuteContext executeContext,
//                                      PcUiBotDoubleDocumentPageDefine pageDefine,
//                                      PcUiBotTmTreeConfig tmTreeConfig) {
//        SpringUtil.getBean(BaseDataTreeDocumentPageDefineAnalyzer.class)
//                .analysisTreeConfig(executeContext, pageDefine, tmTreeConfig);
//    }

//    @Override
//    protected void analysisTreeConfigInner(ExecuteContext executeContext,
//                                           DoubleDocumentPageDefine pageDefine,
//                                           List<AbstractComponent> layoutList) {
//        SpringUtil.getBean(BaseDataTreeDocumentPageDefineAnalyzer.class)
//                .analysisTreeConfigInner(executeContext, pageDefine, layoutList);
//    }
}
