package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.BaseDataCombineSubmitActionParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class BaseDataPageDefineAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotPageDefine> {

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private GeneralDataSourceService generalDataSourceService;

    @Autowired
    private TmPageOperationService tmPageOperationService;

    public List<PcUiBotPageDefine> analysis(PcUiBotExecuteContext executeContext) {
        // 获取基础资料录入的活动定义
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    private PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        // 多数据源场景：处理主数据源 --- 特殊处理：因数据录入无主数据源概念，故取sequence=0的作为主数据源
        // 方案变动，不需要特殊处理
        //过滤模型驱动2.0的浏览页，需要重新处理一下数据源，防止主数据源错乱
        this.handleMainDataSource(tmActivity, executeContext);
        // 数据录入下layout组件中的sumitAction属性提取到外层，统一构建
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }

    /**
     * 处理查询的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @param dataSources
     * @param tmDataFilter
     * @return
     */
    @Override
    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, dataSources);
        if (BooleanUtils.isTrue(executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                // 数据源类型修改为回收站类型
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_RECYCLE);
            }

        }
        //处理查询字段字段信息
        for (Map.Entry<String, PcUiBotTmQueryAction> tmQueryActionEntry : dataSources.entrySet()) {
            PcUiBotTmQueryAction queryAction = tmQueryActionEntry.getValue();
            List<PcUiBotActionSearchInfoMapping> list = queryAction.getSearchInfos();
            if (null != list && !list.isEmpty()) {
                pageDefine.setSearchInfo(JsonUtil.objectToJavaObject(list, new TypeReference<List<Map>>() {
                }));
            }
        }


        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        if (BooleanUtils.isTrue(executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                // 数据源类型修改为回收站类型
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_RECYCLE);
            }
        }
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    /**
     * 创建一个新的页面
     *
     * @return
     */
    @Override
    protected PcUiBotPageDefine createNewPageDefine() {
        return new PcUiBotPageDefine();
    }

    /**
     * 重新为每个查询定义独立的上下文
     *
     * @param oldExecuteContext
     * @return
     */
    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        //任务上的每个查询(待处理、已完成等)都需要是新的上下文
        return oldExecuteContext.clone();
    }

    /**
     * 解析提交的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param dataState
     * @param submitActions
     */
    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        // submitService.processBaseData(executeContext, tmActivity, dataState, activityQueryDTO);

        String mainDataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        if (pageDefine.isDefaultShow() && !CollectionUtils.isEmpty(submitActions)) {
            List<PcUiBotSubmitAction> actionsList = new ArrayList<>();
            List<PcUiBotSubmitAction> tmpSubmitActions = analysisBaseDataSubmitActions(executeContext, mainDataSourceName, dataState, submitActions);
            if (!CollectionUtils.isEmpty(tmpSubmitActions)) {
                actionsList.addAll(tmpSubmitActions);
            }

            if (actionsList.size() > 0) {
                actionsList.get(0).setDefaultAction(true);
            }

            pageDefine.setSubmitActions(actionsList);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        }
    }

    private List<PcUiBotSubmitAction> analysisBaseDataSubmitActions(PcUiBotExecuteContext executeContext,
                                                                    String mainDataSourceName,
                                                                    PcUiBotTmDataState dataState,
                                                                    List<PcUiBotTmAction> submitActions) {
        BaseDataCombineSubmitActionParser parser =
                SpringContextHolder.getBean("baseDataCombineSubmitActionParser");
        parser.init(executeContext, dataState, mainDataSourceName);
        return parser.parse(submitActions);
    }


    private boolean isRecycleSubmitAction(PcUiBotTmAction tmSubmitAction) {
        return !CollectionUtils.isEmpty(tmSubmitAction.getExtendParas()) && BooleanUtils.isTrue((Boolean) tmSubmitAction.getExtendParas().get("applyToRecycle"));
    }

    /**
     * 处理操作的定义
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param operations
     */
    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        // 要放开operations，不然开窗-多选显示有问题；
        // 在后面的解析从，通过设置pageDefine.setCanEdit=false来设置所有的列都不可编辑
//        if (null == executeContext.getIsRecycle() || BooleanUtils.isFalse(executeContext.getIsRecycle())) {
        //4.1 解析 operations
        tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
//        }
    }

    /**
     * 解析基本信息
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param tmPage
     */
    @Override
    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        super.analysisBaseInfo(executeContext, pageDefine, tmActivity, tmPage);
        if ((UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(executeContext.getPageCode())
                || UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && (PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_RECYCLE.equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(false);
        }
        if ((UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && (PcUiBotActivityConstants.CATEGORY_SING_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_TREEDATA_SINGLE_DOC.equals(executeContext.getCategory())
                || PcUiBotActivityConstants.CATEGORY_SINGLE_DOC.equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(true);
        }
        if ((UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode())
                || UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode()))
                && PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())) {
            pageDefine.setCanEdit(true);
        }
    }
}
