package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：条件页面解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ConditionPageAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2024/9/24 13:12
 */
@Service
public class ConditionPageAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private TmDataSourceService tmDataSourceService;

    @Autowired
    private TmPageOperationService tmPageOperationService;

    @Autowired
    private TmPageSubmitService tmPageSubmitService;

    public PcUiBotPageDefine analysis(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefine(executeContext, tmActivity);
    }

    private PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        // 下layout组件中的sumitAction属性提取到外层，统一构建
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }


    /**
     * 创建一个新的页面
     *
     * @return
     */
    @Override
    protected PcUiBotPageDefine createNewPageDefine() {
        return new PcUiBotPageDefine();
    }

    /**
     * 解析提交的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param dataState
     * @param submitActions
     */
    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        pageDefine.setDefaultShow(true);
        tmPageSubmitService.processBaseData(executeContext, tmActivity, dataState, pageDefine);
    }

    /**
     * 处理操作的定义
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param operations
     */
    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {

        //4.1 解析 operations
        tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
    }


    /**
     * 处理查询的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @param dataSources
     * @param tmDataFilter
     * @return
     */
    @Override
    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = tmDataSourceService.analysis(executeContext, dataSources);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = tmDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }
}
