package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.designer.uibot.support.PcUiBotOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl.DataViewRawDslRenderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * <p>功能描述：数据视图开窗定义解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataViewOpenWindowDefineAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2024/2/2 17:55
 */
@Slf4j
@Service
public class DataViewOpenWindowDefineAnalyzer extends PcUiBotOpenWindowDefineAnalyzer {

    @Resource
    private DataViewService dataViewService;

    @Override
    public PcUiBotOpenWindowDefineDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmOperation tmOperation, Boolean isFlowEngine) {
        PcUiBotTmOperationOpenWindowDefine tmOperationOpenWindowDefine = tmOperation.getOpenWindowDefine();
        PcUiBotTmQueryAction allAction = tmOperationOpenWindowDefine.getAllAction();
        String viewCode = allAction.getViewCode();
        // 获取视图配置
        PcUiBotTmDataViewQuery tmDataViewQuery = dataViewService.queryDataView(viewCode, executeContext);
        if (tmDataViewQuery == null) {
            log.warn("TmDataViewQuery empty, viewCode: {}", viewCode);
            return super.analysis(executeContext, tmOperation, isFlowEngine);
        }
        // 构建查询操作
        PcUiBotTmQueryAction tmQueryAction = dataViewService.buildTmQueryAction(allAction, tmDataViewQuery);
        tmOperationOpenWindowDefine.setAllAction(tmQueryAction);
        // 解析构建开窗定义
        PcUiBotOpenWindowDefineDTO openWindowDefine = super.analysis(executeContext, tmOperation, isFlowEngine);
        // 回填视图展示字段；修改视图配置单头字段和path，为allAction的数据源名称（allActionName）
        String dataSourceName = Optional.ofNullable(openWindowDefine.getAllAction())
                .map(PcUiBotPageDefine::getDataSourceSet)
                .map(PcUiBotDataSourceSetDTO::getMainDatasource)
                .orElse(null);
        PcUiBotTmViewShowFields viewShowFields = tmDataViewQuery.getViewShowFields();
        viewShowFields = DataViewRawDslRenderService.resetNameAndDslPath(dataSourceName, viewShowFields);
        openWindowDefine.setViewShowFields(viewShowFields);
        return openWindowDefine;
    }
}
