package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数据视图页面定义解析器；大部分逻辑复用BaseDataDoubleDocumentPageDefineAnalyzer</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataViewPageDefineAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2023/12/28 9:40
 */
@Slf4j
@Service
public class DataViewPageDefineAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotDataViewPageDefine> {

    private static final ThreadLocal<PcUiBotDataViewPageDefine> CONTEXT_HOLDER = new TransmittableThreadLocal<>();

    @Lazy
    @Autowired
    private DataViewService dataViewService;

    @Autowired
    private GeneralDataSourceService generalDataSourceService;

    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer doubleDocumentPageDefineAnalyzer;

    /**
     * 解析构建数据视图的页面定义对象
     *
     * @param dataViewPageDefine
     * @return 视图页面定义
     */
    public List<PcUiBotDataViewPageDefine> analysis(PcUiBotDataViewPageDefine dataViewPageDefine) {
        // 视图设计有viewCode，Api设计没有viewCode；
        String viewCode = dataViewPageDefine.getViewCode();
        PcUiBotRuntimes.getContext().put(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, viewCode);

        PcUiBotExecuteContext executeContext = dataViewPageDefine.getExecuteContext();
        // 获取基础资料录入的活动定义
        PcUiBotTmActivity tmActivity = doubleDocumentPageDefineAnalyzer.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        try {
            CONTEXT_HOLDER.set(dataViewPageDefine);
            return super.createPageDefines(executeContext, tmActivity);
        } finally {
            CONTEXT_HOLDER.remove();
        }
    }

    @Override
    protected PcUiBotDataViewPageDefine createNewPageDefine() {
        // 数据视图目前仅有一个页面定义,故可以直接使用入参的define
        return CONTEXT_HOLDER.get() == null ? new PcUiBotDataViewPageDefine() : CONTEXT_HOLDER.get();
    }

    @Override
    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);

        // 老模式直接跳出
        if (CollectionUtils.isEmpty(tmActivity.getPages().getDataSourceNames())) {
            return;
        }

        // 从运行时当前线程容器中获取viewCode
        String viewCode =
                PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, String.class).orElse(StringUtils.EMPTY);

        /**
         * 新模式，通用数据源方案，走下面
         * 因为老的视图模式没有数据源，通过视图去解析，不用走数据源分析
         */
        if (StringUtils.isNotBlank(viewCode)) {
            PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, dataSources);
            pageDefine.setDataSourceSet(dataSourceSet);
            pageDefine.setDataStateCode(tmDataState.getCode());
        }
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    @Override
    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmDataState dataState) {
        // 视图设计有viewCode，Api设计没有viewCode；
        String viewCode = pageDefine.getViewCode();
        dataViewService.appendNecessaryData(viewCode, pageDefine, executeContext);
        if (CollectionUtils.isEmpty(dataState.getDataViewQuerys()) || CollectionUtils.isEmpty(pageDefine.getPageLayout())) {
            // 视图为空，则使用原始的datastate中的pagelayout
            // 留空易读
        } else {
            // 数据视图不为空 dataState中赋值pageLayout，为了防止AbstractPageDefineAnalyzer中再次赋值给pageDefine时被重置
            dataState.setPageLayout(pageDefine.getPageLayout());
        }
    }

    @Override
    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return doubleDocumentPageDefineAnalyzer.createNewContext(oldExecuteContext);
    }

    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        doubleDocumentPageDefineAnalyzer.analysisOperators(executeContext, pageDefine, tmActivity, operations);
    }

    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        doubleDocumentPageDefineAnalyzer.analysisSubmitActions(executeContext, pageDefine, tmActivity, dataState, submitActions);
    }

    @Override
    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        doubleDocumentPageDefineAnalyzer.analysisBaseInfo(executeContext, pageDefine, tmActivity, tmPage);
    }

//    @Override
//    protected void analysisTreeConfig(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, TmTreeConfig tmTreeConfig) {
//        doubleDocumentPageDefineAnalyzer.analysisTreeConfig(executeContext, pageDefine, tmTreeConfig);
//    }
//
//    @Override
//    protected void analysisTreeConfigInner(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, List<AbstractComponent> layout) {
//        doubleDocumentPageDefineAnalyzer.analysisTreeConfigInner(executeContext, pageDefine, layout);
//    }
}
