package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述： 发起项目页面解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: StartProjectPageAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2024/12/13 15:52
 */
@Service
public class StartProjectPageAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotPageDefine> {

    @Autowired
    private TmDataSourceService tmDataSourceService;

    @Autowired
    private TmPageOperationService tmPageOperationService;

    @Autowired
    private TmPageSubmitService tmPageSubmitService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    public PcUiBotPageDefine analysis(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        executeContext.setCategory(PcUiBotActivityConstants.Category.START_PROJECT);
        return createStartProjectPageDefine(executeContext, tmActivity);
    }

    private PcUiBotPageDefine createStartProjectPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotPageDefine pageDefine = super.createPageDefine(executeContext, tmActivity);
        if (null != pageDefine) {
            // 添加用户自定义信息
            super.appendUserOrderConditions(executeContext, Collections.singletonList(pageDefine));
        }
        return pageDefine;
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        // 发起项目下layout组件中的sumitAction属性提取到外层，统一构建
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }

    /**
     * 通过移动MongoDB中存储的任务DSL，替换从KM获取的任务定义pages
     *
     * @param tmActivity
     */
    private void replaceDsl(PcUiBotTmActivity tmActivity, PcUiBotExecuteContext executeContext) {
        String tenantVersion = activityFilterService.tenantVersion(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale());
        MobileDesignerConfig config = activityFilterService.selectOneData(tmActivity.getApplication(), tmActivity.getActivityId(), MobileDesignerConfigTypeEnum.START_PROJECT.getValue(), executeContext.getTenantId(), tenantVersion);
        if (config == null) {
            return;
        }
        PcUiBotTmPage page = config.getPages();
        if (page == null) {
            return;
        }
        tmActivity.setPages(page);
    }

    /**
     * 创建一个新的页面
     *
     * @return
     */
    @Override
    protected PcUiBotPageDefine createNewPageDefine() {
        return new PcUiBotPageDefine();
    }

    @Override
    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess(executeContext, tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction(executeContext, tmActivity);
    }

    /**
     * 解析提交的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param dataState
     * @param submitActions
     */
    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        tmPageSubmitService.processBaseData(executeContext, tmActivity, dataState, pageDefine);
    }

    /**
     * 处理操作的定义
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param operations
     */
    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {

        //4.1 解析 operations
        tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
    }

    /**
     * 根据任务上的变量来解析基本信息
     *
     * @param pageDefine
     * @param executeContext
     * @param tmPage
     */
    @Override
    public void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        super.analysisBaseInfo(executeContext, pageDefine, tmActivity, tmPage);
        // 模型驱动的任务类型
        pageDefine.setBindForm(tmActivity.getBindForm());
        pageDefine.setFieldConfig(tmActivity.getFieldConfig());
    }

    /**
     * 处理查询的逻辑
     *
     * @param executeContext
     * @param pageDefine
     * @param tmActivity
     * @param tmDataState
     * @param dataSources
     * @param tmDataFilter
     * @return
     */
    @Override
    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = tmDataSourceService.analysis(executeContext, dataSources);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = tmDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }
}
