package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTaskInfo;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocProxyUserResult;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：任务详情页面定义解析</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskPageDefineAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 20:22
 */
@Slf4j
@Service
public class TaskPageDefineAnalyzer extends AbstractPageDefineAnalyzer<PcUiBotTaskPageDefine> {

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Autowired
    TmPageOperationService tmPageOperationService;

    @Autowired
    private TmTaskPageSubmitService tmTaskPageSubmitService;

    @Autowired
    private NewTaskSubmitService newTaskSubmitService;

    @Autowired
    private DataEntryDrivenSubmitService dataEntryDrivenSubmitService;

    @Autowired
    private TmOtherInfoService tmOtherInfoService;

    @Autowired
    private TmApprovalService tmApprovalService;

    @Autowired
    private NewTaskApprovalService newTaskApprovalService;

    @Autowired
    private LocaleService localeService;

//    @Autowired
//    PtmService ptmService;

//    @Autowired
//    UserService userService;

    /**
     * 任务页面的的定义分析
     *
     * @param executeContext
     * @param activityData
     * @return
     */
    public List<PcUiBotTaskPageDefine> analysis(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, DigiwinAtmcActivityData activityData) {

//        if (activityData == null || CollectionUtils.isEmpty(activityData.getTasks())) {
//            return new ArrayList<>();
//        }
       /* if(BooleanUtils.isTrue(envProperties.isMockTag())){
            // 获取基础资料录入的活动定义
            TmActivity tmActivity = themeMapService.getMockTmActivityDef(executeContext.getPageCode(), executeContext.getTmActivityId());

            executeContext.appendTmActivityInfo(tmActivity);
            return super.createPageDefines(executeContext, tmActivity);
        }*/
        //1.获取到活动定义
        PcUiBotTmActivity tmActivity = this.getActivityAction(apiRequest, executeContext);
        if (tmActivity.getDataSources() == null) {
            String message = MessageFormat.format("任务定义不完整，没有相关的数据源定义,tmActivity：{0}", tmActivity.getActivityId());
            throw new ServiceException(message);
        }
        //2、完善上下文信息
        executeContext.appendTmActivityInfo(tmActivity);
        //3、
        List<PcUiBotTaskPageDefine> taskPageDefineList = super.createPageDefines(executeContext, tmActivity);
        if (null == taskPageDefineList) {
            taskPageDefineList = new ArrayList<>();
        }

        appendInternalPageDefine(executeContext, tmActivity, taskPageDefineList);

        return taskPageDefineList;
    }

    public PcUiBotTmActivity getActivityAction(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        KnowledgeMapsActivityDefinition rawActivityDefinition = Optional.ofNullable(apiRequest).map(ApiRequest::getPatternTaskInfo).map(PatternTaskInfo::getUiBotDesignerConfig).map(UiBotDesignerConfig::getRawTaskActivityDefinition).orElse(null);
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("taskId", executeContext.getTmProjectId());
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        rawActivityDefinition = rawActivityDefinition != null ? rawActivityDefinition :
                this.digiwinKnowledgeMapsProxyService.getActivityDefinition(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        if (TestV1ToV2Util.exist(tmActivity.getActivityId())) {
            // wjw TODO: 2024/8/21 临时处理，后续V1任务卡全部转V2后，移除此判断
            this.replaceDsl(tmActivity, executeContext);
        }
        // 重新处理数据状态数据
        this.handleDataState(tmActivity);
        // 数据状态dataState下layout组件中的sumitAction属性提取到外层，统一构建
        this.buildDataStateSubmitAction(tmActivity);
        //多数据源处理，修改dataSourceName
        UiBotModelDesignerMultipleDataSources.handleMultipleDataSources(tmActivity);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }

    /**
     * 通过移动MongoDB中存储的任务DSL，替换从KM获取的任务定义pages
     *
     * @param tmActivity
     * @param executeContext
     */
    private void replaceDsl(PcUiBotTmActivity tmActivity, PcUiBotExecuteContext executeContext) {
        String tenantVersion = activityFilterService.tenantVersion(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale());
        MobileDesignerConfig config = activityFilterService.selectOneData(tmActivity.getApplication(), tmActivity.getActivityId(), MobileDesignerConfigTypeEnum.TASK.getValue(), executeContext.getTenantId(), tenantVersion);
        if (config == null) {
            return;
        }
        PcUiBotTmPage page = config.getPages();
        if (page == null) {
            return;
        }
        tmActivity.setPages(page);
    }

    /**
     * 重新为每个查询定义独立的上下文
     *
     * @param oldExecuteContext
     * @return
     */
    @Override
    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        //任务上的每个查询(待处理、已完成等)都需要是新的上下文
        return oldExecuteContext.clone();
    }

    @Override
    protected PcUiBotTaskPageDefine createNewPageDefine() {
        return new PcUiBotTaskPageDefine();
    }

    @Override
    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess(executeContext, tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction(executeContext, tmActivity);
    }


    @Override
    protected void analysisApprove(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {
        //4.6 解析审核信息
        if (tmActivity.isFlowEngine()) {
            tmApprovalService.process(executeContext, tmActivity, dataState, pageDefine);
        } else {
            newTaskApprovalService.process(executeContext, tmActivity, dataState, pageDefine);
        }
    }


    @Override
    protected void analysisDataSource(PcUiBotExecuteContext taskExecuteContext, PcUiBotTaskPageDefine pageDefine,
                                      PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState,
                                      Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = taskDataSourceAnalysisService.analysis(taskExecuteContext, tmDataState, dataSources, tmDataFilter);
        pageDefine.setDataSourceSet(dataSourceSetDTO);
        if (null != tmDataFilter) {
            pageDefine.setQueryTitle(tmDataFilter.getTitle());
            pageDefine.setRowSizeType(tmDataFilter.getRowSizeType());
        }
    }

    @Override
    protected void analysisAllDataSource(PcUiBotExecuteContext taskExecuteContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = taskDataSourceAnalysisService.analysis(taskExecuteContext, tmDataState, tmActivity.getDataSources(), tmDataFilter);
        pageDefine.setAllDataSourceSet(dataSourceSetDTO);
    }

    /**
     * 处理操作的定义
     *
     * @param pageDefine
     * @param operations
     */
    @Override
    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        //4.1 解析 operations
        tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
        if (pageDefine.getFinished()) {
            pageDefine.setOperations(filterActiveOperationsWhenBacklogFinished(pageDefine.getOperations()));
        }
    }

    /**
     * 根据任务上的变量来解析基本信息
     *
     * @param pageDefine
     * @param executeContext
     * @param tmPage
     */
    @Override
    public void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        if (executeContext.getTaskWithBacklogDataList() == null
                || executeContext.getTaskWithBacklogDataList().size() == 0) {
            return;
        }
        pageDefine.setPrePerformer(tmPage.getPrePerformer());
        pageDefine.setSubjectMatter(tmPage.getSubjectMatter());
        pageDefine.setSubjectMatterTargets(tmPage.getSubjectMatterTargets());
        pageDefine.setSubjectMatterProperties(tmPage.getSubjectMatterProperties());
        pageDefine.setRoleAttention(tmPage.getRoleAttention());
        pageDefine.setStartApproveActivityName(tmActivity.getStartApproveActivityName());
        pageDefine.setStartApproveActivity(tmActivity.getStartApproveActivity());
        pageDefine.setVersion(tmActivity.isFlowEngine() ? "1.0" : "2.0");

        //xuxx add 增加任务tags，用于存放任务所涉及到的领域、客制的tag
        pageDefine.setDomain(tmPage.getDomain());

        //如果任务已完成，设置相关的信息
        initFinishedInfo(executeContext, pageDefine, tmPage);

        //xuxx add 标准任务详情 补充字段
        pageDefine.setDataKeyProperties(tmPage.getDataKeyProperties());
        pageDefine.setSubjectExpect(tmPage.getSubjectExpect());
        pageDefine.setSubjectShortfall(tmPage.getSubjectShortfall());
        pageDefine.setDataStateCount(tmPage.getDataStates() == null ? 0 : tmPage.getDataStates().size());
        tmOtherInfoService.analysis(pageDefine, tmPage, executeContext.getTaskWithBacklogDataList().get(0).getBpmData());

        // 模型驱动的任务类型
        pageDefine.setBindForm(tmActivity.getBindForm());
        pageDefine.setFieldConfig(tmActivity.getFieldConfig());

        pageDefine.setMerge(tmActivity.getMerge());
    }

    private void initFinishedInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmPage tmPage) {
        //判断任务已经提交
        if (!CollectionUtils.isEmpty(executeContext.getTaskWithBacklogDataList()) && !CollectionUtils.isEmpty(executeContext.getTaskWithBacklogDataList().get(0).getBacklog())) {
            String finishedActionId = executeContext.getTaskWithBacklogDataList().get(0).getBacklog().get(0).getFinishedActionId();
            if (!org.springframework.util.StringUtils.isEmpty(finishedActionId)) {
                //任务合并时，如果有多个 taskWithBacklogData ,优先使用未完成的
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    if (StringUtils.isEmpty(withBacklogData.getBacklog().get(0).getFinishedActionId())) {
                        finishedActionId = null;
                        break;
                    }
                }
            }
            //判断是否为空
            if (!StringUtils.isEmpty(finishedActionId)) {
                pageDefine.setFinished(true);
                pageDefine.setFinishedActionId(finishedActionId);
                List<PcUiBotTmAction> submitActions = null;
                if (!CollectionUtils.isEmpty(tmPage.getDataStates())) {
                    for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
                        if (!CollectionUtils.isEmpty(dataState.getSubmitActions())) {
                            submitActions = dataState.getSubmitActions();
                            break;
                        }
                    }
                }
                if (submitActions != null) {
                    for (PcUiBotTmAction submitAction : submitActions) {
                        if (Objects.equals(submitAction.getId(), finishedActionId)
                                || Objects.equals(submitAction.getActionId(), finishedActionId)) {
                            if (StringUtils.isEmpty(submitAction.getReturnText())) {
                                pageDefine.setFinishedTitle(submitAction.getTitle());
                            } else {
                                pageDefine.setFinishedTitle(getMessageWithLanguage(submitAction.getReturnText(), executeContext.getLocale()));
                            }
                            break;
                        }
                    }
                }
            } else {
                boolean isFinished = !(executeContext.getTaskWithBacklogDataList().stream().filter(x -> Objects.equals(x.getBacklog().get(0).isClosed(), false)).count() > 0);
                pageDefine.setFinished(isFinished);
            }

            String locale = executeContext.getLocale();
            if (StringUtils.isEmpty(locale)) {
                locale = "zh_CN";
            }

            if (StringUtils.isEmpty(pageDefine.getFinishedTitle())) {
                if (Objects.equals(finishedActionId, "athena_bpm_reassign")) {
                    pageDefine.setFinishedTitle(localeService.getLanguageValue(locale, "转派"));
                } else if (Objects.equals(finishedActionId, "athena_bpm_cancel")) {
                    pageDefine.setFinishedTitle(localeService.getLanguageValue(locale, "撤销"));
                } else if (Objects.equals(finishedActionId, PcUiBotConstants.UIBOT_RETRIEVE)) {
                    pageDefine.setFinishedTitle(localeService.getLanguageValue(locale, "已撤回"));
                } else if (Objects.equals(finishedActionId, "uibot_action_id_finished")) {
                    pageDefine.setFinishedTitle(localeService.getLanguageValue(locale, "已结束"));
                } else if (Objects.equals(finishedActionId, "athena_overdue_task_terminate")) {
                    pageDefine.setFinishedTitle(localeService.getLanguageValue(locale, "逾期终止"));
                }
            }
        }
    }

    public static String getMessageWithLanguage(String message, String language) {
        if (StringUtils.isBlank(message)) {
            return message;
        }

        try {
            Map<String, String> map = JsonUtil.jsonStringToObject(message, new TypeReference<Map<String, String>>() {
            });
            return map.get(language);
        } catch (Exception ex) {
            return message;
        }
    }


    /**
     * 解析提交的逻辑
     */
    @Override
    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, List<PcUiBotTmAction> submitActions) {
        List<PcUiBotTmAction> actionList = new ArrayList<>();
        //当任务是已完成时，不管当前页是什么，需要显示撤回按钮
        if (pageDefine.getFinished()) {
            for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                // 老撤回按钮（uibot_retrive）
                if (isRetriveAction(tmAction)) {
                    if (isCanRetrieve(executeContext, 10L)) {
                        buildRetriveSubmitAction(executeContext, tmAction);
                        actionList.add(tmAction);
                    }
                }
                // 新撤回按钮（uibot-task-withdraw），不管支不支持撤回界面都需要展示
                else if (PcUiBotSubmitActionUtil.isTaskWithdrawAction(tmAction)) {
                    actionList.add(tmAction);
                }
                // 提交后还显示的按钮
                else if (PcUiBotSubmitActionUtil.showWhenBacklogFinished(tmAction)) {
                    actionList.add(tmAction);
                }
            }
        }
        // 当任务不是已完成时，非已完成不需要显示旧“撤回”（uibot_retrive）、但要显示新“撤回”（uibot_task_withdraw)
        else {
            for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                // 新的“撤回”按钮，则界面需要展示
                if (PcUiBotSubmitActionUtil.isTaskWithdrawAction(tmAction)) {
                    actionList.add(tmAction);
                }
            }

            // 非已完成页签。剔除“老撤回”按钮
            if (!("completed".equals(tmDataState.getDataFilterCode()) || PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED.equals(pageDefine.getDataStateCode()))) {
                for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                    if (!isRetriveAction(tmAction)) {
                        actionList.add(tmAction);
                    }
                }
            }
        }
        if (pageDefine.getFinished() && CollectionUtils.isEmpty(actionList)) {
            pageDefine.setSubmitActions(null);
            if (isCanRetrieve(executeContext, 30L)) {
                pageDefine.setFinishedTitle("已撤回");
            }
            return;
        }
        if (!CollectionUtils.isEmpty(actionList)) {
            tmDataState.setSubmitActions(actionList);
        }
        if (executeContext.isShared()) {
            //如果是分享的，判断是不是自己的任务。如果是自己的任务，无论是不是分享的，都可以编辑
            if (executeContext.isOwnerBacklog() || isProxy(executeContext.getAuthoredUser(), executeContext.getTaskWithBacklogData().getBacklog().get(0).getPerformerId())) {
                if (tmActivity.isFlowEngine()) {
                    tmTaskPageSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, pageDefine);
                } else {
                    newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, pageDefine);
                }
            }
        } else {
            //非分享的，直接产生
            if (tmActivity.isFlowEngine()) {
                tmTaskPageSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, pageDefine);
            } else {
                newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, pageDefine);
            }
        }
    }

    /**
     * 判断是否代理人
     *
     * @return
     */
    @JsonIgnore
    private boolean isProxy(PcUiBotAuthoredUser currentUser, String performerId) {
        List<EocProxyUserResult.EocProxyUser> proxyTargetUsers = digiwinEocProxyService.getProxyTargetUsers(currentUser.getUserId(), currentUser.getToken());

        if (!CollectionUtils.isEmpty(proxyTargetUsers)) {
            for (EocProxyUserResult.EocProxyUser proxyUser : proxyTargetUsers) {
                if (Objects.equals(performerId, proxyUser.getUserId())) {
                    return true;
                }
            }
        }

        return false;
    }

    private boolean isRetriveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if (PcUiBotConstants.UIBOT_RETRIEVE.equals(tmAction.getActionId())) {
            return true;
        }

        if (!CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                if (isRetriveAction(attachAction)) {
                    return true;
                }
            }
        }
        return false;
    }

    private PcUiBotTmAction getRetriveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return null;
        }
        if (PcUiBotConstants.UIBOT_RETRIEVE.equals(tmAction.getActionId())) {
            return tmAction;
        }

        if (!CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                PcUiBotTmAction retriveAction = getRetriveAction(attachAction);
                if (retriveAction != null) {
                    return retriveAction;
                }
            }
        }
        return null;
    }

    private Boolean isCanRetrieve(PcUiBotExecuteContext executeContext, Long ifRetriveValue) {
//        Map<String, Object> map = new HashMap<>();
//        List<DigiwinAtmcBacklogData> backlog = Optional.ofNullable(executeContext.getTaskWithBacklogData())
//                .map(DigiwinAtmcTaskWithBacklogData::getBacklog)
//                .orElse(new ArrayList<>());
//        List<Long> backlogIds = backlog.stream().map(backlogData -> backlogData.getBacklogId()).collect(Collectors.toList());
//        map.put("workItemIdList", backlogIds);
//        map.put("performerId", executeContext.getAuthoredUser().getUserId());
//        Long ifRetrive = ptmService.ifTaskCanRetrive(map);
//        if (ifRetrive.longValue() == ifRetriveValue) {//10:允许撤回 20:不支持撤回 30:已撤回 40:任务记录不存在
//            return true;
//        }
        return false;
    }

    private void buildRetriveSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmAction tmAction) {
        PcUiBotTmAction submitAction = getRetriveAction(tmAction);
        if (submitAction == null) {
            return;
        }
        submitAction.setId(PcUiBotConstants.UIBOT_RETRIEVE);
        submitAction.setName(PcUiBotConstants.UIBOT_RETRIEVE);
        submitAction.setServiceName(PcUiBotConstants.UIBOT_RETRIEVE);
        submitAction.setUrl("api/task/card/retrieve");
        submitAction.setDefaultAction(true);
        submitAction.setTrackCode(PcUiBotConstants.RETRIEVE);
        submitAction.setTitle("撤回");

        submitAction.setAttachActions(new ArrayList<>());
        submitAction.setActionId(PcUiBotConstants.UIBOT_RETRIEVE);
        submitAction.setActionType(PcUiBotConstants.UIBOT_RETRIEVE);

        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
        submitType.setSchema("data");
        submitType.setIsBatch(false);
        submitAction.setSubmitType(submitType);
        submitAction.setType("UIBOT");

        PcUiBotSubmitExecuteContext submitExecuteContext = new PcUiBotSubmitExecuteContext();
        List<Long> backlogIds = Optional
                .ofNullable(executeContext.getTaskWithBacklogData())
                .map(DigiwinAtmcTaskWithBacklogData::getBacklog)
                .orElse(new ArrayList<>())
                .stream()
                .map(DigiwinAtmcBacklogData::getBacklogId)
                .collect(Collectors.toList());
        submitExecuteContext.setBacklogId(backlogIds.get(0));
        if (StringUtils.isEmpty(executeContext.getTmActivityId())) {
            submitExecuteContext.setTmActivityId("uibotRetriveTask");
        } else {
            submitExecuteContext.setTmActivityId(executeContext.getTmActivityId());
        }
        submitExecuteContext.setClientAgent(executeContext.getClientAgent());
        if (executeContext.getTaskWithBacklogData() != null) {
            submitExecuteContext.setBacklogId(executeContext.getFirstBacklogId());
        }
        if (executeContext.getTaskWithBacklogData() != null
                && !CollectionUtils.isEmpty(executeContext.getTaskWithBacklogData().getBpmData())) {
            submitExecuteContext.setBpmData(executeContext.getTaskWithBacklogData().getBpmData());
        }
        submitExecuteContext.setLocale(executeContext.getLocale());
        submitExecuteContext.setPageCode(executeContext.getPageCode());
        Map extendParas = submitAction.getExtendParas();
        if (null == extendParas) {
            extendParas = new HashMap();
            submitAction.setExtendParas(extendParas);
        }
        extendParas.put("dataSource", "parentResponse");

    }


//    public PcUiBotTaskPageDefine analysisCheckCompleteAction(PcUiBotExecuteContext executeContext, DigiwinAtmcActivityData activityData) {
//        if (activityData == null || CollectionUtils.isEmpty(activityData.getTasks())) {
//            return null;
//        }
//        //1.获取到活动定义
//        PcUiBotTmActivity tmActivity = this.getActivityAction(executeContext);
//        if (tmActivity.getDataSources() == null) {
//            throw new ServiceException("任务定义不完整，没有相关的数据源定义!");
//        }
//        //2、完善上下文信息
//        executeContext.appendTmActivityInfo(tmActivity);
//        //3、
//        if (tmActivity.getPages() == null) {
//            return null;
//        }
//        //获取TM任务页面定义
//        PcUiBotTmPage tmPage = tmActivity.getPages();
//        //根据过滤器来分析需要查询的数据源，并把查询条件、数据处理器合并到数据源上
//        if (CollectionUtils.isEmpty(tmPage.getDataStates())) {
//            return null;
//        }
//
//        List<PcUiBotTaskPageDefine> pageDefines = new ArrayList<>();
//        for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
//            PcUiBotTaskPageDefine pageDefine = createCompleteActionPageDefine(executeContext, tmActivity, tmPage, dataState);
//            if (pageDefine.isDefaultShow()) {
//                return pageDefine;
//            }
//            pageDefines.add(pageDefine);
//        }
//
//        if (!CollectionUtils.isEmpty(pageDefines)) {
//            return pageDefines.get(0);
//        }
//        return null;
//    }


//    private PcUiBotTaskPageDefine createCompleteActionPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {
//
//        PcUiBotTaskPageDefine pageDefine = new PcUiBotTaskPageDefine();
//
//        PcUiBotExecuteContext newExecuteContext = createNewContext(executeContext);
//
//        pageDefine.setExecuteContext(newExecuteContext);
//        newExecuteContext.setDataStateCode(dataState.getCode());
//        pageDefine.setDataStateCode(dataState.getCode());
//        pageDefine.setShowSubmitActions(tmPage.getShowSubmitActions());
//
//        pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
//        PcUiBotTmDataFilter tmDataFilter = null;
//        //xuxx 2022-11-01  调整datafilter的位置，优化到每个具体的page下dataState中，如果同时存在，以page里的datafilter为主
//        if (dataState.getDataFilter() != null) {
//            tmDataFilter = dataState.getDataFilter();
//        } else if (!CollectionUtils.isEmpty(tmActivity.getDataFilters())) {
//            tmDataFilter = tmActivity.getDataFilters().stream()
//                    .filter((filter) -> Objects.equals(filter.getCode(), dataState.getDataFilterCode()))
//                    .findFirst()
//                    .orElse(null);
//        }
//        if (tmDataFilter != null) {
//            pageDefine.setDefaultShow(tmDataFilter.getDefaultFilter());
//        }
//
//        if (!CollectionUtils.isEmpty(tmActivity.getDataSources())) {
//            Map<String, PcUiBotTmQueryAction> dataSources = getDataSources(tmDataFilter, tmActivity);
//            // 如果dataState.submitType==null，则重置dataState.submitType
//            this.analysisSubmitType(dataState);
//            pageDefine.setSubmitType(dataState.getSubmitType());
//            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
//            analysisDataSource(newExecuteContext, pageDefine, tmActivity, dataState, dataSources, tmDataFilter);
//        }
//        if (!CollectionUtils.isEmpty(dataState.getSubmitActions())) {
//            //非分享的，直接产生
//            if (tmActivity.isFlowEngine()) {
//                tmTaskPageSubmitService.createTaskSubmit(executeContext, tmActivity, dataState, pageDefine);
//            } else {
//                newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, dataState, pageDefine);
//            }
//        }
//
//        //如果没有submit，需要去除 SubmitType
//        if (CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
//            pageDefine.setSubmitType(null);
//        }
//        pageDefine.setExtendedFields(tmPage.getExtendedFields());
//        return pageDefine;
//    }

}