package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>功能描述：基数数据提交解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataCombineSubmitActionParser.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 13:03
 */
@Service
@NoArgsConstructor
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class BaseDataCombineSubmitActionParser extends AbstractCombineSubmitActionParser {

    protected PcUiBotExecuteContext executeContext;

    protected String mainDataSourceName;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmDataState tmDataState, String mainDataSourceName) {
        super.init(tmDataState);
        this.executeContext = executeContext;
        this.mainDataSourceName = mainDataSourceName;
    }

    @Override
    public PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        if (!Objects.equals(BooleanUtils.isTrue(executeContext.getIsRecycle()), isRecycleSubmitAction(tmAction))) {
            return null;
        }
        PcUiBotSubmitAction submitAction = submitActionCreateService.createSubmitAction(tmAction,
                executeContext.getTenantId(),
                executeContext.getBusinessUnit(),
                executeContext);
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));
        super.setSubmitType(submitAction, mainDataSourceName);
        return submitAction;
    }

    @Override
    public PcUiBotSubmitAction buildCombineSubmitAction(PcUiBotTmAction tmAction, List<PcUiBotSubmitAction> combineSubmitActionList) {
        if (CollectionUtils.isEmpty(combineSubmitActionList)) {
            return null;
        }
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        submitAction.setCombineActions(combineSubmitActionList);
        submitAction.setActionType(tmAction.getActionType());
        submitAction.setDefaultAction(tmAction.isDefaultAction());
        submitAction.setUuid(tmAction.getUuid());
        submitAction.setBtnId(tmAction.getBtnId());
        submitAction.setBtnType(tmAction.getBtnType());
        submitAction.setJumpAction(tmAction.getJumpAction());
        submitAction.setTitle(tmAction.getTitle());
        submitAction.setId(tmAction.getId());
        submitAction.setSubmitType(tmAction.getSubmitType());
        if (tmAction.getIgnoreRule() != null) {
            submitAction.setIgnoreRule(tmAction.getIgnoreRule());
        }
        submitAction.setCategory(tmAction.getType());
        super.setSubmitType(submitAction, this.mainDataSourceName);
        return submitAction;
    }

    private boolean isRecycleSubmitAction(PcUiBotTmAction tmAction) {
        return !CollectionUtils.isEmpty(tmAction.getExtendParas())
                && BooleanUtils.isTrue((Boolean) tmAction.getExtendParas().get("applyToRecycle"));
    }

}
