package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataDoubleCombineSubmitActionParser.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 11:52
 */
@Service
@NoArgsConstructor
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class BaseDataDoubleCombineSubmitActionParser extends BaseDataCombineSubmitActionParser {

    private static final String EDIT_TYPE_ADD = "add";

    private static final String EDIT_TYPE_COPY = "copy";

    @Override
    public PcUiBotSubmitAction buildCombineSubmitAction(PcUiBotTmAction tmAction, List<PcUiBotSubmitAction> combineSubmitActionList) {
        if (CollectionUtils.isEmpty(combineSubmitActionList)) {
            return null;
        }
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        if (EDIT_TYPE_ADD.equals(executeContext.getEditType())
                || EDIT_TYPE_COPY.equals(executeContext.getEditType())) {
            List<PcUiBotSubmitAction> saveSubmitAction = combineSubmitActionList
                    .stream()
                    .filter(action -> PcUiBotActivityConstants.BasicDataActionType.BASIC_DATA_SAVE
                            .equals(action.getActionType()))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saveSubmitAction)) {
                submitAction = saveSubmitAction.get(0);
            }
        } else {
            List<PcUiBotSubmitAction> updateSubmitAction = combineSubmitActionList
                    .stream()
                    .filter(action -> PcUiBotActivityConstants.BasicDataActionType.BASIC_DATA_UPDATE
                            .equals(action.getActionType()))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(updateSubmitAction)) {
                submitAction = updateSubmitAction.get(0);
            }
        }
        super.setSubmitType(submitAction, super.mainDataSourceName);
        // 数据录入下：当原始按钮类型为COMBINE时，则需要重新赋值，因为构建任务定义返回的action是combineActions下的action
        submitAction.setUuid(tmAction.getUuid());
        submitAction.setBtnId(tmAction.getBtnId());
        submitAction.setBtnType(tmAction.getBtnType());
        submitAction.setJumpAction(tmAction.getJumpAction());
        return submitAction;
    }

}
