package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Service
@NoArgsConstructor
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class BaseDataTreeCombineSubmitActionParser extends BaseDataCombineSubmitActionParser {

    private static final String EDIT_TYPE_ADD = "add";

    private static final String EDIT_TYPE_COPY = "copy";

    @Override
    public PcUiBotSubmitAction buildCombineSubmitAction(PcUiBotTmAction tmAction, List<PcUiBotSubmitAction> combineSubmitActionList) {
        if (CollectionUtils.isEmpty(combineSubmitActionList)) {
            return null;
        }
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        if (EDIT_TYPE_ADD.equals(executeContext.getEditType())
                || EDIT_TYPE_COPY.equals(executeContext.getEditType())) {
            List<PcUiBotSubmitAction> saveSubmitAction = combineSubmitActionList
                    .stream()
                    .filter(action -> PcUiBotActivityConstants.BasicDataActionType.BASIC_DATA_SAVE
                            .equals(action.getActionType()))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saveSubmitAction)) {
                submitAction = saveSubmitAction.get(0);
            }
        } else {
            submitAction.setCombineActions(combineSubmitActionList);
            submitAction.setSubmitType(tmAction.getSubmitType());
            submitAction.setActionType(tmAction.getActionType());
            submitAction.setDefaultAction(tmAction.isDefaultAction());
            submitAction.setUuid(tmAction.getUuid());
            submitAction.setBtnId(tmAction.getBtnId());
            submitAction.setBtnType(tmAction.getBtnType());
            submitAction.setJumpAction(tmAction.getJumpAction());
            submitAction.setTitle(tmAction.getTitle());
            submitAction.setId(tmAction.getId());
            submitAction.setCategory(tmAction.getType());
            submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));
        }
        super.setSubmitType(submitAction, super.mainDataSourceName);
        return submitAction;
    }

}
