package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/**
 * 通用提交解析器
 *
 * @Author hejy
 * @Version 1.0
 * @Date 2023/3/3 13:58
 */
@Service
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class CommonCombineSubmitActionParser extends AbstractCombineSubmitActionParser {

    private PcUiBotExecuteContext executeContext;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        super.init(tmDataState, pageDefine);
        this.executeContext = executeContext;
    }

    @Override
    protected PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        PcUiBotSubmitAction submitAction = submitActionCreateService.createSubmitAction(tmAction,
                executeContext.getTenantId(),
                executeContext.getBusinessUnit(),
                executeContext);
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));
        if (StringUtils.equals(PcUiBotActivityConstants.Category.START_PROJECT, executeContext.getCategory())
                && BooleanUtils.isTrue(tmAction.getIsCustomize())) {
            submitAction.setIsCustomize(true);
            submitAction.setUuid(tmAction.getUuid());
            submitAction.setBtnId(tmAction.getBtnId());
            submitAction.setBtnType(tmAction.getBtnType());
            submitAction.setJumpAction(tmAction.getJumpAction());
            submitAction.setTitle(tmAction.getTitle());
            submitAction.setType(tmAction.getType());
            if (tmAction.getSchema() != null) {
                submitAction.setSchema(tmAction.getSchema());
            }
        }
        if (submitAction.getSubmitType() == null) {
            if (tmDataState.getSubmitType() != null) {
                submitAction.setSubmitType(tmDataState.getSubmitType());
            } else {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(false);
                if (null != pageDefine.getDataSourceSet()) {
                    submitType.setSchema(pageDefine.getDataSourceSet().getMainDatasource());
                }
                submitAction.setSubmitType(submitType);
                tmDataState.setSubmitType(submitType);
            }
        }
        return submitAction;
    }

}
