package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;


import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataEntryDrivenActionCreateService;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 按钮的解析，Scope改成非单例模式是因为调用初始化方法的时候，保证属性是最新的
 *
 * @author yanfenga
 */
@Service
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class DataEntryDrivenSubmitActionParser extends AbstractCombineSubmitActionParser {

    @Resource
    private DataEntryDrivenActionCreateService createService;

    private PcUiBotExecuteContext executeContext;

    private PcUiBotTmActivity tmActivity;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        super.init(tmDataState, pageDefine);
        this.executeContext = executeContext;
        this.tmActivity = tmActivity;
    }

    /**
     * 构造按钮
     *
     * @param tmAction
     * @return
     */
    @Override
    protected PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        PcUiBotTmPage tmPage = tmActivity.getPages();
        // 调用创建按钮
        PcUiBotSubmitAction submitAction = createService.createSubmitAction(executeContext,
                executeContext.getProjectData(),
                executeContext.getTaskWithBacklogData(),
                tmAction,
                tmActivity);
        // 设置参数
        if (submitAction.getSubmitType() == null) {
            if (tmDataState.getSubmitType() != null) {
                submitAction.setSubmitType(tmDataState.getSubmitType());
            } else {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(false);
                submitType.setSchema(pageDefine.getDataSourceSet().getMainDatasource());
                submitAction.setSubmitType(submitType);
                tmDataState.setSubmitType(submitType);
            }
        }
        //如果启用了状态追踪
        if (tmPage.getEnableDataState() != null && tmPage.getEnableDataState()) {
            submitAction.setTargetDataState(tmAction.getTargetDataState());
        }
        //xuxx 增加paras
        if (MapUtils.isNotEmpty(tmAction.getParas())) {
            if (MapUtils.isNotEmpty(submitAction.getParas())) {
                submitAction.getParas().putAll(tmAction.getParas());
            } else {
                submitAction.setParas(tmAction.getParas());
            }
        }
        return submitAction;
    }
}
