package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * <p>功能描述：流程引擎任务提交操作解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: FlowEngineTaskCombineSubmitActionParser.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 11:51
 */
@Service
@NoArgsConstructor
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class FlowEngineTaskCombineSubmitActionParser extends AbstractCombineSubmitActionParser {

    private PcUiBotExecuteContext executeContext;

    private PcUiBotTmActivity tmActivity;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        super.init(tmDataState, pageDefine);
        this.executeContext = executeContext;
        this.tmActivity = tmActivity;
    }

    @Override
    protected PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        PcUiBotTmPage tmPage = tmActivity.getPages();
        PcUiBotSubmitAction submitAction = taskSubmitActionCreateService.create(executeContext,
                executeContext.getProjectData(),
                executeContext.getTaskWithBacklogData(),
                tmAction);
        if (submitAction.getIsCustomize() == null
                || BooleanUtils.isFalse(submitAction.getIsCustomize())) {
            tmApprovalService.setApprovalActionStartApproveActivity(submitAction, tmActivity);
            if (submitAction.getSubmitType() == null && tmDataState.getSubmitType() == null) {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(false);
                submitType.setSchema(pageDefine.getDataSourceSet().getMainDatasource());
                submitAction.setSubmitType(submitType);
                tmDataState.setSubmitType(submitType);
            } else if (submitAction.getSubmitType() == null) {
                submitAction.setSubmitType(tmDataState.getSubmitType());
            }
            if (submitAction.isTaskEngin()) {
                //如果没有定义但是分批提交，则默认默认取查询数据的action
                if (tmAction.getCheckCompleteAction() != null) {
                    PcUiBotDataSourceDTO dataSourceBase = tmDataSourceService.analysis(executeContext, "", tmAction.getCheckCompleteAction(), executeContext.getTaskWithBacklogDataList().get(0).getBpmData());
                    submitAction.setCheckCompleteAction(dataSourceBase);
                } else if (tmDataState.getSubmitType() != null && BooleanUtils.isTrue(tmDataState.getSubmitType().getIsBatch())) {
                    if (!pageDefine.getDataSourceSet().isEmpty() && !Objects.equals(tmAction.getType(), PcUiBotConstants.ACTION_CATEGORY_TM)) {
                        //TM action不需要检查是否完成。
                        submitAction.setCheckCompleteAction(pageDefine.getDataSourceSet().getFirstDataQuery().copyWithoutProcessor());
                    }
                }
            }

            //如果启用了状态追踪
            if (tmPage.getEnableDataState() != null && tmPage.getEnableDataState()) {
                submitAction.setTargetDataState(tmAction.getTargetDataState());
            }
        }
        return submitAction;
    }

}
