package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * <p>功能描述：任务提交操作解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskCombineSubmitActionParser.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 13:18
 */
@Service
@NoArgsConstructor
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class TaskCombineSubmitActionParser extends AbstractCombineSubmitActionParser {

    private static final String PRE_APPROVE_ACTION_TYPE = "TaskEngine";

    private static final String PRE_APPROVE_ACTION_SERVICE = "reapprove";

    private PcUiBotExecuteContext executeContext;

    private PcUiBotTmActivity tmActivity;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        super.init(tmDataState, pageDefine);
        this.executeContext = executeContext;
        this.tmActivity = tmActivity;
    }

    @Override
    protected PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        //是否展示退回重签按钮
        if (!this.showPreApproveAction(tmAction, executeContext)) {
            return null;
        }
        PcUiBotTmPage tmPage = tmActivity.getPages();
        PcUiBotSubmitAction submitAction = newTaskSubmitActionCreateService.create(executeContext,
                executeContext.getProjectData(),
                executeContext.getTaskWithBacklogData(),
                tmAction,
                tmActivity);
        tmApprovalService.setApprovalActionStartApproveActivity(submitAction, tmActivity);
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize()) {
            submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, executeContext.getTaskWithBacklogData()));
            submitAction.setIsCustomize(true);
            submitAction.setUuid(tmAction.getUuid());
            submitAction.setBtnId(tmAction.getBtnId());
            submitAction.setBtnType(tmAction.getBtnType());
            submitAction.setJumpAction(tmAction.getJumpAction());
            submitAction.setTitle(tmAction.getTitle());
            submitAction.setType(tmAction.getType());
            submitAction.setActionParams(tmAction.getActionParams());
            if (tmAction.getSchema() != null) {
                submitAction.setSchema(tmAction.getSchema());
            }
        }

        if (submitAction.getSubmitType() == null) {
            if (tmDataState.getSubmitType() != null) {
                submitAction.setSubmitType(tmDataState.getSubmitType());
            } else {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(false);
                submitType.setSchema(pageDefine.getDataSourceSet().getMainDatasource());
                submitAction.setSubmitType(submitType);
                tmDataState.setSubmitType(submitType);
            }
        }

        if (submitAction.isTaskEngin() || PcUiBotSubmitActionUtil.isTaskWithdrawAction(submitAction)) {
            if (tmAction.getCheckCompleteAction() != null) {
                PcUiBotDataSourceDTO dataSourceBase = tmDataSourceService.analysis(executeContext, "", tmAction.getCheckCompleteAction(), executeContext.getTaskWithBacklogDataList().get(0).getBpmData());
                submitAction.setCheckCompleteAction(dataSourceBase);
            } else if (tmDataState.getSubmitType() != null && BooleanUtils.isTrue(tmDataState.getSubmitType().getIsBatch()) && !Objects.equals(tmDataState.getSubmitType().getByActivity(), true)) {
                if (!pageDefine.getDataSourceSet().isEmpty() && !Objects.equals(tmAction.getType(), PcUiBotConstants.ACTION_CATEGORY_TM)) {
                    //TM pageDefine不需要检查是否完成。
                    submitAction.setCheckCompleteAction(pageDefine.getDataSourceSet().getFirstDataQuery().copyWithoutProcessor());
                }
            }
        }

        //如果启用了状态追踪
        if (tmPage.getEnableDataState() != null && tmPage.getEnableDataState()) {
            submitAction.setTargetDataState(tmAction.getTargetDataState());
        }

        //xuxx 增加paras
        if (!CollectionUtils.isEmpty(tmAction.getParas())) {
            if (!CollectionUtils.isEmpty(submitAction.getParas())) {
                submitAction.getParas().putAll(tmAction.getParas());
            } else {
                submitAction.setParas(tmAction.getParas());
            }
        }
        return submitAction;
    }

    /**
     * 是否可见退回重签按钮
     *
     * @param tmAction
     * @param executeContext
     * @return
     */
    private boolean showPreApproveAction(PcUiBotTmAction tmAction, PcUiBotExecuteContext executeContext) {
        // 兼容模型驱动的按钮
        boolean isModelDriven = PcUiBotPatternUtil.isModelDriven(executeContext);
        if (isModelDriven) {
            return true;
        }
        //是否为退回重签按钮
        if (this.isPreApproveAction(tmAction)) {
            //存在签核信息才可展示此按钮
            if (executeContext.getHasApprove() == null) {
                return false;
            } else {
                return executeContext.getHasApprove();
            }

        }

        return true;
    }

    /**
     * 是否为任务引擎退回重签按钮
     * type为TaskEngine，serviceName为reapprove
     *
     * @param tmAction
     * @return
     */
    private boolean isPreApproveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if (StringUtils.equals(PRE_APPROVE_ACTION_TYPE, tmAction.getType()) &&
                StringUtils.equals(PRE_APPROVE_ACTION_SERVICE, tmAction.getServiceName())) {
            return true;
        }

        if (!CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                if (isPreApproveAction(attachAction)) {
                    return true;
                }
            }
        }
        return false;
    }

}
