package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：查询数据ACTION</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionCreateServiceBase.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 18:10
 */
@Slf4j
public abstract class ActionCreateServiceBase {

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private MetadataService metadataService;
//
//    @Autowired
//    private AthenaDesignerService athenaDesignerService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    protected void appendActionInfo(PcUiBotTmActionBase tmAction, PcUiBotExecuteContext executeContext) {

        if (tmAction instanceof PcUiBotTmQueryAction) {
            PcUiBotTmQueryAction tmQueryAction = (PcUiBotTmQueryAction) tmAction;
            if (tmQueryAction.getLeft() != null) {
                appendActionInfo(tmQueryAction.getLeft(), executeContext);
            }
            if (tmQueryAction.getRightList() != null) {
                for (PcUiBotTmQueryAction action : tmQueryAction.getRightList()) {
                    appendActionInfo(action, executeContext);
                }
            }
        } else if (tmAction instanceof PcUiBotTmAction) {
            PcUiBotTmAction submitAction = (PcUiBotTmAction) tmAction;
            if (submitAction.getAttachActions() != null) {
                for (PcUiBotTmAction action : submitAction.getAttachActions()) {
                    appendActionInfo(action, executeContext);
                }
            }
        }

        if (PcUiBotConstants.ACTION_CATEGORY_ESP.equals(tmAction.getType())) {
            if (CollectionUtils.isEmpty(tmAction.getDataKeys())) {
                PcUiBotApiMetadata metadataDataDTO = this.getMetadata(executeContext, tmAction.getActionId());
                if (metadataDataDTO != null && !CollectionUtils.isEmpty(metadataDataDTO.getResponseFields())) {
                    List<String> dataKeys = PcUiBotApiMetadataUtil.getDataKeys(metadataDataDTO.getResponseFields().get(0).getSubFields());
                    if (!CollectionUtils.isEmpty(dataKeys)) {
                        tmAction.setDataKeys(dataKeys);
                    }
                }
            }
        }

    }

    public PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        // 调用知识图谱的API，获取数据源对应行动（Action）的元数据
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(),
                                executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables("actionId", actionId)
                        .build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult =
                this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    /**
     * 统一处理参数转化
     *
     * @param action
     */
    protected void processActionParas(PcUiBotAction action, PcUiBotExecuteContext executeContext) {
        if (!CollectionUtils.isEmpty(action.getActionParams())) {
            for (PcUiBotActionParameterMapping actionParam : action.getActionParams()) {
                if ("SYSTEM".equals(actionParam.getType())) {
                    if ("SYSTEM_EMPLOYEE_ID".equals(actionParam.getValue())) {
                        actionParam.setValue(digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                        actionParam.setType("CONSTANT");
                    } else if ("SYSTEM_USER_ID".equals(actionParam.getValue())) {
                        actionParam.setValue(executeContext.getAuthoredUser().getUserId());
                        actionParam.setType("CONSTANT");
                    }
                }
                if (!"TM_VARIABLE".equals(actionParam.getType())) {
                    continue;
                }
                Map<String, Object> variableMap = digiwinKnowledgeMapsProxyService
                        .getMechanismParamValue(executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId(), executeContext.getLocale(), actionParam.getValue());
                Object value = variableMap.get(actionParam.getValue());
                //对于TM_VARIABLE这类变量，name代表真正要传给api的变量名，value是指向的变量名
                actionParam.setType("CONSTANT");
                if (value == null) {
                    log.debug("variable get from km is null,variable name is:{}", actionParam.getValue());
                    continue;
                }
                actionParam.setValueType(checkValueType(value));
                if (value instanceof String) {
                    actionParam.setValue(String.valueOf(value));
                } else {
                    actionParam.setValue(JsonUtil.javaObjectToJsonString(value));
                }
            }
        }
        if (action instanceof PcUiBotSubmitAction) {
            PcUiBotSubmitAction submitAction = (PcUiBotSubmitAction) action;
            if (submitAction.getAttachActions() != null) {
                submitAction.getAttachActions().forEach(
                        actionDTO -> processActionParas(actionDTO, executeContext)
                );
            }
        }
    }

    private String checkValueType(Object value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(mapper.writeValueAsString(value));
            if (jsonNode.isContainerNode()) {
                return PcUiBotActionVariable.VariableType.JSON.getValue();
            }
        } catch (Exception e) {
            return "";
        }
        return "";
    }


    /**
     * 创建服务信息节点
     *
     * @param tmActionDTO
     * @param tenantId
     */
    protected PcUiBotActionServiceId createActionServiceId(PcUiBotTmActionBase tmActionDTO, String tenantId) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        if (StringUtils.isEmpty(tmActionDTO.getProductName())) {
            actionServiceId.setProd(null);
        } else {
            actionServiceId.setProd(tmActionDTO.getProductName());
        }
        actionServiceId.setTenant_id(tenantId);
        actionServiceId.setHostAcct("athena");
        if (tmActionDTO.getNeedProxyToken() != null && tmActionDTO.getNeedProxyToken()) {
//            // 优先使用ProxyToken
            if (StringUtils.hasText(AppRequestContext.getContextEntity().getProxyToken())) {
                actionServiceId.setProxyToken(AppRequestContext.getContextEntity().getProxyToken());
            } else if (StringUtils.hasText(AppRequestContext.getContextEntity().getIamUserToken())) {
                actionServiceId.setProxyToken(AppRequestContext.getContextEntity().getIamUserToken());
            }
        }
        actionServiceId.setServiceUri(tmActionDTO.getUrl());
        actionServiceId.setName(tmActionDTO.getServiceName());
        return actionServiceId;
    }

    protected PcUiBotSubmitAction initSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        appendActionInfo(tmAction, executeContext);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setActionId(tmAction.getActionId());
        action.setServiceId(this.createActionServiceId(tmAction, tenantId));
        action.setCategory(tmAction.getType());
        action.setUuid(tmAction.getUuid());
        action.setBtnId(tmAction.getBtnId());
        action.setBtnType(tmAction.getBtnType());
        action.setJumpAction(tmAction.getJumpAction());
        action.setTitle(tmAction.getTitle());
        action.setReturnText(tmAction.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setBackFills(tmAction.getBackFills());
        action.setTargetDataState(tmAction.getTargetDataState());
        action.setConfirm(tmAction.getConfirm());
        action.setActionType(tmAction.getActionType());
        //兼容性处理，迭代14兼容迭代13的配置
        if (action.getActionType() == null
                && tmAction.getExtendParas() != null
                && tmAction.getExtendParas().containsKey("actionType")) {
            action.setActionType(tmAction.getExtendParas().get("actionType").toString());
        }
        action.setId(tmAction.getId());
        action.setActionParams(tmAction.getActionParams());
        action.setCategory(tmAction.getType());
        action.setActionParams(tmAction.getActionParams());

        action.setDefaultAction(true);
        action.setId(tmAction.getId());
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        action.setParas(tmAction.getParas());
        processActionParas(action, executeContext);
        return action;
    }

    /**
     * 任务按钮的校验
     *
     * @param taskWithBacklogData
     */
    protected void taskSubmitActionCheck(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        if (taskWithBacklogData == null || CollectionUtils.isEmpty(taskWithBacklogData.getBacklog())) {
            throw new IllegalArgumentException("无法为不存在的任务创建提交逻辑");
        }
    }

    /**
     * 通用的附件构造
     *
     * @param action
     * @param tmActivity
     */
    protected void addAttachApprovalConfig(PcUiBotSubmitAction action, PcUiBotTmActivity tmActivity) {
//        if (null != tmActivity.getAttachment() && null != tmActivity.getAttachment().getApprovalConfig()) {
//            ApprovalConfigDTO approvalConfig = tmActivity.getAttachment().getApprovalConfig();
//            AttachApprovalConfigDTO attachApprovalConfigDTO = BeanUtil.copyProperties(approvalConfig, AttachApprovalConfigDTO.class);
//            attachApprovalConfigDTO.setReadCategory(Arrays.asList(approvalConfig.getUploadCategory()));
//            attachApprovalConfigDTO.setDeleteCategory(Arrays.asList(approvalConfig.getUploadCategory()));
//            if (null != approvalConfig.getFileUploadLimit()) {
//                attachApprovalConfigDTO.setFileCount(approvalConfig.getFileUploadLimit().getCount());
//                attachApprovalConfigDTO.setFileExtensions(approvalConfig.getFileUploadLimit().getExtensions());
//                attachApprovalConfigDTO.setFileMaxSize(approvalConfig.getFileUploadLimit().getSize());
//            }
//            AttachApprovalConfigDTO.DmcAccount dmcAccount = attachApprovalConfigDTO.getDmcAccount();
//            if (null != dmcAccount && org.apache.commons.lang.StringUtils.isNotBlank(dmcAccount.getPassword())) {
//                // 对密码进行加密
//                dmcAccount.setPassword(Base64Converter.encode(dmcAccount.getPassword()));
//            }
//            action.setAttachmentConfig(attachApprovalConfigDTO);
//        } else {
//            AttachApprovalConfigDTO attachApprovalConfigDTO = new AttachApprovalConfigDTO();
//            attachApprovalConfigDTO.setUploadCategory("approvalAttachment");
//            attachApprovalConfigDTO.setReadCategory(Arrays.asList(attachApprovalConfigDTO.getUploadCategory()));
//            attachApprovalConfigDTO.setDeleteCategory(Arrays.asList(attachApprovalConfigDTO.getUploadCategory()));
//            attachApprovalConfigDTO.setBuckets("");
//            attachApprovalConfigDTO.setFileCount(10);
//            attachApprovalConfigDTO.setFileExtensions(new ArrayList<>());
//            attachApprovalConfigDTO.setFileMaxSize(0);
//            attachApprovalConfigDTO.setDmcAccount(null);
//            action.setAttachmentConfig(attachApprovalConfigDTO);
//        }
    }

}

