package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：dataSource 业务逻辑处理层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionDataSourceAnalysisService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 18:12
 */
@Service
public class ActionDataSourceAnalysisService extends DataSourceAnalysisServiceBase {

    @Autowired
    private QueryActionCreateService queryActionService;

    public PcUiBotDataSourceDTO analysisHasParas(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, Map paras) {
        if (StringUtils.isEmpty(dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        //先把数据源关联的数据处理器拿到
        PcUiBotQueryAction queryAction = null;
        switch (tmAction.getType()) {
            case PcUiBotConstants.ACTION_CATEGORY_ESP:
            case PcUiBotConstants.ACTION_CATEGORY_TM:
            case PcUiBotConstants.ACTION_CATEGORY_RAW_DATA:
            case PcUiBotConstants.ACTION_CATEGORY_SD:
            case PcUiBotConstants.ACTION_CATEGORY_LCDP: {
                queryAction = queryActionService.createQueryHasParasAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), tmAction, paras, executeContext);
                queryAction.setCategory(tmAction.getType());
                break;
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null, true);
        }
        return null;
    }

    public PcUiBotDataSourceDTO analysis(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, Map bpmData) {
        if (StringUtils.isEmpty(dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        //先把数据源关联的数据处理器拿到
        PcUiBotQueryAction queryAction = null;
        switch (tmAction.getType()) {
            case PcUiBotConstants.ACTION_CATEGORY_ATMC:
            case PcUiBotConstants.ACTION_CATEGORY_ESP:
            case PcUiBotConstants.ACTION_CATEGORY_TM:
            case PcUiBotConstants.ACTION_CATEGORY_RAW_DATA:
            case PcUiBotConstants.ACTION_CATEGORY_SD:
            case PcUiBotConstants.ACTION_CATEGORY_LCDP: {
                queryAction = queryActionService.createQueryAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), null, tmAction, bpmData, executeContext);
                queryAction.setCategory(tmAction.getType());
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_PTM_DATA: {
                queryAction = queryActionService.createQueryAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), null, tmAction, bpmData, executeContext);
                DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
                if (taskWithBacklogData != null && taskWithBacklogData.getBacklog() != null) {
                    List<DigiwinAtmcBacklogData> backlogData = taskWithBacklogData.getBacklog();
                    if (!CollectionUtils.isEmpty(backlogData)) {
                        List<Map<String, Object>> workitemList = backlogData.get(0).getWorkitemList();
                        if (!CollectionUtils.isEmpty(workitemList)) {
                            Map<String, Object> map = workitemList.get(0);
                            if (map != null) {
                                String workitemId = MapUtils.getString(map, "id");
                                Map<String, Object> paras = queryAction.getParas();
                                if (paras == null) {
                                    paras = new HashMap<>();
                                    queryAction.setParas(paras);
                                }
                                paras.put("workItemId", workitemId);
                            }
                        }
                    }
                }
//                PcUiBotDataSourceDTO ptmDataSource = new PcUiBotDataSourceDTO();
//                ptmDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_PTM_DATA);
//                ptmDataSource.setName(dataSourceName);
//                ptmDataSource.setActionId(tmAction.getActionId());
//                ptmDataSource.setDataKeys(tmAction.getDataKeys());
//                ptmDataSource.setMetadataFields(tmAction.getMetadataFields());
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_MIX_MERGE: {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                PcUiBotDataSourceDTO left = analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                List<PcUiBotDataSourceDTO> rightList = new ArrayList<>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    PcUiBotDataSourceDTO dataSourceBase = analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    index++;
                }
                PcUiBotDataSourceDTO mergeDataSource = new PcUiBotDataSourceDTO();
                mergeDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_MERGE);
                mergeDataSource.setLeft(left);
                mergeDataSource.setRightList(rightList);
                mergeDataSource.setName(dataSourceName);
                mergeDataSource.setActionId(tmAction.getLeft().getActionId());
                mergeDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                mergeDataSource.setMetadataFields(tmAction.getMetadataFields());
                return mergeDataSource;
            }
            case PcUiBotConstants.ACTION_CATEGORY_MIX_LEFT_JOIN: {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                PcUiBotDataSourceDTO left = analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                List<PcUiBotDataSourceDTO> rightList = new ArrayList<>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    PcUiBotDataSourceDTO dataSourceBase = analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    index++;
                }
                PcUiBotDataSourceDTO leftJoinDataSource = new PcUiBotDataSourceDTO();
                leftJoinDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_LEFT_JOIN);
                leftJoinDataSource.setLeft(left);
                leftJoinDataSource.setRightList(rightList);
                leftJoinDataSource.setName(dataSourceName);
                leftJoinDataSource.setActionId(tmAction.getLeft().getActionId());
                leftJoinDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                leftJoinDataSource.setMetadataFields(tmAction.getMetadataFields());
                leftJoinDataSource.setOverride(tmAction.getOverride());
                return leftJoinDataSource;
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null, true);
        }
        return null;
    }
}
