package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * <p>功能描述：处理AllFields元数据字段---共通部分</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AllFieldsService.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 18:28
 */
@Service
public class AllFieldsService {

    @Autowired
    TagMergeService tagMergeService;

    protected static final Map<String, String> TAG_CATEGORY_LIST = new HashMap();

    static {
        TAG_CATEGORY_LIST.put("POSITION", "提取字段标签");
    }

    private static final String DATA_TYPE_NUMBER = "number";

    private static final String DATA_TYPE_NUMERIC = "numeric";

    private static final String DATA_TYPE_BOOLEAN = "boolean";


    /**
     * xuxx 将元数据所有字段返回给前端；
     * 除了单档的基础资料，那个是个特殊的table组件，暂时先不动。其他普通的grid_table全部加了allFields。
     * 格式：
     * allFields: [{dateType: "string", name: "expense_data_rule_no",defaultValue:""},
     * {dateType: "string", name: "seq",defaultValue:""},…]
     * name：元数据字段名字
     * dateType：元数据字段类型
     * defaultValue ：默认值 ，当datatype为数字和boolean时，返回null,
     * 这时前端将没有defaultValue这个属性，前端自行判断当不存defaultValue时即为null
     *
     * @param headMetadataField
     * @param apiMetadata
     * @return
     */
    public List<PcUiBotAllFields> showAllFields(PcUiBotExecuteContext executeContext, PcUiBotMetadataField headMetadataField, PcUiBotApiMetadata apiMetadata, Object setting, List<PcUiBotGroupMetadataField> tagGroupList, List<String> dataKeys) {

        //拿子表的
        PcUiBotApiMetadata subApiMetadata = new PcUiBotApiMetadata();
        if (headMetadataField != null && PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(headMetadataField.getDataType())
                && headMetadataField.getPath() != null) {
            getSubFieldApiMetadata(headMetadataField, subApiMetadata, apiMetadata);
        } else {
            subApiMetadata = apiMetadata;
        }

        //以下是正常的
        Set<String> setShowFields = new HashSet<>();
        if (headMetadataField.getSubFields() != null) {
            getShowFields(headMetadataField.getSubFields(), setShowFields);
        }

        //解析元数据，并返回给前端
        List<String> tagInterpreterList = Arrays.asList("objectRenderTagInterpreter", "attachmentFileInterpreter");

        List<PcUiBotAllFields> allFields = new ArrayList<>();
        if (subApiMetadata != null && subApiMetadata.getResponseFields() != null) {
            for (PcUiBotMetadataField field : subApiMetadata.getResponseFields()) {
                if (!PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(field.getDataType())) {
                    getAllFeildsOneByOne(executeContext, allFields, field, setting, setShowFields, tagGroupList, dataKeys);
                } else {

                    if (CollectionUtils.isEmpty(dataKeys)) {
                        dataKeys = PcUiBotApiMetadataUtil.getDataKeys(field.getSubFields());
                    }
                    PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(field);
                    if (tagDefinitionDTO != null && tagInterpreterList.contains(tagDefinitionDTO.getInterpreterServiceName())) {
                        getAllFeildsOneByOne(executeContext, allFields, field, setting, setShowFields, tagGroupList, dataKeys);
                    } else if (field.getSubFields() != null) {
                        for (PcUiBotMetadataField subfield : field.getSubFields()) {
                            getAllFeildsOneByOne(executeContext, allFields, subfield, setting, setShowFields, tagGroupList, dataKeys);
                        }
                    }
                }
            }
        }
        return allFields;
    }


    private void getSubFieldApiMetadata(PcUiBotMetadataField subField, PcUiBotApiMetadata subApiMetadata, PcUiBotApiMetadata apiMetadata) {
        subApiMetadata.setServiceName(apiMetadata.getServiceName());
        subApiMetadata.setActionId(apiMetadata.getActionId());
        for (PcUiBotMetadataField subMetadataField : apiMetadata.getResponseFields()) {
            Optional<PcUiBotMetadataField> apiOpt = subMetadataField.getSubFields().stream().filter(meta -> subField.getName().equals(meta.getName())).findFirst();
            if (apiOpt.isPresent()) {
                if (CollectionUtils.isEmpty(subMetadataField.getSubFields())) {
                    continue;
                }
                for (PcUiBotMetadataField subSubMetadataField : subMetadataField.getSubFields()) {
                    if (subField.getName().equals(subSubMetadataField.getName())) {
                        subApiMetadata.setResponseFields(subSubMetadataField.getSubFields());
                        subApiMetadata.setResponseFieldMap(subSubMetadataField.getFieldMap());
                        break;
                    }
                }
            } else {
                for (PcUiBotMetadataField subSubMetadataField : subMetadataField.getSubFields()) {
                    if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subSubMetadataField.getDataType())) {
                        if (CollectionUtils.isEmpty(subSubMetadataField.getSubFields())) {
                            continue;
                        }
                        for (PcUiBotMetadataField sMeta : subSubMetadataField.getSubFields()) {
                            if (subField.getName().equals(sMeta.getName())) {
                                subApiMetadata.setResponseFields(sMeta.getSubFields());
                                subApiMetadata.setResponseFieldMap(sMeta.getFieldMap());
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    private void getShowFields(List<PcUiBotMetadataField> metadataFields, Set<String> setShowFields) {

        for (PcUiBotMetadataField subField : metadataFields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subField.getDataType())) {
                if (subField.getSubFields() != null) {
                    if (CollectionUtils.isEmpty(subField.getTagDefinitions())) {
                        getShowFields(subField.getSubFields(), setShowFields);
                    } else {
                        setShowFields.add(subField.getName());
                    }
                }
            } else {
                setShowFields.add(subField.getName());
            }
        }

    }

    private void getAllFeildsOneByOne(PcUiBotExecuteContext executeContext, List<PcUiBotAllFields> allFields, PcUiBotMetadataField field, Object setting, Set<String> setShowFields, List<PcUiBotGroupMetadataField> tagGroupList, List<String> dataKeys) {
        //得到所有的客制组件
        List<String> customizeFieldList = new ArrayList<>();
        getCustomizeFields(customizeFieldList, field);
        //TODO:判断当前字段是否为客制，不可用元数据来判断
        if (customizeFieldList.contains(field.getName())) {
            PcUiBotAllFields allfields = new PcUiBotAllFields();
            getfeildMap(executeContext, allfields, setting, field, setShowFields, tagGroupList, dataKeys);
            allFields.add(allfields);
            return;
        }
        Object allfieldsDefaultValue = null;
        //判断第一层字段是否为对象，并且存在子集；
        if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(field.getDataType()) && field.getSubFields() != null) {
            Map subfieldDefaultValue = new HashMap();
            //开始循环第二层
            for (PcUiBotMetadataField subfield : field.getSubFields()) {
                PcUiBotAllFields allfields = new PcUiBotAllFields();
                Map defaultValue = new HashMap();

                //判断当前字段是否为客制
                if (customizeFieldList.contains(subfield.getName())) {
                    getfeildMap(executeContext, allfields, setting, subfield, setShowFields, tagGroupList, dataKeys);
                    if (!allFields.contains(allfields)) {
                        allFields.add(allfields);
                    }
                    continue;
                }
                //第三层
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subfield.getDataType()) && subfield.getSubFields() != null
                        && CollectionUtils.isEmpty(field.getTagDefinitions())) {
                    //TODO:第三层解析  有点问需要改进
                    allfields.setName(subfield.getName());
                    allfields.setPath(subfield.getPath());
                    String subFieldDataType = subfield.getDataType();
                    subfield.getSubFields().forEach(subSubField -> {
                        if (!PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subSubField.getDataType())) {
                            defaultValue.put(subSubField.getName(), getPrimitiveTypeDefaultValue(subSubField));
                        } else {
                            if (!PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subSubField.getDataType())) {
                                defaultValue.put(subSubField.getName(), getPrimitiveTypeDefaultValue(subSubField));
                            } else {
                                if (subSubField.isArray()) {
                                    defaultValue.put(subSubField.getName(), new Object[0]);
                                } else {
                                    defaultValue.put(subSubField.getName(), new HashMap<>());
                                }
                            }
                        }
                    });
                    if (subfield.isArray()) {
                        subFieldDataType = "array";
                    }
                    allfields.setDataType(subFieldDataType);
                    allfields.setDefaultValue(defaultValue);
                    allfields.setIsDataKey(Boolean.valueOf(getSettingLevelAndDataKey(executeContext, setting, subfield, setShowFields, tagGroupList, dataKeys).get("isDataKey").toString()));
                    allfields.setLevel(Integer.valueOf(getSettingLevelAndDataKey(executeContext, setting, subfield, setShowFields, tagGroupList, dataKeys).get("level").toString()));
                    if (setShowFields.contains(subfield.getName())) {
                        allfields.setIsShow(true);
                    } else {
                        allfields.setIsShow(false);
                    }
                } else {
                    subfieldDefaultValue.put(subfield.getName(), getPrimitiveTypeDefaultValue(subfield));
                    //getfeildMap(allfields,setting,subfield,setShowFields,tagGroupList);
                }
            }
            if (field.isArray()) {
                List<Object> allfieldsDefaultValueTemp = new ArrayList<>();
                allfieldsDefaultValue = allfieldsDefaultValueTemp;
            } else {
                allfieldsDefaultValue = subfieldDefaultValue;
            }
        } else {
            allfieldsDefaultValue = getPrimitiveTypeDefaultValue(field);
        }
        PcUiBotAllFields allfields = new PcUiBotAllFields();
        allfields.createValue(allfields, field);
        allfields.setDefaultValue(allfieldsDefaultValue);
        allfields.setIsDataKey(Boolean.valueOf(getSettingLevelAndDataKey(executeContext, setting, field, setShowFields, tagGroupList, dataKeys).get("isDataKey").toString()));
        allfields.setLevel(Integer.valueOf(getSettingLevelAndDataKey(executeContext, setting, field, setShowFields, tagGroupList, dataKeys).get("level").toString()));
        if (setShowFields.contains(field.getName())) {
            allfields.setIsShow(true);
        } else {
            allfields.setIsShow(false);
        }

        if (!allFields.contains(allfields)) {
            allFields.add(allfields);
        }
    }

    private PcUiBotAllFields getfeildMap(PcUiBotExecuteContext executeContext,
                                         PcUiBotAllFields allfields, Object setting, PcUiBotMetadataField field,
                                         Set<String> setShowFields,
                                         List<PcUiBotGroupMetadataField> tagGroupList,
                                         List<String> dataKeys) {
        allfields.createValue(allfields, field);
        allfields.setIsDataKey(Boolean.valueOf(getSettingLevelAndDataKey(executeContext, setting, field, setShowFields, tagGroupList, dataKeys).get("isDataKey").toString()));
        allfields.setLevel(Integer.valueOf(getSettingLevelAndDataKey(executeContext, setting, field, setShowFields, tagGroupList, dataKeys).get("level").toString()));
        if (setShowFields.contains(field.getName())) {
            allfields.setIsShow(true);
        } else {
            allfields.setIsShow(false);
        }
        return allfields;
    }

    private Map getSettingLevelAndDataKey(PcUiBotExecuteContext executeContext, Object setting, PcUiBotMetadataField field, Set<String> setShowFields, List<PcUiBotGroupMetadataField> tagGroupList, List<String> dataKeys) {

        Map<String, Object> levelAndDataKey = new HashMap<>();
        //初始化，level默认 不配置 都是 0：第一层，如果有配置根据配置显示；isDataKey默认取元数据上的，如果有配置根据配置显示
        levelAndDataKey.put("level", 1);
        if (CollectionUtils.isNotEmpty(dataKeys)) {
            if (dataKeys.contains(field.getName())) {
                levelAndDataKey.put("isDataKey", true);
            } else {
                levelAndDataKey.put("isDataKey", false);
            }
        } else {
            levelAndDataKey.put("isDataKey", field.isBusinessKey());
        }

        Object settingNew = getGroupFieldLevel(setting, tagGroupList);
        //拿到所有的 merge 字段，如果有配置merge，以merge字段为准
        Set<String> merges = new HashSet<>();
        if (settingNew != null) {
            JSONObject gridSetting = JsonUtil.objectToJavaObject(settingNew, JSONObject.class);
            if (gridSetting != null && gridSetting.get("merge") != null) {
                JSONObject objMerge = gridSetting.getJSONObject("merge");
                JSONArray jsonArrOptions = JsonUtil.objectToJavaObject(objMerge.getString("options"), JSONArray.class);
                if (jsonArrOptions != null) {
                    for (Object options : jsonArrOptions) {
                        settingInterpreter(field, setShowFields, levelAndDataKey, merges, options);
                    }
                }
            }
        }
        if (merges.size() == 0) {
            levelAndDataKey.put("level", 0);
        }
        if (executeContext != null
                && executeContext.getIsRowSpanTree() != null && executeContext.getIsRowSpanTree()) {
            if (!StringUtils.isEmpty(field.getPath())) {
                if (field.getPath().contains(".")) {
                    String[] paths = field.getPath().split("\\.");
                    levelAndDataKey.put("level", Integer.valueOf(paths.length - 1));
                } else {
                    levelAndDataKey.put("level", 0);
                }
            }
        }
        return levelAndDataKey;
    }

    /**
     * 配置的setting解析
     *
     * @param field
     * @param setShowFields
     * @param levelAndDataKey
     * @param merges
     * @param options
     */
    private void settingInterpreter(PcUiBotMetadataField field, Set<String> setShowFields, Map<String, Object> levelAndDataKey, Set<String> merges, Object options) {
        if (options == null) {
            return;
        }
        JSONObject objOptions = JsonUtil.objectToJavaObject(options, JSONObject.class);
        //拿到所有的 merge 字段，如果有配置merge，以merge字段为准
        if (objOptions == null || !objOptions.containsKey("schema")) {
            return;
        }
        if (field.getName().equals(objOptions.getString("schema"))) {
            merges.add(objOptions.getString("schema"));
            if (setShowFields.contains(objOptions.getString("schema"))) {
                if (objOptions.get("level") != null) {
                    levelAndDataKey.put("level", Integer.valueOf(objOptions.getString("level")));
                } else {
                    levelAndDataKey.put("level", 0);
                }
                if (objOptions.get("isDataKey") != null) {
                    levelAndDataKey.put("isDataKey", objOptions.getBoolean("isDataKey"));
                }
            }
        }
    }


    private Object getGroupFieldLevel(Object setting, List<PcUiBotGroupMetadataField> tagGroupList) {

        if (CollectionUtils.isEmpty(tagGroupList)) {
            return setting;
        }
        Set<String> groupName = new HashSet<>();
        for (PcUiBotGroupMetadataField group : tagGroupList) {
            if (group.getTagCode() != null && group.getTagCode().contains("GROUP")
                    && CollectionUtils.isNotEmpty(group.getMetadataFields())) {
                for (PcUiBotMetadataField fieldGroup : group.getMetadataFields()) {
                    if (fieldGroup.getFieldType() != null && "NAME_CODE_COMPONENT".equals(fieldGroup.getFieldType())) {
                        if (CollectionUtils.isNotEmpty(fieldGroup.getSubFields())) {
                            fieldGroup.getSubFields().forEach(a -> groupName.add(a.getName()));
                        }
                    } else {
                        if (StringUtils.isNotEmpty(fieldGroup.getName())) {
                            groupName.add(fieldGroup.getName());
                        }
                    }
                }
            }
        }

        if (setting != null && !groupName.isEmpty()) {
            JSONObject gridSetting = JsonUtil.objectToJavaObject(setting, JSONObject.class);
            if (gridSetting != null && gridSetting.get("merge") != null) {
                JSONObject objMerge = gridSetting.getJSONObject("merge");
                JSONArray jsonArrOptions = JsonUtil.objectToJavaObject(objMerge.getString("options"), JSONArray.class);
                JSONArray jsonArrOptionsNew = new JSONArray();
                if (jsonArrOptions != null) {
                    for (int i = 0; i < jsonArrOptions.size(); i++) {
                        JSONObject objOptions = jsonArrOptions.getJSONObject(i);
                        if (objOptions != null && objOptions.get("schema") != null) {
                            //将原来的值加入新的变量中
                            if (!jsonArrOptionsNew.contains(objOptions)) {
                                jsonArrOptionsNew.add(objOptions);
                            }
                            if (groupName.contains(objOptions.getString("schema"))) {
                                for (String gn : groupName) {
                                    JSONObject objOptionsNews = new JSONObject();
                                    objOptionsNews.put("schema", gn);
                                    if (objOptions.get("level") != null) {
                                        objOptionsNews.put("level", Integer.valueOf(objOptions.getString("level")));
                                    }
                                    //将GROUP中的所有字段加入一个LEVEL
                                    if (!jsonArrOptionsNew.contains(objOptionsNews)) {
                                        jsonArrOptionsNew.add(objOptionsNews);
                                    }
                                }
                            }
                        }
                    }
                }

                if (jsonArrOptionsNew.size() > 0) {
                    objMerge.put("options", jsonArrOptionsNew);
                    gridSetting.put("merge", objMerge);
                    return gridSetting;
                }
            }
        }
        return setting;
    }


    /**
     * 通过打的tag找到所有客制的字段；
     *
     * @param metadataField
     * @return
     */
    private List<String> getCustomizeFields(List<String> customizeFieldList, PcUiBotMetadataField metadataField) {
        if (metadataField != null && !PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
            if (metadataField.getTagDefinitions() != null) {
                PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(metadataField);
                if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                    customizeFieldList.add(metadataField.getName());
                }
            }
        } else {
            if (metadataField.getTagDefinitions() != null) {//NOSONAR
                PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(metadataField);
                if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                    customizeFieldList.add(metadataField.getName());
                }
            } else {
                if (metadataField.getSubFields() != null) {
                    for (PcUiBotMetadataField subFields : metadataField.getSubFields()) {
                        getCustomizeFields(customizeFieldList, subFields);
                    }
                }
            }

        }
        return customizeFieldList;
    }


    /**
     * 生成基本数据类型的默认值：
     * 数组：返回: []
     * 数字：返回：null
     * 布尔：返回：null
     * 日期、字符串，返回：""
     *
     * @param metadataField
     * @return
     */
    private static Object getPrimitiveTypeDefaultValue(PcUiBotMetadataField metadataField) {
        if (metadataField.isArray()) {
            return new String[]{};
        }

        if (DATA_TYPE_NUMBER.equals(metadataField.getDataType()) || DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
            return null;
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
            return null;
        } else {
            return "";
        }
    }
}
