package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.MetadataService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <p>功能描述：附加提交字段到请求元数据中去</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AnalyseSubmitActionFieldService.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 16:42
 */
@Service
public class AnalyseSubmitActionFieldService {

    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    MetadataService metadataService;

    /**
     * 添加编辑字段
     */
    public void submitMetadataFiledToGetMetadata(PcUiBotExecuteContext executeContext, PcUiBotApiMetadata masterMetadata, List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (!CollectionUtils.isEmpty(submitAction.getCombineActions())) {
                submitMetadataFiledToGetMetadata(executeContext, masterMetadata, submitAction.getCombineActions());
            }

            if (CollectionUtils.isEmpty(submitAction.getActionParams())) {
                continue;
            }
            //对 GET_ACTION_RESPONSE  类型参数做处理 确定要添加的参数
            List<PcUiBotActionParameterMapping> appendActionParams = findAppendActionParam(submitAction.getActionParams(), masterMetadata.getResponseFields());
            appendActionParamBySubmitMetadata(appendActionParams, executeContext, submitAction, masterMetadata);
        }
    }


    /**
     * 查找参数是否要添加，确定添加字段
     *
     * @param actionParams
     * @param masterMetadataResponseFields
     */
    private List<PcUiBotActionParameterMapping> findAppendActionParam(List<PcUiBotActionParameterMapping> actionParams, List<PcUiBotMetadataField> masterMetadataResponseFields) {
        List<PcUiBotActionParameterMapping> appendActionParams = new ArrayList<>();
        for (PcUiBotActionParameterMapping actionParam : actionParams) {
            if (matchActionParamAndMasterMetadata("", masterMetadataResponseFields, actionParam)) {
                appendActionParams.add(actionParam);
            }
        }
        return appendActionParams;
    }

    /**
     * 提交参数和请求元数据 匹配 是否需要添加
     *
     * @param parentPathName
     * @param masterMetadataResponseFields
     * @param actionParam
     * @return
     */
    private boolean matchActionParamAndMasterMetadata(String parentPathName, List<PcUiBotMetadataField> masterMetadataResponseFields, PcUiBotActionParameterMapping actionParam) {
        boolean status = true;
        if (masterMetadataResponseFields != null) {
            for (PcUiBotMetadataField metadataField : masterMetadataResponseFields) {
                String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName(parentPathName, metadataField);
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                    status = matchActionParamAndMasterMetadata(pathFieldName, metadataField.getSubFields(), actionParam);
                }
                if ("GET_ACTION_RESPONSE".equals(actionParam.getType()) && pathFieldName.equals(actionParam.getValue())) {
                    return false;
                }
            }
        }
        return status;
    }


    /**
     * 添加提交参数到请求API中
     *
     * @param executeContext
     * @param submitAction
     * @param masterMetadata
     */
    private void appendActionParamBySubmitMetadata(List<PcUiBotActionParameterMapping> appendActionParams, PcUiBotExecuteContext executeContext, PcUiBotAction submitAction, PcUiBotApiMetadata masterMetadata) {
        if (CollectionUtils.isEmpty(appendActionParams)) {
            return;
        }
        //  获取提交api 在元数据结构
        PcUiBotApiMetadata submitMetadata = null;
        if ("ESP".equals(submitAction.getCategory())) {
            submitMetadata = this.getMetadata(executeContext, submitAction.getActionId());
        }
        if (submitMetadata == null) {
            return;
        }
        for (PcUiBotActionParameterMapping actionParam : appendActionParams) {
            if (!("GET_ACTION_RESPONSE").equals(actionParam.getType()) || !("ACTIVE_ROW").equals(actionParam.getType())) {
                continue;
            }
            PcUiBotMetadataField submitMetadataField = findActionParamFiledBySubmitMetadata("", submitMetadata.getRequestFields(), actionParam.getValue());
            if (submitMetadataField != null) {
                List<PcUiBotMetadataField> masterMetadataFields = appendSubmitMetadataFiledToGetMetadata("", masterMetadata.getResponseFields(), StringUtils.substringBeforeLast(actionParam.getValue(), "."));
                // masterMetadataFields中不已存在name、dataType都相同的MetadataField，在追加到masterMetadataFields中
                if (!CollectionUtils.isEmpty(masterMetadataFields) && respFieldsNotContains(submitMetadataField, masterMetadataFields)) {
                    submitMetadataField.setTagDefinitions(PcUiBotDefaultTagUtils.createDataTypeTagDefinitions(submitMetadataField));
                    masterMetadataFields.add(submitMetadataField);
                }
            }
        }
    }

    private PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        // 调用知识图谱的API，获取数据源对应行动（Action）的元数据
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(),
                                executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables("actionId", actionId)
                        .build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult =
                this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    private boolean respFieldsNotContains(PcUiBotMetadataField submitMetadataField, List<PcUiBotMetadataField> masterMetadataFields) {
        Optional<PcUiBotMetadataField> optional = masterMetadataFields.stream()
                .filter(
                        masterMetadataField ->
                                StringUtils.equals(submitMetadataField.getName(), masterMetadataField.getName())
                                        && StringUtils.equals(submitMetadataField.getDataType(), masterMetadataField.getDataType()))
                .findFirst();
        return !optional.isPresent();
    }

    private PcUiBotMetadataField findActionParamFiledBySubmitMetadata(String subFieldName, List<PcUiBotMetadataField> metadataFields, String filedName) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName(subFieldName, metadataField);
            if (pathFieldName.equals(filedName)) {
                return metadataField;
            }
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                PcUiBotMetadataField returnMetadataField = findActionParamFiledBySubmitMetadata(metadataField.getName(), metadataField.getSubFields(), filedName);
                if (returnMetadataField != null) {
                    return returnMetadataField;
                }
            }
        }
        return null;
    }

    private List<PcUiBotMetadataField> appendSubmitMetadataFiledToGetMetadata(String subFieldName, List<PcUiBotMetadataField> metadataFields, String filedName) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName(subFieldName, metadataField);
            if (pathFieldName.equals(filedName)) {
                return metadataField.getSubFields();
            }
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                List<PcUiBotMetadataField> returnMetadataField = appendSubmitMetadataFiledToGetMetadata(metadataField.getName(), metadataField.getSubFields(), filedName);
                if (!CollectionUtils.isEmpty(returnMetadataField)) {
                    return returnMetadataField;
                }
            }
        }
        return Collections.emptyList();
    }
}

