package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.bpm.service.DigiwinBpmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
public class BpmActionCreateService extends ActionCreateServiceBase {

    public PcUiBotSubmitAction createAgreeAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return createAction(taskData, backlogData, BpmServiceInvokeType.Agree);
    }

    public PcUiBotSubmitAction createRejectAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return createAction(taskData, backlogData, BpmServiceInvokeType.Reject);

    }

    public PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        return createAction(taskData, backlogData, BpmServiceInvokeType.TerminateProcess);

    }

    public PcUiBotSubmitAction createAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {
        BpmTaskParser bpmTaskParser = getBpmTaskParser(taskData);
        if (bpmTaskParser == null) {
            return new PcUiBotSubmitAction();
        }
        PcUiBotSubmitAction action = createSubmitAction(invokeType.getTitle(),
                AppContext.getApiUrlSetting().getBpmUrl() + DigiwinBpmProxyService.BPM_PREFIX + bpmTaskParser.getRelativeUrl(invokeType),
                invokeType.getName());
        action.setParas(bpmTaskParser.getParameter(taskData, backlogData, invokeType));
        return action;
    }

    private BpmTaskParser getBpmTaskParser(DigiwinAtmcTaskWithBacklogData taskData) {
        if (Objects.equals("UserTask", taskData.getBpmActivityType())) {
            return SpringContextHolder.getBean("bpmUserTaskParser");
        } else if (Objects.equals("WaitingTask", taskData.getBpmActivityType()) || Objects.equals("UIBOT__ERROR", taskData.getBpmActivityType())) {
            return SpringContextHolder.getBean("bpmWaitingTaskParser");
        }
        return null;
    }

    /**
     * 创建 查询 ACTION
     *
     * @param title
     * @return
     */
    private PcUiBotSubmitAction createSubmitAction(String title, String serviceUri, String name) {
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(title);
        action.setCategory("WF");
        action.setServiceId(this.createActionServiceId(serviceUri, name));
        return action;
    }

    /**
     * 创建服务信息节点
     *
     * @param serviceUri
     * @param name
     */
    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }


}


