package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;


import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;

public enum BpmServiceInvokeType {
    /**
     * 提交
     */
    Dispatch("dispatch", "提交"),
    /**
     * 同意
     */
    Agree("agree", "同意"),

    /**
     * 流程引擎-任务-拒绝
     */
    Reject("terminate", "拒绝"),

    /**
     * 任务引擎-签核任务-不同意、拒绝
     */
    Disagree("disagree", "不同意"),

    /**
     * 任务引擎-人工任务-转派
     */
    TaskEngineReAssign("manual-reassign", "转派"),

    /**
     * 转派
     */
    ReAssign("reassign", "转派"),

    /**
     * 退回重办
     */
    ReExecute("reexecute", "退回"),

    /**
     * 退回重签
     */
    ReApprove("reapprove", "重签"),

    /**
     * 项目、流程终止
     */
    TerminateProcess("terminate-process", "终止"),

    /**
     * 任务终止
     */
    TerminateTask("terminate-task", "终止任务"),

    /**
     * 加签关卡
     */
    AddTask("add-task", "加签"),

    /**
     * 任务引擎-发起新项目
     */
    StartNewProject("start-new-project", "发起新项目"),

    /**
     * 任务引擎-提交数据
     */
    SubmitData("submit-data", "提交数据"),

    /**
     * 任务-撤回
     */
    Retrieve("uibot_retrive", "撤回"),

    /**
     * 项目卡退回
     */
    TaskReturn("task-return", "退回"),

    /**
     * 任务-更新流程变量
     */
    UpdateData("update-data", "更新数据");

    /**
     * themeMap中配置的serviceName
     */
    private String name;
    private String title;

    /**
     * themeMap中配置的serviceName
     */
    public String getName() {
        return name;
    }

    public String getTitle() {
        return title;
    }

    BpmServiceInvokeType(String name, String title) {
        this.name = name;
        this.title = title;
    }

    public static BpmServiceInvokeType nameOf(String name) {
        switch (name) {
            case "dispatch":
                return Dispatch;

            case "manual-reassign":
                return TaskEngineReAssign;

            case "agree":
                return Agree;

            case "disagree":
                return Disagree;

            case "reassign":
                return ReAssign;

            case "reexecute":
                return ReExecute;

            case "reapprove":
                return ReApprove;

            case "add-task":
                return AddTask;

            case "submit-data":
                return SubmitData;

            case "terminate-process":
                return TerminateProcess;

            case "start-new-project":
                return StartNewProject;

            case "terminate-task":
                return TerminateTask;

            case "uibot_retrive":
                return Retrieve;

            case "task-return":
                return TaskReturn;

            case "update-data":
                return UpdateData;
        }

        String message = "Unsupported BPM actionServiceName:" + name;
        throw new ServiceException(message);
    }
}
