package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("bpmUserTaskParser")
public class BpmUserTaskParser implements BpmTaskParser {

    @Override
    public String getRelativeUrl(BpmServiceInvokeType invokeType) {
        if (invokeType.equals(BpmServiceInvokeType.Dispatch)) {
            return "/v1/process-engine/workitems/dispatch-workitem";
        } else if (invokeType.equals(BpmServiceInvokeType.Agree)) {
            return "/v1/process-engine/workitems/dispatch-workitem";
        } else if (invokeType.equals(BpmServiceInvokeType.Reject)) {
            return "/v1/process-engine/tasks/terminate-user-task";
        } else if (invokeType.equals(BpmServiceInvokeType.ReAssign)) {
            return "/v1/process-engine/workitems/reassign-workitem";
        } else if (invokeType.equals(BpmServiceInvokeType.ReExecute) || invokeType.equals(BpmServiceInvokeType.ReApprove)) {
            return "/v1/process-engine/tasks/reexecute-task";
        } else if (invokeType.equals(BpmServiceInvokeType.TerminateProcess)) {
            return "/v1/process-engine/process-instances/terminate-process";
        } else if (invokeType.equals(BpmServiceInvokeType.AddTask)) {
            return "/v1/process-engine/tasks/add-task";
        }
        return null;
    }

    @Override
    public Map<String, Object> getParameter(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {

        //理论上 getWorkitemList 中应该只有一个元素
        String performerId = backlogData.getWorkitemList().get(0).get("performerId").toString();
        String performerName = backlogData.getWorkitemList().get(0).get("performerName").toString();
        String workitemId = backlogData.getWorkitemList().get(0).get("workitemId").toString();

        Map<String, Object> map = new HashMap<>();
        map.put("processSerialNumber", taskData.getProcessSerialNumber());
        map.put("taskId", taskData.getBpmActivityId());
        map.put("performerId", performerId);
        map.put("comment", "");
        map.put("locale", AppRequestContext.getContextEntity().getLocale());
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            //如果待办人员和当前人员不是同一个人，则指定为代理人
            map.put("performerType", 1);
            map.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        if (invokeType.equals(BpmServiceInvokeType.Agree)) {
            map.remove("taskId");
            map.put("workitemId", workitemId);
        } else if (invokeType.equals(BpmServiceInvokeType.ReAssign)) {
            map.put("newPerformerId", "");
            map.put("workitemId", workitemId);

        } else if (invokeType.equals(BpmServiceInvokeType.ReExecute) || invokeType.equals(BpmServiceInvokeType.ReApprove)) {
            map.remove("performerId");
            map.put("taskId", "");
            //退回执行解析方式
            map.put("reexecuteType", "FOLLOW_THE_DEFINITION");
            //当前关卡处理者
            map.put("reexecuteUserId", performerId);
            map.put("workitemId", workitemId);
        } else if (invokeType.equals(BpmServiceInvokeType.TerminateProcess)) {
//            map.remove("agentPerformerId");
            map.put("workitemId", workitemId);
            map.put("comment", "分批提交最后一批数据终止流程");
        } else if (invokeType.equals(BpmServiceInvokeType.AddTask)) {
            //加签
            map.remove("taskId");
            map.put("workitemId", workitemId);
            //Forward->向前加签；BackwardDispatch->向后加签,默认向后加签
            map.put("addType", "BackwardDispatch");

            Map<String, Object> taskMap = new HashMap<>();
            taskMap.put("taskName", performerName + " " + "加签");
            taskMap.put("performMode", "FIREST_GET_FIRST_WIN");     //固定值
            taskMap.put("performType", "NORMAL");   //固定值
            //前端选择后填入，加签关卡的处理人
            taskMap.put("performers", "");

            List<Object> taskList = new ArrayList<>();
            taskList.add(taskMap);
            map.put("taskList", taskList);
        }
        return map;
    }

//    private String getBacklogPerformerId(TaskData taskData){
//        String backlogPerformerId = null;
//        if(!org.springframework.util.CollectionUtils.isEmpty(taskData.getPerformerIds())){
//            backlogPerformerId = taskData.getPerformerIds().get(0);
//        }
//        return backlogPerformerId;
//    }
}
