package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("bpmWaitingTaskParser")
public class BpmWaitingTaskParser implements BpmTaskParser {

    @Override
    public String getRelativeUrl(BpmServiceInvokeType invokeType) {
        if (invokeType.equals(BpmServiceInvokeType.Dispatch)) {
            return "/v1/process-engine/tasks/dispatch-waiting-task";
        } else if (invokeType.equals(BpmServiceInvokeType.Agree)) {
            return "/v1/process-engine/tasks/dispatch-waiting-task";
        } else if (invokeType.equals(BpmServiceInvokeType.ReExecute) || invokeType.equals(BpmServiceInvokeType.ReApprove)) {
            return "/v1/process-engine/tasks/reexecute-task";
        } else if (invokeType.equals(BpmServiceInvokeType.TerminateProcess)) {
            return "/v1/process-engine/process-instances/terminate-process";
        } else if (invokeType.equals(BpmServiceInvokeType.AddTask)) {
            return "/v1/process-engine/tasks/add-task";
        } else {
            return "/v1/process-engine/tasks/terminate-waiting-task";
        }
    }

    @Override
    public Map<String, Object> getParameter(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {

        //理论上 getWorkitemList 中应该只有一个元素
        String performerId = backlogData.getWorkitemList().get(0).get("performerId").toString();
        String workitemId = backlogData.getWorkitemList().get(0).get("workitemId").toString();

        if (invokeType.equals(BpmServiceInvokeType.TerminateProcess)) {
            Map<String, Object> map = new HashMap<>();
            map.put("processSerialNumber", taskData.getProcessSerialNumber());
            map.put("performerId", performerId);
            map.put("workitemId", workitemId);
            map.put("comment", "分批提交最后一批数据终止流程");
            map.put("locale", AppRequestContext.getContextEntity().getLocale());
            return map;
        } else if (invokeType.equals(BpmServiceInvokeType.AddTask)) {
            //加签
            Map<String, Object> map = new HashMap<>();
            map.put("processSerialNumber", taskData.getProcessSerialNumber());
            map.put("workitemId", workitemId);
            map.put("performerId", performerId);
            if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
                //如果待办人员和当前人员不是同一个人，则指定为代理人
                map.put("performerType", 1);
                map.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
            }
            //Forward->向前加签；BackwardDispatch->向后加签,默认向后加签
            map.put("addType", "BackwardDispatch");
            map.put("comment", "加签");
            map.put("locale", AppRequestContext.getContextEntity().getLocale());

            Map<String, Object> taskMap = new HashMap<>();
            taskMap.put("taskName", backlogData.getPerformerName() + " " + "加签");
            taskMap.put("performMode", "FIREST_GET_FIRST_WIN");     //固定值
            taskMap.put("performType", "NORMAL");   //固定值
            //前端选择后填入，加签关卡的处理人
            taskMap.put("performers", "");

            List<Object> taskList = new ArrayList<>();
            taskList.add(taskMap);
            map.put("taskList", taskList);
            return map;
        } else {
            Map<String, Object> map = new HashMap<>();
            map.put("processSerialNumber", taskData.getProcessSerialNumber());
            map.put("taskId", taskData.getBpmActivityId());
            map.put("comment", "");
            map.put("performerId", performerId);
            map.put("locale", AppRequestContext.getContextEntity().getLocale());
            return map;
        }
    }

}
