package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * <p>功能描述：通过ActivityConfigs或pageView配置获取客制tag相关</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomizeTagSetByActivityConfigsService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 13:51
 */
@Service
public class CustomizeTagSetByActivityConfigsService<T extends PcUiBotPageDefine> {

//    @Autowired
//    protected TagService tagService;

    /**
     * xuxx 解析CustomizeTags
     */
    public PcUiBotTaggingData getCustomizeTags(String actionId, T pageDefine, PcUiBotTaggingData taggingData) {

        PcUiBotTaggingData taggingDataCustomize = new PcUiBotTaggingData();
        List<PcUiBotDataTag> dataTags = pageDefine.getDataTags();
        if (CollectionUtils.isEmpty(dataTags)) {
            return null;
        }
        taggingDataCustomize.setMetadataId(actionId);
        List<PcUiBotMetadataTagResult> metadataTagResult = new ArrayList<>();
        for (PcUiBotDataTag dataTag : dataTags) {
            PcUiBotMetadataTagResult tagResult = new PcUiBotMetadataTagResult();
            PcUiBotThemeMapTagResponse resourceContent = new PcUiBotThemeMapTagResponse();
            resourceContent.setResponse(dataTag.getField());
            if (CollectionUtils.isNotEmpty(dataTag.getTags())) {
                tagResult.setTags(dataTag.getTags());
                //组装客制的tag定义，不从Mongo中获取；
                List<PcUiBotTagDefinition> tagDefinitions = new ArrayList<>();

                for (PcUiBotThemeMapTag themeMapTag : dataTag.getTags()) {
                    PcUiBotTagDefinition tagDefNoMong = new PcUiBotTagDefinition();
                    tagDefNoMong.setCategory("DISPLAY");
                    tagDefNoMong.setCode(themeMapTag.getCode());
                    tagDefNoMong.setName(themeMapTag.getName());
                    tagDefNoMong.setInterpreterServiceName("customizeComponentInterpreter");
                    tagDefNoMong.setCustomize(false);
                    Map<String, Object> extendInfo = new HashMap<>();
                    Map<String, Object> extendInfo_sub = new HashMap<>();
                    extendInfo_sub.put("type", themeMapTag.getCode());
                    if (themeMapTag.getCustomTitle() != null && themeMapTag.getCustomTitle()) {
                        extendInfo_sub.put("description", themeMapTag.getTitle());
                    }
                    if (CollectionUtils.isNotEmpty(themeMapTag.getExtendParas())) {
                        extendInfo_sub.put("extendParas", themeMapTag.getExtendParas());
                    }
                    if (dataTag.getComponent() != null) {
                        Map<String, Object> component = dataTag.getComponent();
                        if (component.containsKey("width")) {
                            int width = Integer.parseInt(component.get("width").toString());
                            if (width > 0) {
                                extendInfo_sub.put("width", width);
                            }
                        }
                        if (component.containsKey("rowCount")) {
                            int rowCount = Integer.parseInt(component.get("rowCount").toString());
                            if (rowCount > 0) {
                                extendInfo_sub.put("rowCount", rowCount);
                            }
                        }
                    }
                    extendInfo.put("component", extendInfo_sub);
                    tagDefNoMong.setExtendedInfo(extendInfo);
                    tagDefNoMong.setThemeMapTag(themeMapTag);

                    tagDefinitions.add(tagDefNoMong);
                }
                tagResult.setTagDefinitions(tagDefinitions);
            } else if (StringUtils.isNotBlank(dataTag.getTag())) {
                List<PcUiBotThemeMapTag> tags = new ArrayList<>();
                PcUiBotThemeMapTag themeMapTag = new PcUiBotThemeMapTag();
                themeMapTag.setCode(dataTag.getTag());
                themeMapTag.setUiBotCode(dataTag.getTag());
                themeMapTag.setCategory("DISPLAY");
                //组装客制的tag定义，不从Mongo中获取；
                List<PcUiBotTagDefinition> tagDefinitions = new ArrayList<>();
                PcUiBotTagDefinition tagDefNoMong = new PcUiBotTagDefinition();
                tagDefNoMong.setCategory("DISPLAY");
                tagDefNoMong.setCode(themeMapTag.getCode());
                tagDefNoMong.setName(themeMapTag.getName());
                tagDefNoMong.setInterpreterServiceName("customizeComponentInterpreter");
                tagDefNoMong.setCustomize(false);

                Map<String, Object> extendInfo = new HashMap<>();
                Map<String, Object> extendInfo_sub = new HashMap<>();
                extendInfo_sub.put("type", themeMapTag.getCode());
                if (themeMapTag.getCustomTitle() != null && themeMapTag.getCustomTitle()) {
                    extendInfo_sub.put("description", themeMapTag.getTitle());
                }
                if (dataTag.getComponent() != null) {
                    Map<String, Object> component = dataTag.getComponent();
                    if (component.containsKey("width")) {
                        int width = Integer.parseInt(component.get("width").toString());
                        if (width > 0) {
                            extendInfo_sub.put("width", width);
                        }
                    }
                }
                extendInfo.put("component", extendInfo_sub);
                tagDefNoMong.setExtendedInfo(extendInfo);
                tagDefNoMong.setThemeMapTag(themeMapTag);

                tagDefinitions.add(tagDefNoMong);
                tags.add(themeMapTag);
                tagResult.setTagDefinitions(tagDefinitions);
                tagResult.setTags(tags);
            }
            tagResult.setResourceContent(resourceContent);
            metadataTagResult.add(tagResult);
        }
        orderTagHandle(metadataTagResult);
        taggingDataCustomize.setMetadataTagResult(metadataTagResult);


        if (taggingData != null) {
            if (taggingDataCustomize != null && CollectionUtils.isNotEmpty(taggingDataCustomize.getMetadataTagResult())) {
                taggingData.getMetadataTagResult().addAll(taggingDataCustomize.getMetadataTagResult());
            }
            return taggingData;
        } else {
            return taggingDataCustomize;
        }

    }


    /**
     * 运行时--产生
     * 顺序类
     * 1.修改ORDER值
     * 2.移除重复ORDER-TAG标签
     *
     * @param metadataTagResults
     */
    private void orderTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            boolean orderRemoveFlag = false;
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
                //if (themeMapTag.getCode().startsWith(TagConstant.ORDER_PREFIX)) {
                if (PcUiBotTagConstant.CATEGORY_ORDER.equals(themeMapTag.getCategory())) {
                    if (!orderRemoveFlag) {
                        orderRemoveFlag = true;
                        themeMapTag.setValue(StringUtils.substringAfterLast(themeMapTag.getCode(), PcUiBotTagConstant.ORDER_PREFIX));
                        if (themeMapTag.getValue() == null) {
                            themeMapTag.setValue("0");
                        }
                        themeMapTag.setCategory(PcUiBotTagConstant.ORDER_TAG);
                        themeMapTag.setUiBotCode(PcUiBotTagConstant.ORDER_TAG);
                    } else {
                        themeMapTags.remove();
                    }
                }
            }
        }
    }

    /**
     * 通过pattern和词库中没有获取到的客制tag定义
     *
     * @param pageDefine
     * @param needShowFields
     * @param rootField
     */
    public void getCustomizeTagFieldNotExist(T pageDefine, Map<String, PcUiBotMetadataField> needShowFields, PcUiBotMetadataField rootField) {
        List<PcUiBotDataTag> dataTags = pageDefine.getDataTags();
        if (CollectionUtils.isNotEmpty(dataTags)) {
            Map<String, PcUiBotMetadataField> fieldMap = rootField.getFieldMap();
            for (PcUiBotDataTag dataTag : dataTags) {
                if (dataTag.getField() != null && !dataTag.getField().contains(".")) {
                    String fieldName = dataTag.getField();
                    if (!needShowFields.containsKey(fieldName)) {
                        needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
                    }
                } else {
                    String fieldNameLists[] = dataTag.getField().split("\\.");
                    String fieldName = fieldNameLists[fieldNameLists.length - 1];
                    if (!needShowFields.containsKey(fieldName)) {
                        needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
                    }
                }
            }
        }
    }
}
