package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;


import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 模型驱动按钮的构造
 *
 * @author yanfenga
 */
@Service
public class DataEntryDrivenActionCreateService extends ActionCreateServiceBase {

    /**
     * 创造工作流的按钮
     *
     * @param executeContext
     * @param projectData
     * @param taskWithBacklogData
     * @param tmAction
     * @param tmActivity
     * @return
     */
    public PcUiBotSubmitAction createSubmitAction(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData,
                                                  DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        PcUiBotSubmitAction action;
        // 类型为工作流的按钮
        if (Objects.equals(PcUiBotConstants.ACTION_CATEGORY_WORKFLOW, tmAction.getType())) {
            action = createWorkflowSubmitAction(executeContext, tmAction, tmActivity, taskWithBacklogData);
        } else {
            // 走通用的构造按钮的方法
            action = this.initSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setCategory(tmAction.getType());
        }
        List<PcUiBotSubmitAction> attachResultActions;
        List<PcUiBotTmAction> attachActions = tmAction.getAttachActions();
        if (CollectionUtils.isNotEmpty(attachActions)) {
            attachResultActions = Lists.newArrayListWithExpectedSize(attachActions.size());
            for (PcUiBotTmAction attachAction : attachActions) {
                PcUiBotSubmitAction submitAction = createSubmitAction(executeContext, projectData, taskWithBacklogData, attachAction, tmActivity);
                // 设空是为了统一上下文返回，每个上下文返回的非常的多，报文会很大
                submitAction.setExecuteContext(null);
                attachResultActions.add(submitAction);
            }
        } else {
            attachResultActions = Lists.newArrayListWithExpectedSize(1);
        }
        if (tmAction.isDispatch()) {
            PcUiBotTmAction dispatch = new PcUiBotTmAction();
            dispatch.setActionId("athena.workflow.process.activity.work.dispatch");
            dispatch.setServiceName("workflow-act-dispatch");
            dispatch.setType("workflow");
            dispatch.setTitle("同意");
            attachResultActions.add(createWorkflowSubmitAction(executeContext, dispatch, tmActivity, taskWithBacklogData));
        }
        // 设置附近
        action.setAttachActions(attachResultActions);
        // 设置禁用、隐藏等条件
        PcUiBotSubmitActionUtil.setCondition(tmAction, action);
        action.setSubmitType(tmAction.getSubmitType());
        action.setTrackCode(tmAction.getTrackCode());
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, taskWithBacklogData));
        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }

    /**
     * 创造工作流的按钮
     *
     * @param executeContext
     * @param tmAction
     * @param tmActivity
     * @param taskWithBacklogData
     * @return
     */
    public PcUiBotSubmitAction createWorkflowSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity, DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        DigiwinAtmcBacklogData backlogData = taskWithBacklogData.getBacklog().get(0);
        PcUiBotSubmitAction workflowSubmitAction = createWorkflowSubmitAction(backlogData);
        workflowSubmitAction.setTitle(tmAction.getTitle());
        String serviceName = tmAction.getServiceName();
        Map<String, Object> paras = workflowSubmitAction.getParas();
        // 根据不同的类型创造参数
        switch (serviceName) {
            // 提交 人工任务出现
            case "workflow-act-submit":
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/submit", serviceName));
                break;
            // 同意 签核任务出现
            case "workflow-act-agree":
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/agree", serviceName));
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            // 不同意 签核任务出现
            case "workflow-act-disagree":
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/disagree", serviceName));
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            // 加签 签核关卡出现
            case "workflow-act-add":
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/add", serviceName));
                //region 签核关卡-加签
                //  addType	加签类型	Forward->向前加签；BackwardDispatch->向后加签
                //      默认向后加签
                //加签关卡集合，目前只支持一个
                List<Map<String, Object>> activities = new ArrayList<>();
                Map<String, Object> activity = new HashMap<>();
                activity.put("activityName", backlogData.getPerformerName() + " " + "加签");
                activity.put("signType", "single");
                activity.put("performerIds", "");
                activity.put("addType", "BackwardDispatch");
                activities.add(activity);
                paras.put("activities", activities);
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            // 退回 签核任务出现
            case "workflow-act-return":
                // region 签核关卡-退回重签
                paras.put("activityId", "");
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/task/activity/return", serviceName));
                break;
            // 转派 签核任务出现
            case "workflow-act-reassignment":
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/transfer", serviceName));
                paras.put("newPerformerId", "");
                break;
            // 转发
            case "workflow-act-dispatch":
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/dispatch", serviceName));
                if (workflowSubmitAction.getExtendParas() == null) {
                    workflowSubmitAction.setExtendParas(new HashMap<>());
                }
                if (!workflowSubmitAction.getExtendParas().containsKey("dataSource")) {
                    //如果没有设置提交的数据源，则设置父节点转换后的结果
                    workflowSubmitAction.getExtendParas().put("dataSource", "parent");
                }
                break;
            default:
                String message = "exception.unsupported.action" + tmAction.getActionId() + tmAction.getType();
                throw new ServiceException(message);
        }
        // 以前任务的处理逻辑
        if (StringUtils.isEmpty(tmAction.getId())) {
            workflowSubmitAction.setId(tmAction.getActionId());
        } else {
            workflowSubmitAction.setId(tmAction.getId());
        }
        workflowSubmitAction.setActionId(tmAction.getActionId());
        workflowSubmitAction.setDefaultAction(tmAction.isDefaultAction());
        workflowSubmitAction.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmAction.getTitle()));
        workflowSubmitAction.setActionParams(tmAction.getActionParams());
        workflowSubmitAction.executeExtendParas(tmAction.getExtendParas(), executeContext);
        processActionParas(workflowSubmitAction, executeContext);
        return workflowSubmitAction;
    }

    /**
     * 创建服务信息节点
     *
     * @param serviceUri
     * @param name
     */
    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }

    private PcUiBotSubmitAction createWorkflowSubmitAction(DigiwinAtmcBacklogData backlogData) {
        // 非空判断
        //理论上 getWorkitemList 中应该只有一个元素
        Map<String, Object> map = backlogData.getWorkitemList().get(0);
        String performerId = MapUtils.getString(map, "performerId");
        String workitemId = MapUtils.getString(map, "workitemId");
        Integer performerType = MapUtils.getInteger(map, "performerType");
//        if (Objects.equals(backlogData.getWorkitemList().get(0).get("state"), 3)) {
//            //如果已经执行完成的，改为0。因为这里生成的是未完成的任务的action，对于已经执行完的任务，不能使用其原来的值
//            performerType = 0;
//        }
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setCategory(PcUiBotConstants.ACTION_CATEGORY_WORKFLOW);
        action.setTrackCode(PcUiBotConstants.DEFAULT_BUTTON_TRACK_CODE);
        //设置通用参数
        Map<String, Object> paras = new HashMap<>();
        if (StringUtils.isBlank(workitemId)) {
            throw new ServiceException("exception.workitem.empty" + ": " + backlogData.getBacklogId());
        }
        String userId = AppRequestContext.getContextEntity().getUserId();
        paras.put("workitemId", workitemId);
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, userId)) {
            //如果待办人员和当前人员不是同一个人，则指定为代理人
            paras.put("performerType", 1);
            paras.put("agentPerformerId", userId);
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);
        return action;
    }
}