package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.DataEntryDrivenSubmitActionParser;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：模型驱动按钮的构造</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataEntryDrivenSubmitService.java
 * @Author: wangjwc
 * @Date: created at 2024/1/10 14:40
 */
@Service
public class DataEntryDrivenSubmitService {
    /**
     * 对按钮进行重新构造
     *
     * @param executeContext 上下问
     * @param tmActivity     活动定义
     * @param tmDataState    数据源
     * @param pageDefine     页面定义
     */
    public void createTaskSubmit(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        DataEntryDrivenSubmitActionParser parser = SpringContextHolder.getBean(DataEntryDrivenSubmitActionParser.class);
        parser.init(executeContext, tmActivity, tmDataState, pageDefine);
        List<PcUiBotTmAction> tmActions = tmDataState.getSubmitActions();
        List<PcUiBotSubmitAction> submitActions = parser.parse(tmDataState.getSubmitActions());
        //判断是否存在默认DefaultAction
        boolean checkDefaultAction = Optional.ofNullable(tmActions)
                .orElse(Lists.newArrayList())
                .stream().anyMatch(PcUiBotTmAction::isDefaultAction);
        if (!checkDefaultAction && CollectionUtils.isNotEmpty(submitActions)) {
            submitActions.get(0).setDefaultAction(true);
        }
        pageDefine.setSubmitType(tmDataState.getSubmitType());
        pageDefine.setMultipleSelectMerge(tmDataState.getMultipleSelectMerge());
        pageDefine.setSubmitActions(submitActions);
    }
}