package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;


import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：dataSource 业务逻辑处理层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataSourceAnalysisServiceBase.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 17:26
 */
@Service
public class DataSourceAnalysisServiceBase {
    @Autowired
    protected QueryActionCreateService queryActionService;

    protected PcUiBotDataSourceDTO createDataSourceWithoutTask(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmQueryAction) {
        if (StringUtils.isNotBlank(tmQueryAction.getName())) {
            dataSourceName = tmQueryAction.getName();
        }

        PcUiBotQueryAction queryAction = queryActionService.createDataSourceWithoutTask(executeContext, tmQueryAction);

        PcUiBotDataSourceDTO dataSourceDTO = null;
        if (null != queryAction) {
            List processors = getDataProcess(tmQueryAction, null, dataSourceName, null, null);
            dataSourceDTO = DataSourceDTOFactory.create(tmQueryAction, queryAction, dataSourceName, processors, true);
        }
        if (dataSourceDTO != null) {

            //查询前多少
            if (tmQueryAction.getLimit() != null) {
                dataSourceDTO.setLimit(tmQueryAction.getLimit());
            }
            dataSourceDTO.setNotArray(tmQueryAction.getNotArray());
            if (tmQueryAction.getMetadataFields() != null) {
                dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
            }
            return dataSourceDTO;
        }
        return null;
    }

    protected PcUiBotDataSourceDTO createBatchQueryWithoutBacklog(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, PcUiBotTmDataFilter tmDataFilter) {
        if (org.springframework.util.StringUtils.isEmpty(dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        //先把数据源关联的数据处理器拿到
        List<PcUiBotQueryAction> actionList = new ArrayList<>();
        //为每个活动创建查询
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            PcUiBotQueryAction queryAction = queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, task, executeContext.getProjectData(), tmDataFilter, dataSourceName, executeContext);
            actionList.add(queryAction);
        }
        if (!CollectionUtils.isEmpty(actionList)) {
            mergeQueryByBusinessUnit(actionList);
            List processors = getDataProcess(tmAction, tmDataFilter, dataSourceName, null, null);

            return DataSourceDTOFactory.createDataSource(actionList, processors, dataSourceName, tmAction);
        }
        return null;
    }

    protected PcUiBotDataSourceDTO createBatchQueryBacklog(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList, DigiwinAtmcProjectData projectData, PcUiBotTmDataFilter tmDataFilter, boolean isProject) {
        if (!StringUtils.isEmpty(tmAction.getName())) {
            dataSourceName = tmAction.getName();
        }

        //先把数据源关联的数据处理器拿到
        List<PcUiBotQueryAction> actionList = new ArrayList<>();

        for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : taskWithBacklogDataList) {
            switch (tmAction.getType()) {
                case PcUiBotConstants.ACTION_CATEGORY_ATMC:
                case PcUiBotConstants.ACTION_CATEGORY_ATMC_CHANGE:
                case PcUiBotConstants.ACTION_CATEGORY_ESP:
                case PcUiBotConstants.ACTION_CATEGORY_TM:
                case PcUiBotConstants.ACTION_CATEGORY_RAW_DATA:
                case PcUiBotConstants.ACTION_CATEGORY_SD:
                case PcUiBotConstants.ACTION_CATEGORY_LCDP: {
                    PcUiBotQueryAction queryAction = queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, taskWithBacklogData, projectData, tmDataFilter, dataSourceName, executeContext);
                    if (queryAction != null) {
                        actionList.add(queryAction);
                    }
                    break;
                }
                default:
                    throw new ServiceException(String.format("对于%s类型的数据源不支持批量合并查询", tmAction.getType()));
            }
        }
        if (actionList.size() > 1) {
            if (isProject) {
                mergeQueryByBusinessUnit(actionList);
            } else {
                PcUiBotQueryAction queryAction = mergeQuery(actionList);
                actionList.clear();
                actionList.add(queryAction);
            }
        }
        List<PcUiBotTmDataProcess> processors = getDataProcess(tmAction, tmDataFilter, dataSourceName, null, projectData);

        for (PcUiBotTmDataProcess processor : processors) {
            if ("atmcBatchDataService".equals(processor.getServiceName())) {
                processor.setTaskWithBacklogDataList(taskWithBacklogDataList);
                processor.setProjectData(projectData);
                break;
            }
        }

        PcUiBotDataSourceDTO dataSourceDTO = DataSourceDTOFactory.createDataSource(actionList, processors, dataSourceName, tmAction);
        if (dataSourceDTO != null) {
            if (tmDataFilter != null) {
                dataSourceDTO.setLimit(tmDataFilter.getLimit());
            }
            //查询前多少
            if (tmAction.getLimit() != null) {
                dataSourceDTO.setLimit(tmAction.getLimit());
            }
            dataSourceDTO.setNotArray(tmAction.getNotArray());
            if (tmAction.getMetadataFields() != null) {
                dataSourceDTO.setMetadataFields(tmAction.getMetadataFields());
            }
        }

        return dataSourceDTO;
    }


    private void mergeQueryByBusinessUnit(List<PcUiBotQueryAction> actions) {
        actions.forEach(act -> {
            if (act.getBusinessUnit() == null) {
                act.setBusinessUnit(new HashMap<>());
            }
        });
        List<PcUiBotQueryAction> list = new ArrayList<>();
        Map<Object, List<PcUiBotQueryAction>> group = actions.stream()
                .collect(Collectors.groupingBy(act -> act.getBusinessUnit()));
        for (Map.Entry<Object, List<PcUiBotQueryAction>> groupItem : group.entrySet()) {
            list.add(mergeQuery(groupItem.getValue()));
        }
        actions.clear();
        actions.addAll(list);
    }

    /**
     * 合并所有的查询条件到第一个查询
     *
     * @param actions
     */
    private PcUiBotQueryAction mergeQuery(List<PcUiBotQueryAction> actions) {
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() == 1) {
            return actions.get(0);
        }
        // 如果是非人工关卡，做数据查询条件合并去重，只产生一个查询；
        PcUiBotQueryAction firstAction = actions.remove(0);
        Map<String, Object> firstActionParams = firstAction.getParas();
        for (PcUiBotQueryAction action : actions) {
            if (action.getParas() == null) {
                continue;
            }
            // 查询条件合并，key：schema，value：查询条件
            for (Map.Entry<String, Object> requestParamsEntry : action.getParas().entrySet()) {
                String schema = requestParamsEntry.getKey();
                // 可能是字符串或是json数组
                Object fields = requestParamsEntry.getValue();
                if (!firstActionParams.containsKey(schema)) {
                    firstActionParams.put(schema, fields);
                } else {
                    Object oriFieldsObj = firstActionParams.get(schema);
                    if (!(oriFieldsObj instanceof List)) {
                        continue;
                    }
                    List oriFields = (List) oriFieldsObj;
                    //创建新的临时比较对象
                    Set<Object> compareSet = new HashSet<>();
                    if (fields instanceof List) {
                        List jsonArray = (List) fields;
                        compareSet.addAll(oriFields);
                        //oriFileds存入临时比较对象中
                        for (Object item : jsonArray) {
                            if (!compareSet.contains(item)) {
                                oriFields.add(item);
                                compareSet.add(item);
                            }
                        }
                    }
                }
            }
        }
        return firstAction;
    }

    protected PcUiBotDataSourceDTO create(PcUiBotExecuteContext executeContext, String dataSourceName, PcUiBotTmQueryAction tmAction, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, DigiwinAtmcProjectData projectData, PcUiBotTmDataFilter tmDataFilter) {
        if (!StringUtils.isEmpty(tmAction.getName())) {
            dataSourceName = tmAction.getName();
        }
        PcUiBotDataSourceDTO dataSourceDTO = null;
        switch (tmAction.getType()) {
            case PcUiBotConstants.ACTION_CATEGORY_ATMC:
            case PcUiBotConstants.ACTION_CATEGORY_ATMC_CHANGE:
            case PcUiBotConstants.ACTION_CATEGORY_ESP:
            case PcUiBotConstants.ACTION_CATEGORY_TM:
            case PcUiBotConstants.ACTION_CATEGORY_RAW_DATA:
            case PcUiBotConstants.ACTION_CATEGORY_SD:
            case PcUiBotConstants.ACTION_CATEGORY_LCDP: {
                PcUiBotQueryAction queryAction = queryActionService.createQueryAction(executeContext.getDataStateCode(), tmAction, taskWithBacklogData, projectData, tmDataFilter, dataSourceName, executeContext);
                if (queryAction == null) {
                    return null;
                }
                List<PcUiBotTmDataProcess> processors = getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);

                dataSourceDTO = DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, processors, true);
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_MIX_MERGE: {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                PcUiBotDataSourceDTO left = create(executeContext, "", tmAction.getLeft(), taskWithBacklogData, projectData, tmDataFilter);
                List<PcUiBotDataSourceDTO> rightList = new ArrayList<>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    PcUiBotDataSourceDTO dataSourceBase = create(executeContext, "" + index, tmQueryAction, taskWithBacklogData, projectData, tmDataFilter);
                    rightList.add(dataSourceBase);
                    index++;
                }
                dataSourceDTO = new PcUiBotDataSourceDTO();
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_MERGE);
                dataSourceDTO.setLeft(left);
                dataSourceDTO.setRightList(rightList);
                dataSourceDTO.setName(dataSourceName);
                dataSourceDTO.setActionId(tmAction.getLeft().getActionId());
                dataSourceDTO.setDataKeys(tmAction.getLeft().getDataKeys());
                dataSourceDTO.setAction(left.getAction());

                List<PcUiBotTmDataProcess> processors = getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);

                dataSourceDTO.setDataSourceProcessors(processors);

            }
            break;
            case PcUiBotConstants.ACTION_CATEGORY_MIX_LEFT_JOIN: {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                PcUiBotDataSourceDTO left = create(executeContext, "", tmAction.getLeft(), taskWithBacklogData, projectData, tmDataFilter);
                List<PcUiBotDataSourceDTO> rightList = new ArrayList<>();
                int index = 0;
                for (PcUiBotTmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    PcUiBotDataSourceDTO dataSourceBase = create(executeContext, "" + index, tmQueryAction, taskWithBacklogData, projectData, tmDataFilter);
                    rightList.add(dataSourceBase);
                    index++;
                }
                dataSourceDTO = new PcUiBotDataSourceDTO();
                dataSourceDTO.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_LEFT_JOIN);
                dataSourceDTO.setLeft(left);
                dataSourceDTO.setRightList(rightList);
                dataSourceDTO.setName(dataSourceName);
                dataSourceDTO.setActionId(tmAction.getLeft().getActionId());
                dataSourceDTO.setDataKeys(tmAction.getLeft().getDataKeys());
                dataSourceDTO.setAction(left.getAction());
                dataSourceDTO.setOverride(tmAction.getOverride());
                List<PcUiBotTmDataProcess> processors = getDataProcess(tmAction, tmDataFilter, dataSourceName, taskWithBacklogData, projectData);

                dataSourceDTO.setDataSourceProcessors(processors);
            }
            break;
        }
        if (dataSourceDTO != null) {
            if (tmDataFilter != null) {
                dataSourceDTO.setLimit(tmDataFilter.getLimit());
            }
            //查询前多少
            if (tmAction.getLimit() != null) {
                dataSourceDTO.setLimit(tmAction.getLimit());
            }
            dataSourceDTO.setNotArray(tmAction.getNotArray());
            if (tmAction.getMetadataFields() != null) {
                dataSourceDTO.setMetadataFields(tmAction.getMetadataFields());
            }
            dataSourceDTO.setTitle(tmAction.getTitle());
        }
        addExtendedData(taskWithBacklogData, dataSourceDTO);
        return dataSourceDTO;
    }

    public void addExtendedData(DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotDataSourceDTO dataSourceDTO) {
        if (dataSourceDTO.getExtendedData() == null) {
            dataSourceDTO.setExtendedData(new HashMap<>());
        }
        if (taskWithBacklogData != null && !CollectionUtils.isEmpty(taskWithBacklogData.getBacklog())) {
            dataSourceDTO.getExtendedData().put("__workitemSqlId", taskWithBacklogData.getBacklog().get(0).getBacklogId());
            dataSourceDTO.getExtendedData().put("__processSerialNumber", taskWithBacklogData.getProcessSerialNumber());
            if (!CollectionUtils.isEmpty(taskWithBacklogData.getBacklog().get(0).getWorkitemList())) {
                dataSourceDTO.getExtendedData().put("__workitemId", taskWithBacklogData.getBacklog().get(0).getWorkitemList().get(0).get("workitemId"));
            }
        }
    }

    protected List<PcUiBotTmDataProcess> getDataProcess(PcUiBotTmQueryAction tmAction, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, DigiwinAtmcProjectData projectData) {
        List<PcUiBotTmDataProcess> processors = new ArrayList<>();
        if (!CollectionUtils.isEmpty(tmAction.getDataProcessors())) {
            if (tmDataFilter != null && StringUtils.isNotEmpty(tmDataFilter.getCode())) {
                //先处理指定dataFilter的
                for (PcUiBotTmDataProcess dataSourceProcessor : tmAction.getDataProcessors()) {
                    if (!CollectionUtils.isEmpty(dataSourceProcessor.getDataFilterNames())
                            && dataSourceProcessor.getDataFilterNames().contains(tmDataFilter.getCode())) {
                        if (!PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataSourceProcessor.getActivePoint())) {
                            processors.add(dataSourceProcessor.clone());
                        }
                    }
                }
            }
            for (PcUiBotTmDataProcess dataSourceProcessor : tmAction.getDataProcessors()) {
                if (CollectionUtils.isEmpty(dataSourceProcessor.getDataFilterNames())
                        && (CollectionUtils.isEmpty(dataSourceProcessor.getDataSourceNames())
                        || dataSourceProcessor.getDataSourceNames().contains(dataSourceName))) {
                    if (!PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataSourceProcessor.getActivePoint())) {
                        processors.add(dataSourceProcessor.clone());
                    }
                }
            }
        }
        for (PcUiBotTmDataProcess processor : processors) {
            if ("atmcDataService".equals(processor.getServiceName()) ||
                    "recommendProcessService".equals(processor.getServiceName())
            ) {
                processor.setTaskWithBacklogData(taskWithBacklogData);
                processor.setProjectData(projectData);
            }
            if (StringUtils.equals("atmcBatchDataService", processor.getServiceName()) && taskWithBacklogData != null) {
                processor.setTaskWithBacklogDataList(Lists.newArrayList(taskWithBacklogData));
                processor.setProjectData(projectData);
            }
        }
        return processors;
    }
}
