package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>功能描述：DataSource 构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataSourceDTOFactory.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 18:19
 */
public final class DataSourceDTOFactory {
    public static PcUiBotDataSourceDTO createDataSource(List<PcUiBotQueryAction> actionList, List<PcUiBotTmDataProcess> dataSourceProcessors, String key, PcUiBotTmQueryAction tmAction) {
        if (actionList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            List<PcUiBotDataSourceDTO> unionItems = new ArrayList<>();
            int count = 1;
            for (PcUiBotQueryAction action : actionList) {
                PcUiBotDataSourceDTO dataSourceBase = DataSourceDTOFactory.create(tmAction, action, key + count, dataSourceProcessors, false);
                if (dataSourceBase != null) {
                    unionItems.add(dataSourceBase);
                }
                count++;
            }
            unionDataSource.setActionId(actionList.get(0).getActionId());
            unionDataSource.setName(key);
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(tmAction.getDataKeys());
            unionDataSource.setMetadataFields(tmAction.getMetadataFields());
            unionDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_UNION);
            return unionDataSource;
        } else {

            if (CollectionUtils.isEmpty(actionList)) {
                return null;
            }
            PcUiBotQueryAction action = actionList.get(0);
            PcUiBotDataSourceDTO dataSource = DataSourceDTOFactory.create(tmAction, action, key, dataSourceProcessors, false);
            return dataSource;
        }
    }

    public static PcUiBotDataSourceDTO create(PcUiBotTmQueryAction tmAction, PcUiBotQueryAction action, String key, List<PcUiBotTmDataProcess> dataSourceProcessors, boolean isRoot) {
        if (StringUtils.isEmpty(key) && tmAction != null) {
            key = tmAction.getName();
        }
        PcUiBotDataSourceDTO dataSource = null;
        switch (action.getCategory()) {
            case PcUiBotConstants.ACTION_CATEGORY_ESP: {
                PcUiBotDataSourceDTO espDataSource = new PcUiBotDataSourceDTO();
                espDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_ESP);
                dataSource = espDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_TM: {
                List<String> dataKeys = Lists.newArrayList("sm_iqc.get.old","sm_iqc.get.new",
                        "athena_MechanismRecordGet","athena_TimeIntervalCodeGet");
                if(dataKeys.contains(action.getActionId())){
                    PcUiBotDataSourceDTO tmDataSource = new PcUiBotDataSourceDTO();
                    tmDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_TM);
                    dataSource = tmDataSource;
                }
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_RAW_DATA: {
                PcUiBotDataSourceDTO rawDataSource = new PcUiBotDataSourceDTO();
                rawDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_RAW_DATA);
                rawDataSource.setName(key);
                if (!org.springframework.util.CollectionUtils.isEmpty(action.getParas())) {
                    HashMap value = (HashMap) action.getParas();
                    rawDataSource.setRawData(value);
                }
                dataSource = rawDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_SD: {
                PcUiBotDataSourceDTO sdDataSource = new PcUiBotDataSourceDTO();
                sdDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_SD);
                dataSource = sdDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_ATMC_CHANGE: {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_ATMC_CHANGE);
                dataSource = changeTaskDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_ATMC: {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_ATMC);
                dataSource = changeTaskDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_LCDP: {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_LCDP);
                dataSource = changeTaskDataSource;
                break;
            }
            case PcUiBotConstants.ACTION_CATEGORY_PTM_DATA: {
                PcUiBotDataSourceDTO ptmDataSource = new PcUiBotDataSourceDTO();
                ptmDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_PTM_DATA);
                dataSource = ptmDataSource;
                break;
            }
            default: {
                break;
            }
        }
        if (dataSource != null) {
            dataSource.setAction(action);
            dataSource.setActionId(tmAction.getActionId());//NOSONAR
            dataSource.setName(key);
            dataSource.setDataSourceProcessors(dataSourceProcessors);
            dataSource.setDataKeys(tmAction.getDataKeys());
            dataSource.setLimit(tmAction.getLimit());
            dataSource.setNotArray(tmAction.getNotArray());
            dataSource.setOverride(tmAction.getOverride());
            //只有根节点才需要添加元数据
            if (isRoot) {
                dataSource.setMetadataFields(tmAction.getMetadataFields());
            }
        }
        return dataSource;
    }
}
