package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * <p>功能描述：用于处理DSL反解析组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DslAllFieldsService.java
 * @Author: wangjwc
 * @Date: created at 2023/12/26 11:45
 */
@Service
public class DslAllFieldsService {

    @Autowired
    private MetadataService metadataService;

    @Autowired
    private AllFieldsService allFieldsService;

    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

//    /**
//     * 将源对象的allFields复制到目标对象
//     *
//     * @param source
//     * @param target
//     */
//    public void copy(GeneralContainComponent source, GeneralContainComponent target) {
//        if (source == null || CollectionUtils.isEmpty(source.getGroup())
//                || target == null || CollectionUtils.isEmpty(target.getGroup())) {
//            return;
//        }
//        // 目前都暂取第一个
//        AbstractComponent sourceFirstLayout = source.getGroup().get(0);
//        AbstractComponent targetFirstLayout = target.getGroup().get(0);
//        ReflectUtil.setFieldValue(targetFirstLayout, "allFields",
//                ReflectUtil.getFieldValue(sourceFirstLayout, "allFields"));
//    }

//    /**
//     * 根据DSL生成allFields
//     *
//     * @param allFields
//     * @param group
//     */
//    public void buildAllFields(List<AllFields> allFields, AbstractComponent group) {
//        List<String> types = Arrays.asList("DATE_RANGE", "TIME_RANGE");
//        AllFields allField = new AllFields();
//        allFields.add(allField);
//        allField.setName(group.getSchema());
//        allField.setDataType(group.getDataType());
//        if (types.contains(group.getType())) {
//            allField.setDataType("string");
//        }
//        allField.setHeaderName(group.getHeaderName());
//        allField.setLevel(0);
//        allField.setIsShow(true);
//        allField.setIsDataKey(false);
//        allField.setSort(false);
//        allField.setPath(group.getPath());
//        String dataType = StringUtils.isEmpty(group.getDataType()) ? "string" : group.getDataType();
//        switch (dataType) {
//            case "number":
//            case "numeric":
//            case "boolean":
//                allField.setDefaultValue(null);
//                break;
//            case "object":
//                allField.setDefaultValue(new HashMap<>());
//                break;
//            case "array":
//                allField.setDefaultValue(new ArrayList<>());
//                break;
//            default:
//                allField.setDefaultValue("");
//                break;
//        }
//        if (group instanceof EocSelectComponent) {
//            EocSelectComponent component = (EocSelectComponent) group;
//            addEocScheamsToAllFields(allFields, group, allField, component.getSchemas());
//        }
//        if (group instanceof EocMultiSelectFormComponent) {
//            EocMultiSelectFormComponent component = (EocMultiSelectFormComponent) group;
//            addEocScheamsToAllFields(allFields, group, allField, component.getSchemas());
//        }
//        if (group instanceof FormAttachmentComponent) {
//            Map defValue = new HashMap();
//            defValue.put("data", new ArrayList<>());
//            defValue.put("row_data", "");
//            allField.setDefaultValue(defValue);
//            allField.setDataType("object");
//        }
//        if (group instanceof FormComponent) {
//            FormComponent formComponent = (FormComponent) group;
//            this.extraFromForm(allFields, formComponent);
//        }
//        // 删除名字为空的无效字段
//        allFields.removeIf(field -> StringUtils.isBlank(field.getName()));
//    }

//    private void extraFromForm(List<AllFields> allFields, FormComponent formComponent) {
//        for (AbstractComponent component : formComponent.getGroup()) {
//            this.buildAllFields(allFields, component);
//        }
//    }

//    private void addEocScheamsToAllFields(List<AllFields> allFields, AbstractComponent group, AllFields allField, List<String> schemas) {
//        if (CollectionUtils.isEmpty(schemas)) {
//            return;
//        }
//        for (String schema : schemas) {
//            if (!schema.equals(group.getSchema())) {
//                AllFields field = new AllFields();
//                BeanUtils.copyProperties(allField, field);
//                field.setName(schema);
//                allFields.add(field);
//            }
//        }
//    }

    private PcUiBotApiMetadata getApiMetadata(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, String actionId) {
        PcUiBotApiMetadata apiMetadata = new PcUiBotApiMetadata();
        if (queryResultSet != null) {
            QueryResult queryResult = queryResultSet.getMainQueryResult();
            if (queryResult.getApiMetadataCollection() != null) {
                apiMetadata = queryResult.getApiMetadataCollection().getMasterApiMetadata();
            } else if (StringUtils.isNotBlank(actionId)) {
                apiMetadata = this.getMetadata(executeContext, actionId);
                if (apiMetadata == null) {
                    apiMetadata = new PcUiBotApiMetadata();
                }
                PcUiBotApiMetadataCollection apiMetadataCollection = PcUiBotApiMetadataCollection.empty();
                if (pageDefine.getDataSourceSet().getFirstDataQuery() != null && pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray() != null
                        && CollectionUtils.isNotEmpty(apiMetadata.getResponseFields()) && apiMetadata.getResponseFields().size() > 0) {
                    apiMetadata.getResponseFields().get(0).setArray(!pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray());
                }
                //xuxx add 根据数据源配置字段信息拼接元数据
                if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                    apiMetadata.addResponseFields(pageDefine.getDataSourceSet().getFirstDataQuery().getMetadataFields());
                }
                apiMetadataCollection.setMasterApiMetadata(apiMetadata);
                queryResult.withMetaData(apiMetadataCollection);
            }
            //处理元数据与datasource的key不一致问题
            PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);
        } else if (StringUtils.isNotBlank(actionId)) {
            apiMetadata = this.getMetadata(executeContext, actionId);
            if (apiMetadata == null) {
                apiMetadata = new PcUiBotApiMetadata();
            }
            if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                apiMetadata.addResponseFields(pageDefine.getDataSourceSet().getFirstDataQuery().getMetadataFields());
                //处理元数据与datasource的key不一致问题
                PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);
            }
        }
        if (apiMetadata == null) {
            apiMetadata = new PcUiBotApiMetadata();
        }
        return apiMetadata;
    }

    private PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        if (!org.springframework.util.StringUtils.hasText(actionId)) {
            return null;
        }
        // 调用知识图谱的API，获取数据源对应行动（Action）的元数据
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(),
                                executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables("actionId", actionId)
                        .build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult =
                this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    /**
     * 根据元数据构建allFields
     *
     * @param executeContext
     * @param pageDefine
     * @param queryResultSet
     * @param metadataName   字段名，一般是对象字段
     * @return metadataName子字段的allFields
     */
    public List<PcUiBotAllFields> buildAllFieldsFromApiMetadata(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, String metadataName) {
        List<PcUiBotAllFields> allFields = Lists.newArrayList();
        bulidAllFieldsByActionId(executeContext, pageDefine, queryResultSet, null, allFields, metadataName);
        return allFields;
    }

    public void bulidAllFieldsByActionId(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, String actionId, List<PcUiBotAllFields> allFields, String metadataName) {
        //得到当前API的元数据
        PcUiBotApiMetadata apiMetadata = getApiMetadata(executeContext, queryResultSet, pageDefine, actionId);
        //根据当前容器拿出对应的子集元数据
        PcUiBotApiMetadata apiMetadataT = PcUiBotApiMetadataUtil.getApiMetadataByMetaName(metadataName, apiMetadata);
        if (CollectionUtils.isNotEmpty(apiMetadataT.getResponseFields())) {
            List<String> dataKeys;
            if (pageDefine != null
                    && pageDefine.getDataSourceSet() != null
                    && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                dataKeys = pageDefine.getDataSourceSet().getFirstDataQuery().getDataKeys();
            } else {
                dataKeys = PcUiBotApiMetadataUtil.getDataKeys(apiMetadataT.getResponseFields().get(0).getSubFields());
            }
            allFields.addAll(allFieldsService.showAllFields(executeContext, apiMetadataT.getResponseFields().get(0), apiMetadataT, null, null, dataKeys));
        }
    }
}
