package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：处理原始 PageData 数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DslPageDataSetService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/23 16:50
 */
@Service
public class DslPageDataSetService {

    @Autowired
    private DslAllFieldsService dslAllFieldsService;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    /**
     * 初始化 pageData
     * 1、如果API有返回data直接返回；
     * 2、如果API无返回data需要构建空对象：（Form_list则需要构建所有对象字段、TABLE则需空数组对象即可）
     *
     * @param executeContext
     * @param pageDefine
     * @param queryResultSet
     * @param page
     */
    public void getPageDataSet(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, UiBotModel page) {
        // 从查询结果的api元数据中获取单头字段名，作为数据源名称
        // 参考：BaseDataDesignerDocumentPageBuilder.createPage
        if (queryResultSet == null) {
//            page.setPageCountSize(0);
            return;
        }

        String dataSourceName = queryResultSet.getDataSourceNameFromApiResp();
        if (StringUtils.isBlank(dataSourceName)) {
            dataSourceName = this.getFirstContainerSchema(pageDefine.getPageLayout());
        }

        //这里需要为了兼容tag转dsl时以数据源名称为M的逻辑
        if (Boolean.TRUE.equals(pageDefine.getMasterFromDataSourceName())) {
            dataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        }

        queryResultSet.getMainQueryResult().setDataSourceName(dataSourceName);
        // 重置dataSourceSet的数据源名称
        PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
        dataSourceSet.setMainDatasource(dataSourceName);

        // 数据主键
        List<String> dataKeys = null;
        PcUiBotDataSourceDTO firstDataQuery = dataSourceSet.getFirstDataQuery();
        if (firstDataQuery != null) {
            dataKeys = firstDataQuery.getDataKeys();
            // 重置主数据源名称
            firstDataQuery.setName(dataSourceName);
        }

        // 包装在dataSourceName下的数据主键
        Map<String, List<String>> pageDataKeys;
        if (!CollectionUtils.isEmpty(dataKeys)) {
            pageDataKeys = new HashMap<>();
            pageDataKeys.put(dataSourceName, dataKeys);
        } else {
            pageDataKeys = queryResultSet.getPageDataKeys();
        }

        // 重置查询结果的数据源名称，用于设置pageData
        if (!CollectionUtils.isEmpty(queryResultSet.getPageData())) {
            String finalDataSourceName = dataSourceName;
            queryResultSet.getQueryResults().forEach(qr -> qr.setDataSourceName(finalDataSourceName));
        } else {
            // 判断单头是否为数组；queryResultSet.getPageData(allFields)方法，会根据是否为数组构建不同的pageData
            PcUiBotMetadataField masterField = queryResultSet.getMasterField();
            boolean single = masterField != null && !masterField.isArray();
            queryResultSet.appendData(QueryResult.empty(dataSourceName, single));
        }
        //构建的allFields，通过DSL反推生成的元数据
        List<PcUiBotAllFields> allFields = dslAllFieldsService.buildAllFieldsFromApiMetadata(executeContext, pageDefine, queryResultSet, dataSourceName);

        page.getPageData().putAll(queryResultSet.getPageData(allFields));
        page.setPageDataKeys(JsonUtil.objectToJavaObject(pageDataKeys, UiBotPageData.class));
        page.setPageDataIndex(JsonUtil.objectToJavaObject(queryResultSet.getPageDataIndex(), UiBotPageData.class));
//        page.setPageCountSize(queryResultSet.getMainQueryResult().size());
    }

    private String getFirstContainerSchema(List<UiBotPageLayout> pageLayout) {
        String containerComponentSchema = "";
        if (CollectionUtils.isEmpty(pageLayout)) {
            return containerComponentSchema;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);

        if (mainPageLayout == null) {
            return containerComponentSchema;
        }
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = mainPageLayout.getBody();
        if (CollectionUtils.isEmpty(body)) {
            return containerComponentSchema;
        }
        return body.get(0).getSchema();
    }
}
