package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotUnEditableTagUtils;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：只是用于字段是否可以编辑   处理主数据的字段是否可以编辑</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EditRangeService.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 16:35
 */
@Service
public class EditRangeService {

    public void tagEditRange(List<PcUiBotSubmitAction> submitActions, List<PcUiBotMetadataField> apiMetadataFields, boolean businessKeyCanEdit) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        if (apiMetadataFields == null) {
            return;
        }
        //获取所有的参数
        HashSet<String> parameterMappingSet = new HashSet<>();
        generateAllActionParameterMapping(submitActions, parameterMappingSet);
        if (parameterMappingSet.size() > 0) {
            tagEditRangBySubmitAction(apiMetadataFields, parameterMappingSet, businessKeyCanEdit);
        }
        addShowEditFields(apiMetadataFields, submitActions);
    }

    private void generateAllActionParameterMapping(List<PcUiBotSubmitAction> submitActions, HashSet<String> parameterMappingSet) {
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (CollectionUtils.isNotEmpty(submitAction.getActionParams())) {
                for (PcUiBotActionParameterMapping actionParam : submitAction.getActionParams()) {
                    if (!parameterMappingSet.contains(actionParam.getValue())) {
                        parameterMappingSet.add(actionParam.getValue());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(submitAction.getCombineActions())) {
                generateAllActionParameterMapping(submitAction.getCombineActions(), parameterMappingSet);
            }
            if (CollectionUtils.isNotEmpty(submitAction.getAttachActions())) {
                generateAllActionParameterMapping(submitAction.getAttachActions(), parameterMappingSet);
            }
        }
    }


    //todo: 这里目前就机制选择作业会用到，需要后续移除到特殊的pattern中

    /**
     * 强制显示字段
     *
     * @param apiMetadataFieldList
     * @param submitActions
     */
    private void addShowEditFields(List<PcUiBotMetadataField> apiMetadataFieldList, List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (CollectionUtils.isNotEmpty(submitAction.getAddShowFileds())) {
                addEditFieldByAction("", apiMetadataFieldList, submitAction.getAddShowFileds());
            }
        }
    }

    /**
     * 根据元数据来映射编辑字段
     *
     * @return actionParamsType
     */
    private boolean addEditFieldByAction(String subFieldName, List<PcUiBotMetadataField> apiMetadataFieldList, List<Map<String, String>> addShowFileds) {
        boolean subEditState = false;
        for (PcUiBotMetadataField metadataField : apiMetadataFieldList) {
            String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName(subFieldName, metadataField);
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                boolean subState = addEditFieldByAction(pathFieldName, metadataField.getSubFields(), addShowFileds);
                if (subState) {
                    metadataField.setCanEdit(true);
                }
            }
            for (Map<String, String> addShowFiled : addShowFileds) {
                if (pathFieldName.equals(addShowFiled.get("filed"))) {
                    metadataField.setCanEdit(true);
                    subEditState = true;
                }
            }
        }
        return subEditState;
    }


    private void tagEditRangBySubmitAction(List<PcUiBotMetadataField> metadataFieldList, HashSet<String> parameterMappingMap, boolean businessKeyCanEdit) {
        for (String fullPath : parameterMappingMap) {
            for (PcUiBotMetadataField metadataField : metadataFieldList) {
                PcUiBotMetadataField existField = metadataField.findByFullPath(fullPath);
                if (existField != null && (businessKeyCanEdit || !existField.isBusinessKey())) {
                    //如果有不可编辑的tag，则标记为非可编辑
                    if (PcUiBotUnEditableTagUtils.analysisTagNotMove(existField)) {
                        existField.setCanEdit(false);
                    } else {
                        existField.setCanEdit(true);
                        PcUiBotMetadataField parentField = existField.getParentField();
                        while (parentField != null) {
                            parentField.setCanEdit(true);
                            parentField = parentField.getParentField();
                        }
                    }
                    if (fullPath.contains(".")) {
                        String[] paths = fullPath.split("\\.");
                        if (paths[1].equals(existField.getName())) {
                            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(existField.getDataType())
                                    && CollectionUtils.isNotEmpty(existField.getSubFields())) {
                                allEdit(existField.getSubFields(), existField.isCanEdit(), businessKeyCanEdit);
                            }
                        }
                    } else {
                        if (metadataField.getName().equals(existField.getName())) {
                            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(existField.getDataType())
                                    && CollectionUtils.isNotEmpty(existField.getSubFields())) {
                                allEdit(existField.getSubFields(), existField.isCanEdit(), businessKeyCanEdit);
                            }
                        }
                    }
                }
                if (existField != null) {
                    break;
                }
            }
        }
    }

    private void allEdit(List<PcUiBotMetadataField> metadataFieldList, boolean isEdit, boolean isBizKeyCanEdit) {
        if (CollectionUtils.isEmpty(metadataFieldList)) {
            return;
        }
        for (PcUiBotMetadataField subMeta : metadataFieldList) {
            if (PcUiBotUnEditableTagUtils.analysisTagNotMove(subMeta)) {
                subMeta.setCanEdit(false);
            } else {
                // 非主键、非DataKey
                if ("false".equals(subMeta.getDataKey()) || !subMeta.isBusinessKey()) {
                    subMeta.setCanEdit(isEdit);
                }
                // 是主键但是主键允许编辑，如：基础资料录入
                else if (isBizKeyCanEdit) {
                    subMeta.setCanEdit(isEdit);
                } else {
                    subMeta.setCanEdit(false);
                }
            }
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subMeta.getDataType())) {
                allEdit(subMeta.getSubFields(), subMeta.isCanEdit(), isBizKeyCanEdit);
            }
        }
    }

    public void allEidtToSingle(List<PcUiBotMetadataField> metadataFieldList, boolean isEidt) {
        if (CollectionUtils.isEmpty(metadataFieldList)) {
            return;
        }
        for (PcUiBotMetadataField subMeta : metadataFieldList) {
            if (PcUiBotUnEditableTagUtils.analysisTagNotMove(subMeta)) {
                subMeta.setCanEdit(false);
            } else {
                subMeta.setCanEdit(isEidt);
            }
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subMeta.getDataType())) {
                allEidtToSingle(subMeta.getSubFields(), subMeta.isCanEdit());
            }
        }
    }


}
