package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Service
public class FlatMetadataByTagService {

    public boolean isMetadataTag(PcUiBotApiMetadata apiMetadata) {
        boolean istMetaTag = false;
        List<PcUiBotMetadataField> headOriginalMetadata = apiMetadata.getResponseFields();
        for (PcUiBotMetadataField subMetadataField : headOriginalMetadata) {
            istMetaTag = isFlatMetadataTag(subMetadataField);
        }
        return istMetaTag;
    }

    /**
     * 用于判断是否打了BUSINESS_FLAT_METADATA tag
     *
     * @param metadataField
     * @return
     */
    public boolean isFlatMetadataTag(PcUiBotMetadataField metadataField) {
        if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                && metadataField.isArray()
                && !CollectionUtils.isEmpty(metadataField.getSubFields())) {
            List<PcUiBotTagDefinition> tagDefinitionsSub = metadataField.getTagDefinitions();
            PcUiBotTagDefinition tagDefinitionSub = PcUiBotTagUtil.getTagDefByStartCode(tagDefinitionsSub, PcUiBotTagConstant.BUSINESS_FLAT_METADATA);
            if (tagDefinitionSub == null) {
                tagDefinitionSub = PcUiBotTagUtil.getTagDefByStartCode(tagDefinitionsSub, PcUiBotTagConstant.DISPALY_FLAT_METADATA);
            }
            if (tagDefinitionSub != null) {
                return true;
            } else {
                boolean istag = false;
                for (PcUiBotMetadataField subField : metadataField.getSubFields()) {
                    istag = isFlatMetadataTag(subField);
                    if (istag) {
                        break;
                    }
                }
                return istag;
            }
        }
        return false;
    }


    public boolean isRenderFlatMetadataComponent(PcUiBotExecuteContext executeContext, PcUiBotMetadataField originalMetadata) {
        if (originalMetadata != null) {
            List<PcUiBotTagDefinition> tagDefinitions = originalMetadata.getTagDefinitions();
            PcUiBotTagDefinition tagDefinition = PcUiBotTagUtil.getTagDefByStartCode(tagDefinitions, PcUiBotTagConstant.BUSINESS_FLAT_METADATA);
            if (tagDefinition == null) {
                tagDefinition = PcUiBotTagUtil.getTagDefByStartCode(tagDefinitions, PcUiBotTagConstant.DISPALY_FLAT_METADATA);
            }
            if (tagDefinition != null) {
                executeContext.setIsRowSpanTree(true);
                return true;
            }
            if (originalMetadata.getSubFields() != null && originalMetadata.getSubFields().size() == 0) {
                return false;
            }

        }
        return false;
    }

    /**
     * 解析平铺tag
     *
     * @param apiMetadata
     * @return
     */
    public void flatMetadata(PcUiBotExecuteContext executeContext, PcUiBotApiMetadata apiMetadata) {
        List<PcUiBotMetadataField> headOriginalMetadata = apiMetadata.getResponseFields();
        List<PcUiBotMetadataField> tagMetadata = new ArrayList<>();
        for (PcUiBotMetadataField subMetadataField : headOriginalMetadata) {
            //直接处理第二层，默认第一层是root
            List<PcUiBotMetadataField> needShowSubFields = getMetadataField(executeContext, subMetadataField);
            if (needShowSubFields.size() > 0) {
                tagMetadata.add(subMetadataField.clone(null, needShowSubFields));
            }
        }
        if (tagMetadata.size() > 0) {
            apiMetadata.setResponseFields(tagMetadata);
            PcUiBotApiMetadataUtil.flatMetaDataNotFlatPath(apiMetadata);
        }
    }

    private List<PcUiBotMetadataField> getMetadataField(PcUiBotExecuteContext executeContext, PcUiBotMetadataField metadataField) {
        List<PcUiBotMetadataField> subFields = new ArrayList<>();
        if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                && metadataField.isArray()
                && !CollectionUtils.isEmpty(metadataField.getSubFields())) {
            for (PcUiBotMetadataField subMeta : metadataField.getSubFields()) {
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subMeta.getDataType())
                        && subMeta.isArray()
                        && !CollectionUtils.isEmpty(subMeta.getSubFields())) {
                    if (isRenderFlatMetadataComponent(executeContext, subMeta)) {
                        appendSubMetadata(executeContext, subMeta, subFields);
                    } else {
                        List<PcUiBotMetadataField> subMetaFields = getMetadataField(executeContext, subMeta);
                        if (!CollectionUtils.isEmpty(subMetaFields)) {
                            subMeta.setSubFields(subMetaFields);
                        }
                        subFields.add(subMeta);
                    }
                } else {
                    subFields.add(subMeta);
                }
            }
            metadataField.setSubFields(subFields);
        }
        return subFields;
    }

    private void appendSubMetadata(PcUiBotExecuteContext executeContext, PcUiBotMetadataField metadataField, List<PcUiBotMetadataField> subFields) {
        List<PcUiBotMetadataField> subSubFields = new ArrayList<>();
        for (PcUiBotMetadataField subMeta : metadataField.getSubFields()) {
            if (isRenderFlatMetadataComponent(executeContext, subMeta)) {
                appendSubMetadata(executeContext, subMeta, subSubFields);
            } else {
                subSubFields.add(subMeta);
            }
        }
        subFields.addAll(subSubFields);
    }
}
