package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：dataSource 业务逻辑处理层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: GeneralDataSourceService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 16:36
 */
@Service
public class GeneralDataSourceService extends DataSourceAnalysisServiceBase {

    /**
     * 为基础数据录入解析数据源，只支持Esp数据源
     *
     * @param executeContext
     * @param dataSources
     * @return
     */
    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, Map<String, PcUiBotTmQueryAction> dataSources) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (CollectionUtils.isEmpty(dataSources)) {
            return dataSourceSet;
        }

        dataSourceSet.setDataSourceList(Lists.newArrayList());
        List<PcUiBotDataSourceDTO> dataSourceList = dataSourceSet.getDataSourceList();

        for (Map.Entry<String, PcUiBotTmQueryAction> tmQueryActionEntry : dataSources.entrySet()) {
            PcUiBotTmQueryAction queryAction = tmQueryActionEntry.getValue();
            PcUiBotDataSourceDTO dataSourceBase = createDataSourceWithoutTask(executeContext, tmQueryActionEntry.getKey(), queryAction);

            if (dataSourceBase != null) {
                // 查询前多少行数据
                dataSourceBase.setLimit(queryAction.getLimit());
                dataSourceBase.setNotArray(queryAction.getNotArray());
                dataSourceBase.setMetadataFields(queryAction.getMetadataFields());
                dataSourceBase.setTitle(queryAction.getTitle());
                dataSourceList.add(dataSourceBase);
            }
        }

        return dataSourceSet;
    }


}
